/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.context;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.devacfr.maven.skins.reflow.ISkinConfig;
import org.devacfr.maven.skins.reflow.SkinConfigTool;
import org.devacfr.maven.skins.reflow.context.Context;
import org.devacfr.maven.skins.reflow.context.ContextType;
import org.devacfr.maven.skins.reflow.model.Toc;

public class FrameContext
extends Context<FrameContext> {
    private final String documentParent;
    private final Toc<?> toc;

    public FrameContext(@Nonnull ISkinConfig config, @Nonnull String documentParent) {
        super(config, ContextType.frame);
        this.toc = Toc.createSidebar(config);
        this.documentParent = Objects.requireNonNull(documentParent);
        this.addChildren(this.toc);
    }

    public String getDocumentParent() {
        return this.documentParent;
    }

    public String getSlugDocumentParent() {
        return SkinConfigTool.slugFilename(this.documentParent);
    }

    public Toc<?> getToc() {
        return this.toc;
    }
}

