/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.model;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.devacfr.maven.skins.reflow.HtmlTool;
import org.devacfr.maven.skins.reflow.ISkinConfig;

public abstract class Component {
    private String cssClass;
    private final List<String> cssOptions = Lists.newArrayList();
    private final List<Component> children = Lists.newArrayList();

    @Nonnull
    public String getCssClass() {
        if (Strings.isNullOrEmpty((String)this.cssClass)) {
            return "";
        }
        return this.cssClass;
    }

    protected void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Nonnull
    public final String getCssOptions() {
        return FluentIterable.concat(this.cssOptions, (Iterable)FluentIterable.concat((Iterable)FluentIterable.from(this.children).transform(component -> component.cssOptions))).join(Joiner.on((char)' '));
    }

    protected void addChildren(Component ... components) {
        this.children.addAll(Lists.newArrayList((Object[])components));
    }

    protected final void addCssOptions(String ... cssOptions) {
        this.cssOptions.addAll(Lists.newArrayList((Object[])cssOptions));
    }

    protected String onPreRender(@Nonnull ISkinConfig skinConfig, @Nonnull String bodyContent) {
        StringBuilder str = new StringBuilder(bodyContent);
        this.children.forEach(component -> {
            String content = str.toString();
            str.setLength(0);
            str.append(component.onPreRender(skinConfig, content));
        });
        return str.toString();
    }

    protected HtmlTool getHtmlTool(@Nonnull ISkinConfig skinConfig) {
        return Objects.requireNonNull(skinConfig).getToolbox("htmlTool", HtmlTool.class);
    }

    protected String getBodyContent(@Nonnull ISkinConfig skinConfig) {
        return Objects.requireNonNull(skinConfig).getContextValue("bodyContent", String.class);
    }
}

