/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.model;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.devacfr.maven.skins.reflow.ISkinConfig;
import org.devacfr.maven.skins.reflow.model.BsComponent;
import org.devacfr.maven.skins.reflow.model.Menu;

public class Footer
extends BsComponent {
    private static final String COMPONENT = "footer";
    private final List<Column> columns = Lists.newArrayList();

    public Footer(@Nonnull ISkinConfig config) {
        super(COMPONENT);
        Objects.requireNonNull(config);
        this.setTheme(config.getAttributeValue(COMPONENT, "theme", String.class, "light"));
        this.setBackground(config.getAttributeValue(COMPONENT, "background", String.class, "light"));
        this.setCssClass(config.getAttributeValue(COMPONENT, "cssClass", String.class, null));
        Xpp3Dom bottomNav = config.get("bottomNav");
        DecorationModel decoration = config.getDecoration();
        if (decoration.getBody() != null && decoration.getBody().getMenus() != null) {
            List menus = decoration.getBody().getMenus();
            if (bottomNav != null && bottomNav.getChildren().length > 0) {
                for (Xpp3Dom col : bottomNav.getChildren()) {
                    String regex = col.getValue();
                    if (Strings.isNullOrEmpty((String)regex)) continue;
                    ArrayList amenus = Lists.newArrayList();
                    for (org.apache.maven.doxia.site.decoration.Menu menu : menus) {
                        if (!Menu.matches(regex, menu)) continue;
                        amenus.add(new Menu(config, menu));
                    }
                    this.columns.add(new Column(config, amenus));
                }
            } else {
                ArrayList amenus = Lists.newArrayList();
                for (org.apache.maven.doxia.site.decoration.Menu menu : menus) {
                    amenus.add(new Menu(config, menu));
                }
                this.columns.add(new Column(config, amenus));
            }
        }
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public static class Column {
        private final List<Menu> menus;

        public Column(@Nonnull ISkinConfig config, @Nonnull List<Menu> menus) {
            Objects.requireNonNull(config);
            Objects.requireNonNull(menus);
            this.menus = menus;
        }

        public List<Menu> getMenus() {
            return this.menus;
        }
    }
}

