/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.model;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.devacfr.maven.skins.reflow.ISkinConfig;
import org.devacfr.maven.skins.reflow.model.BsComponent;

public class Header
extends BsComponent {
    private static final String COMPONENT = "header";
    private static final List<String> HEADER_TYPES = Lists.newArrayList((Object[])new String[]{"jumbotron", "banner", "custom"});
    private boolean enabled = true;
    private String type;
    private String content;

    public Header(@Nonnull ISkinConfig config) {
        super(COMPONENT);
        Objects.requireNonNull(config);
        this.setTheme(config.getAttributeValue(COMPONENT, "theme", String.class, null));
        this.setBackground(config.getAttributeValue(COMPONENT, "background", String.class, null));
        this.setCssClass(config.getAttributeValue(COMPONENT, "cssClass", String.class, null));
        this.type = config.getAttributeValue(COMPONENT, "type", String.class, HEADER_TYPES.get(0)).toLowerCase();
        if (!HEADER_TYPES.contains(this.type)) {
            this.type = HEADER_TYPES.get(0);
        }
        this.enabled = config.getAttributeValue(COMPONENT, "enabled", Boolean.class, Boolean.valueOf(true));
        Xpp3Dom component = config.get(COMPONENT);
        if (component != null) {
            this.content = component.getValue();
            if (!Strings.isNullOrEmpty((String)this.content)) {
                this.type = HEADER_TYPES.get(2);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }
}

