/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.model;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.maven.doxia.site.decoration.LinkItem;
import org.devacfr.maven.skins.reflow.ISkinConfig;
import org.devacfr.maven.skins.reflow.model.MenuItem;

public class Menu {
    private final String name;
    private final String alt;
    private final String border;
    private final String height;
    private final String width;
    private final String href;
    private final String image;
    private final String position;
    private final String target;
    private final String title;
    private final String inherit;
    private final boolean active;
    private final List<MenuItem> menuItems = Lists.newArrayList();

    public Menu(@Nonnull ISkinConfig config, @Nonnull LinkItem item) {
        Objects.requireNonNull(item);
        this.alt = item.getAlt();
        this.border = item.getBorder();
        this.height = item.getHeight();
        this.width = item.getWidth();
        this.href = config.relativeLink(item.getHref());
        this.image = item.getImg();
        this.name = item.getName();
        this.position = item.getPosition();
        this.target = item.getTarget();
        this.title = item.getTitle();
        this.active = config.isActiveLink(this.href);
        this.inherit = null;
    }

    public Menu(@Nonnull ISkinConfig config, @Nonnull org.apache.maven.doxia.site.decoration.Menu menu) {
        Objects.requireNonNull(menu);
        this.alt = menu.getAlt();
        this.border = menu.getBorder();
        this.height = menu.getHeight();
        this.width = menu.getWidth();
        this.href = null;
        this.image = menu.getImg();
        this.name = menu.getName();
        this.position = menu.getPosition();
        this.target = null;
        this.title = menu.getTitle();
        this.inherit = menu.getInherit();
        this.active = false;
        List items = menu.getItems();
        for (org.apache.maven.doxia.site.decoration.MenuItem menuItem : items) {
            if (Strings.isNullOrEmpty((String)menu.getName())) continue;
            this.menuItems.add(new MenuItem(config, menuItem));
        }
    }

    public List<MenuItem> getMenuItems() {
        return this.menuItems;
    }

    public String getName() {
        return this.name;
    }

    public String getInherit() {
        return this.inherit;
    }

    public boolean isActive() {
        MenuItem menuItem;
        boolean active = this.active;
        if (active) {
            return active;
        }
        Iterator<MenuItem> iterator = this.menuItems.iterator();
        while (iterator.hasNext() && !(active = (menuItem = iterator.next()).isActive())) {
        }
        return active;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getBorder() {
        return this.border;
    }

    public String getHeight() {
        return this.height;
    }

    public String getHref() {
        return this.href;
    }

    public String getImage() {
        return this.image;
    }

    public String getPosition() {
        return this.position;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTitle() {
        return this.title;
    }

    public String getWidth() {
        return this.width;
    }

    public static boolean matches(@Nonnull String regex, @Nonnull org.apache.maven.doxia.site.decoration.Menu menu) {
        Objects.requireNonNull(regex);
        Objects.requireNonNull(menu);
        return menu.getRef() != null && menu.getRef().matches(regex) || menu.getName() != null && menu.getName().matches(regex);
    }
}

