/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.model;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.devacfr.maven.skins.reflow.ISkinConfig;

public class MenuItem {
    private final String name;
    private final String description;
    private final String alt;
    private final String border;
    private final String height;
    private final String width;
    private final String href;
    private final String image;
    private final String position;
    private final String target;
    private final String title;
    private final String inherit;
    private final boolean active;
    private final List<MenuItem> menuItems = Lists.newArrayList();

    public MenuItem(@Nonnull ISkinConfig config, org.apache.maven.doxia.site.decoration.MenuItem item) {
        Objects.requireNonNull(item);
        this.alt = item.getAlt();
        this.description = item.getDescription();
        this.border = item.getBorder();
        this.height = item.getHeight();
        this.width = item.getWidth();
        this.href = config.relativeLink(item.getHref());
        this.image = item.getImg();
        this.name = item.getName();
        this.position = item.getPosition();
        this.target = item.getTarget();
        this.title = item.getTitle();
        this.active = config.isActiveLink(this.href);
        this.inherit = null;
        this.recurciveAddItem(config, this.menuItems, item.getItems());
    }

    private void recurciveAddItem(ISkinConfig config, List<MenuItem> menuItems, List<org.apache.maven.doxia.site.decoration.MenuItem> origMenuItems) {
        if (origMenuItems == null) {
            return;
        }
        for (org.apache.maven.doxia.site.decoration.MenuItem menuItem : origMenuItems) {
            menuItems.add(new MenuItem(config, menuItem));
        }
    }

    public String getName() {
        return this.name;
    }

    public List<MenuItem> getMenuItems() {
        return this.menuItems;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInherit() {
        return this.inherit;
    }

    public boolean isActive() {
        MenuItem menuItem;
        boolean active = this.active;
        if (active) {
            return active;
        }
        Iterator<MenuItem> iterator = this.menuItems.iterator();
        while (iterator.hasNext() && !(active = (menuItem = iterator.next()).isActive())) {
        }
        return active;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getBorder() {
        return this.border;
    }

    public String getHeight() {
        return this.height;
    }

    public String getHref() {
        return this.href;
    }

    public String getImage() {
        return this.image;
    }

    public String getPosition() {
        return this.position;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTitle() {
        return this.title;
    }

    public String getWidth() {
        return this.width;
    }
}

