/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.model;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.devacfr.maven.skins.reflow.ISkinConfig;
import org.devacfr.maven.skins.reflow.SkinConfigTool;
import org.devacfr.maven.skins.reflow.Xpp3Utils;
import org.devacfr.maven.skins.reflow.model.BsComponent;
import org.devacfr.maven.skins.reflow.model.SideNavMenuItem;

public class NavSideMenu
extends BsComponent {
    private static final String COMPONENT = "navside-menu";
    private static final String MENU_COMPONENT = "menu";
    private String name;
    private List<SideNavMenuItem> items;
    private boolean selectFirstOnExpand = false;

    @Nonnull
    public static List<SideNavMenuItem> findAllSideNavMenuItems(@Nonnull ISkinConfig config) {
        Objects.requireNonNull(config);
        Xpp3Dom pagesNode = Xpp3Utils.getFirstChild(config.getGlobalProperties(), "pages", config.getNamespace());
        if (pagesNode == null) {
            return Collections.emptyList();
        }
        Xpp3Dom[] pages = pagesNode.getChildren();
        ArrayList<SideNavMenuItem> includePages = new ArrayList<SideNavMenuItem>();
        for (Xpp3Dom page : pages) {
            Xpp3Dom menu;
            String projectId;
            String type = page.getAttribute("type");
            if (!"doc".equals(type) || !Strings.isNullOrEmpty((String)(projectId = page.getAttribute("project"))) && !projectId.equals(config.getProjectId()) || (menu = page.getChild(MENU_COMPONENT)) == null) continue;
            String pageName = page.getName();
            NavSideMenu.addMenuItemRecursively(includePages, config, menu, pageName, true);
        }
        return includePages;
    }

    public NavSideMenu(@Nonnull ISkinConfig config) {
        super("navside");
        Objects.requireNonNull(config);
        Xpp3Dom pageNode = config.getPageProperties();
        Xpp3Dom menu = pageNode.getChild(MENU_COMPONENT);
        ArrayList items = Lists.newArrayList();
        if (menu != null) {
            String pageName = pageNode.getName();
            NavSideMenu.addMenuItemRecursively(items, config, menu, pageName, false);
            this.withName(menu.getAttribute("name")).withItems(items).withSelectFirstOnSelect(config.getAttributeValue(MENU_COMPONENT, "selectFirstOnExpand", Boolean.class, Boolean.valueOf(true)));
            this.setTheme(config.getAttributeValue(COMPONENT, "theme", String.class, "light"));
            this.setBackground(config.getAttributeValue(COMPONENT, "background", String.class, "light"));
            this.setCssClass(config.getAttributeValue(COMPONENT, "cssClass", String.class, null));
        }
        this.addCssOptions("m-sidenav-enabled");
        if (this.isSelectFirstOnExpand()) {
            this.addCssOptions("m-sidenav-select-first-on-select");
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    protected NavSideMenu withName(String name) {
        this.name = name;
        return this;
    }

    public boolean isHasItems() {
        return this.items != null && this.items.size() > 0;
    }

    @Nonnull
    public List<SideNavMenuItem> getItems() {
        return this.items;
    }

    protected NavSideMenu withItems(List<SideNavMenuItem> items) {
        this.items = items;
        return this;
    }

    public boolean isSelectFirstOnExpand() {
        return this.selectFirstOnExpand;
    }

    protected NavSideMenu withSelectFirstOnSelect(boolean selectFirstOnExpand) {
        this.selectFirstOnExpand = selectFirstOnExpand;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private static void addMenuItemRecursively(@Nonnull List<SideNavMenuItem> menuItems, @Nonnull ISkinConfig config, @Nonnull Xpp3Dom parentNode, @Nonnull String pageName, boolean flatten) {
        for (Xpp3Dom item : Xpp3Utils.getChildrenNodes(parentNode, "item")) {
            String href = item.getAttribute("href");
            SideNavMenuItem menuItem = new SideNavMenuItem().withName(item.getAttribute("name")).withParent(pageName).withHref(config.relativeLink(href)).withSlugName(SkinConfigTool.slugFilename(href)).withIcon(item.getAttribute("icon"));
            menuItems.add(menuItem);
            if (flatten) {
                NavSideMenu.addMenuItemRecursively(menuItems, config, item, pageName, true);
                continue;
            }
            ArrayList<SideNavMenuItem> list = new ArrayList<SideNavMenuItem>();
            menuItem.withItems(list);
            NavSideMenu.addMenuItemRecursively(list, config, item, pageName, false);
        }
    }
}

