/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.model;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.LinkItem;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.devacfr.maven.skins.reflow.ISkinConfig;
import org.devacfr.maven.skins.reflow.Xpp3Utils;
import org.devacfr.maven.skins.reflow.model.BsComponent;
import org.devacfr.maven.skins.reflow.model.Menu;

public class Navbar
extends BsComponent {
    public static final String COMPONENT = "navbar";
    private String brandName;
    private String brandHref;
    private final String filterMenu;
    private final boolean center;
    private final String alignMenu;
    private final ImageBrand image;
    private final List<Menu> menus = Lists.newArrayList();

    public Navbar(@Nonnull ISkinConfig config) {
        super(COMPONENT);
        Objects.requireNonNull(config);
        MavenProject project = config.getProject();
        Xpp3Dom brand = config.get("brand");
        if (brand != null) {
            Xpp3Dom href;
            Xpp3Dom name = brand.getChild("name");
            if (name != null) {
                this.brandName = name.getValue();
            }
            if ((href = brand.getChild("href")) != null) {
                this.brandHref = config.relativeLink(href.getValue());
            }
        } else {
            this.brandName = project.getName();
        }
        if (Strings.isNullOrEmpty((String)this.brandName)) {
            this.brandName = project.getArtifactId();
        }
        this.center = config.getAttributeValue(COMPONENT, "center", Boolean.class, Boolean.valueOf(true));
        this.alignMenu = config.getAttributeValue(COMPONENT, "alignMenu", String.class, "right");
        this.setTheme(config.getAttributeValue(COMPONENT, "theme", String.class, "light"));
        this.setBackground(config.getAttributeValue(COMPONENT, "background", String.class, "light"));
        this.setCssClass(config.getAttributeValue(COMPONENT, "cssClass", String.class, null));
        this.filterMenu = config.getAttributeValue(COMPONENT, "filterMenu", String.class, null);
        Xpp3Dom element = config.get(COMPONENT);
        Xpp3Dom img = Xpp3Utils.getFirstChild(element, "image", config.getNamespace());
        this.image = img != null ? new ImageBrand(config, img) : null;
        DecorationModel decoration = config.getDecoration();
        if (decoration.getBody() != null && decoration.getBody().getLinks() != null) {
            List items = decoration.getBody().getLinks();
            for (LinkItem item : items) {
                this.menus.add(new Menu(config, item));
            }
        }
        if (decoration.getBody() != null && decoration.getBody().getMenus() != null) {
            List menus = decoration.getBody().getMenus();
            for (org.apache.maven.doxia.site.decoration.Menu menu : menus) {
                if (Strings.isNullOrEmpty((String)menu.getName())) continue;
                if (Strings.isNullOrEmpty((String)this.filterMenu)) {
                    this.menus.add(new Menu(config, menu));
                    continue;
                }
                if (!Menu.matches(this.filterMenu, menu)) continue;
                this.menus.add(new Menu(config, menu));
            }
        }
    }

    public String getBrandName() {
        return this.brandName;
    }

    public String getBrandHref() {
        return this.brandHref;
    }

    public boolean isCenter() {
        return this.center;
    }

    public String getAlignMenu() {
        return this.alignMenu;
    }

    public ImageBrand getImage() {
        return this.image;
    }

    public String getFilterMenu() {
        return this.filterMenu;
    }

    public List<Menu> getMenus() {
        return this.menus;
    }

    public static class ImageBrand {
        private final String src;
        private final String width;
        private final String height;

        ImageBrand(@Nonnull ISkinConfig config, @Nonnull Xpp3Dom element) {
            Objects.requireNonNull(config);
            Objects.requireNonNull(element);
            String link = config.getAttributeValue(element, "src", String.class, null);
            if (Strings.isNullOrEmpty((String)link)) {
                throw new IllegalArgumentException("the attribute 'href' of image element is required");
            }
            this.src = config.eval(link, String.class);
            this.width = config.getAttributeValue(element, "width", String.class, "30");
            this.height = config.getAttributeValue(element, "height", String.class, "30");
        }

        public String getSrc() {
            return this.src;
        }

        public String getHeight() {
            return this.height;
        }

        public String getWidth() {
            return this.width;
        }
    }
}

