/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.devacfr.maven.skins.reflow.HtmlTool;
import org.devacfr.maven.skins.reflow.ISkinConfig;
import org.devacfr.maven.skins.reflow.Xpp3Utils;
import org.devacfr.maven.skins.reflow.model.BsComponent;
import org.devacfr.maven.skins.reflow.model.TocSidebar;
import org.devacfr.maven.skins.reflow.model.TocTopBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Toc<T extends Toc<?>>
extends BsComponent {
    public static final String COMPONENT = "toc";
    private static final Logger LOGGER = LoggerFactory.getLogger(Toc.class);
    private boolean enabled = true;
    private final String type;

    public static Toc<?> createToc(@Nonnull ISkinConfig config, @Nullable String preferredType) {
        HashSet<String> types;
        Toc toc = null;
        String type = config.getPropertyValue(COMPONENT, String.class, preferredType);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Page '{}' Find Toc: {}", (Object)config.getFileId(), (Object)type);
        }
        if (!(types = new HashSet<String>(Arrays.asList("sidebar", "top", "false"))).contains(type)) {
            type = preferredType;
        }
        if (type == null) {
            type = "";
        }
        switch (type) {
            case "sidebar": {
                toc = Toc.createSidebar(config);
                break;
            }
            case "top": {
                toc = Toc.createTopBar(config);
                break;
            }
            default: {
                toc = new Toc<Toc<?>>("", ""){};
                toc.withEnabled(false);
            }
        }
        return toc;
    }

    public static Toc<?> createSidebar(@Nonnull ISkinConfig config) {
        return new TocSidebar(config);
    }

    public static Toc<?> createTopBar(@Nonnull ISkinConfig config) {
        return new TocTopBar(config);
    }

    protected Toc(String type, String component) {
        super(component);
        this.type = type;
    }

    protected T self() {
        return (T)this;
    }

    public String getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<? extends HtmlTool.IdElement> getTocItems(ISkinConfig skinConfig) {
        HtmlTool htmlTool = this.getHtmlTool(skinConfig);
        String bodyContent = this.getBodyContent(skinConfig);
        List<? extends HtmlTool.IdElement> tocItems = htmlTool.headingTree(bodyContent, Xpp3Utils.getChildren(skinConfig.get("sections")));
        return tocItems;
    }

    protected T withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this.self();
    }

    @Override
    protected String onPreRender(ISkinConfig skinConfig, String bodyContent) {
        if (this.enabled) {
            HtmlTool htmlTool = this.getHtmlTool(skinConfig);
            return htmlTool.ensureHeadingIds(skinConfig.getContext().getType(), skinConfig.getFileId(), bodyContent, "-");
        }
        return bodyContent;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

