/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.model;

import javax.annotation.Nonnull;
import org.devacfr.maven.skins.reflow.ISkinConfig;
import org.devacfr.maven.skins.reflow.model.Toc;

public class TocSidebar
extends Toc<TocSidebar> {
    private boolean fixed = true;
    private boolean expanded = true;
    private boolean autoExpandable = true;
    private int level = 0;

    public TocSidebar(@Nonnull ISkinConfig config) {
        super("sidebar", "sidebar");
        String position = config.getAttributeValue("toc", "position", String.class, "fixed").toLowerCase();
        ((TocSidebar)this.withEnabled(true)).withExpanded(config.getAttributeValue("toc", "expanded", Boolean.class, Boolean.valueOf(true))).withAutoExpandable(config.getAttributeValue("toc", "autoExpandable", Boolean.class, Boolean.valueOf(true))).withFixed("fixed".equals(position)).withLevel(config.getAttributeValue("toc", "level", Integer.class, Integer.valueOf(0)));
        if (this.isEnabled()) {
            this.addCssOptions("m-toc-sidebar-enabled");
        }
        if (this.isExpanded()) {
            this.addCssOptions("m-toc-sidebar-expanded");
        }
        if (this.isAutoExpandable()) {
            this.addCssOptions("m-toc-sidebar-autoexpandable");
        }
        if (this.isFixed()) {
            this.addCssOptions("toc-sidebar-fixed");
        } else {
            this.addCssOptions("toc-sidebar-relative");
        }
    }

    public boolean isFixed() {
        return this.fixed;
    }

    protected TocSidebar withFixed(boolean fixed) {
        this.fixed = fixed;
        return (TocSidebar)this.self();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    protected TocSidebar withExpanded(boolean expanded) {
        this.expanded = expanded;
        return (TocSidebar)this.self();
    }

    public boolean isAutoExpandable() {
        return this.autoExpandable;
    }

    protected TocSidebar withAutoExpandable(boolean autoExpandable) {
        this.autoExpandable = autoExpandable;
        return (TocSidebar)this.self();
    }

    public int getLevel() {
        return this.level;
    }

    protected TocSidebar withLevel(int level) {
        this.level = level < 1 ? Integer.MAX_VALUE : level;
        return (TocSidebar)this.self();
    }
}

