/*
 * Decompiled with CFR 0.152.
 */
package com.allever.lib.common.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.allever.lib.common.R;

public class CommonDialog
extends Dialog {
    private ImageView imageIv;
    private TextView titleTv;
    private TextView messageTv;
    private Button btnNegative;
    private Button btnPositive;
    private View columnLineView;
    private String message;
    private String title;
    private String positive;
    private String negative;
    private int imageResId = -1;
    private boolean isSingle = false;
    public OnClickBottomListener onClickBottomListener;

    public CommonDialog(Context context) {
        super(context, R.style.CommonCustomDialogStyle);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.common_dialog);
        this.setCanceledOnTouchOutside(false);
        this.initView();
        this.refreshView();
        this.initEvent();
    }

    private void initEvent() {
        this.btnPositive.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CommonDialog.this.onClickBottomListener != null) {
                    CommonDialog.this.onClickBottomListener.onPositiveClick();
                }
            }
        });
        this.btnNegative.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CommonDialog.this.onClickBottomListener != null) {
                    CommonDialog.this.onClickBottomListener.onNegativeClick();
                }
            }
        });
    }

    private void refreshView() {
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            this.titleTv.setText((CharSequence)this.title);
            this.titleTv.setVisibility(0);
        } else {
            this.titleTv.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            this.messageTv.setText((CharSequence)this.message);
        }
        if (!TextUtils.isEmpty((CharSequence)this.positive)) {
            this.btnPositive.setText((CharSequence)this.positive);
        } else {
            this.btnPositive.setText((CharSequence)"\u786e\u5b9a");
        }
        if (!TextUtils.isEmpty((CharSequence)this.negative)) {
            this.btnNegative.setText((CharSequence)this.negative);
        } else {
            this.btnNegative.setText((CharSequence)"\u53d6\u6d88");
        }
        if (this.imageResId != -1) {
            this.imageIv.setImageResource(this.imageResId);
            this.imageIv.setVisibility(0);
        } else {
            this.imageIv.setVisibility(8);
        }
        if (this.isSingle) {
            this.columnLineView.setVisibility(8);
            this.btnNegative.setVisibility(8);
        } else {
            this.btnNegative.setVisibility(0);
            this.columnLineView.setVisibility(0);
        }
    }

    public void show() {
        super.show();
        this.refreshView();
    }

    private void initView() {
        this.btnNegative = (Button)this.findViewById(R.id.negative);
        this.btnPositive = (Button)this.findViewById(R.id.positive);
        this.titleTv = (TextView)this.findViewById(R.id.title);
        this.messageTv = (TextView)this.findViewById(R.id.message);
        this.imageIv = (ImageView)this.findViewById(R.id.image);
        this.columnLineView = this.findViewById(R.id.column_line);
    }

    public CommonDialog setOnClickBottomListener(OnClickBottomListener onClickBottomListener) {
        this.onClickBottomListener = onClickBottomListener;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommonDialog setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public CommonDialog setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getPositive() {
        return this.positive;
    }

    public CommonDialog setPositive(String positive) {
        this.positive = positive;
        return this;
    }

    public String getNegative() {
        return this.negative;
    }

    public CommonDialog setNegative(String negative) {
        this.negative = negative;
        return this;
    }

    public int getImageResId() {
        return this.imageResId;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public CommonDialog setSingle(boolean single) {
        this.isSingle = single;
        return this;
    }

    public CommonDialog setImageResId(int imageResId) {
        this.imageResId = imageResId;
        return this;
    }

    public static interface OnClickBottomListener {
        public void onPositiveClick();

        public void onNegativeClick();
    }
}

