/*
 * Decompiled with CFR 0.152.
 */
package com.allever.lib.common.ui.widget.recycler;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.recyclerview.widget.RecyclerView;
import com.allever.lib.common.ui.widget.recycler.BaseViewHolder;
import com.allever.lib.common.ui.widget.recycler.ItemListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\t\u001a\u00020\u0007\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\u001d\u0010\"\u001a\u00020#2\b\b\u0001\u0010%\u001a\u00020\u00072\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J%\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00072\u0006\u0010)\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0007H\u0002J\b\u0010-\u001a\u00020\u0007H\u0016J\u0018\u0010.\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0007H\u0016J\u0018\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0007H\u0016J\u000e\u00103\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0007J\u0016\u00104\u001a\u00020#2\u000e\u00105\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bJ\u000e\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020\u0018J\u000e\u00108\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0007R\u001a\u0010\r\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00069"}, d2={"Lcom/allever/lib/common/ui/widget/recycler/BaseRecyclerViewAdapter;", "T", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/allever/lib/common/ui/widget/recycler/BaseViewHolder;", "context", "Landroid/content/Context;", "layoutRes", "", "(Landroid/content/Context;I)V", "layoutResId", "data", "", "(Landroid/content/Context;ILjava/util/List;)V", "mContext", "getMContext", "()Landroid/content/Context;", "setMContext", "(Landroid/content/Context;)V", "mData", "getMData", "()Ljava/util/List;", "setMData", "(Ljava/util/List;)V", "mItemListener", "Lcom/allever/lib/common/ui/widget/recycler/ItemListener;", "getMItemListener", "()Lcom/allever/lib/common/ui/widget/recycler/ItemListener;", "setMItemListener", "(Lcom/allever/lib/common/ui/widget/recycler/ItemListener;)V", "mLayoutResId", "getMLayoutResId", "()I", "setMLayoutResId", "(I)V", "addData", "", "(Ljava/lang/Object;)V", "position", "(ILjava/lang/Object;)V", "bindHolder", "holder", "item", "(Lcom/allever/lib/common/ui/widget/recycler/BaseViewHolder;ILjava/lang/Object;)V", "compatibilityDataSizeChanged", "size", "getItemCount", "onBindViewHolder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "remove", "setData", "items", "setItemListener", "itemListener", "updateData", "common_release"})
public abstract class BaseRecyclerViewAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder> {
    @NotNull
    private Context mContext;
    private int mLayoutResId;
    @Nullable
    private ItemListener mItemListener;
    @NotNull
    private List<T> mData;

    @NotNull
    protected final Context getMContext() {
        return this.mContext;
    }

    protected final void setMContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.mContext = context;
    }

    protected final int getMLayoutResId() {
        return this.mLayoutResId;
    }

    protected final void setMLayoutResId(int n) {
        this.mLayoutResId = n;
    }

    @Nullable
    public final ItemListener getMItemListener() {
        return this.mItemListener;
    }

    public final void setMItemListener(@Nullable ItemListener itemListener) {
        this.mItemListener = itemListener;
    }

    @NotNull
    public final List<T> getMData() {
        return this.mData;
    }

    public final void setMData(@NotNull List<T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.mData = list;
    }

    @NotNull
    public BaseViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return BaseViewHolder.Companion.getHolder(this.mContext, parent, this.mLayoutResId);
    }

    public void onBindViewHolder(@NotNull BaseViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.itemView.setOnClickListener(new View.OnClickListener(this, position, holder){
            final /* synthetic */ BaseRecyclerViewAdapter this$0;
            final /* synthetic */ int $position;
            final /* synthetic */ BaseViewHolder $holder;

            public final void onClick(View it) {
                block0: {
                    ItemListener itemListener = this.this$0.getMItemListener();
                    if (itemListener == null) break block0;
                    itemListener.onItemClick(this.$position, this.$holder);
                }
            }
            {
                this.this$0 = baseRecyclerViewAdapter;
                this.$position = n;
                this.$holder = baseViewHolder;
            }
        });
        holder.itemView.setOnLongClickListener(new View.OnLongClickListener(this, position, holder){
            final /* synthetic */ BaseRecyclerViewAdapter this$0;
            final /* synthetic */ int $position;
            final /* synthetic */ BaseViewHolder $holder;

            public final boolean onLongClick(View it) {
                ItemListener itemListener = this.this$0.getMItemListener();
                return itemListener != null ? itemListener.onItemLongClick(this.$position, this.$holder) : false;
            }
            {
                this.this$0 = baseRecyclerViewAdapter;
                this.$position = n;
                this.$holder = baseViewHolder;
            }
        });
        this.bindHolder(holder, position, this.mData.get(position));
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public final void setData(@Nullable List<T> items) {
        List list = items;
        if (list == null) {
            list = new ArrayList();
        }
        this.mData = list;
        this.notifyDataSetChanged();
    }

    public final void updateData(int position) {
        this.notifyItemChanged(position, position);
    }

    public final void addData(@IntRange(from=0L) int position, T data) {
        this.mData.add(position, data);
        this.notifyItemInserted(position);
        this.compatibilityDataSizeChanged(1);
    }

    public final void addData(T data) {
        this.mData.add(data);
        this.notifyItemInserted(this.mData.size());
    }

    public final void remove(int position) {
        this.mData.remove(position);
        this.notifyItemRemoved(position);
        this.notifyItemRangeChanged(position, this.mData.size() - position);
    }

    public final void setItemListener(@NotNull ItemListener itemListener) {
        Intrinsics.checkNotNullParameter((Object)itemListener, (String)"itemListener");
        this.mItemListener = itemListener;
    }

    private final void compatibilityDataSizeChanged(int size) {
        int dataSize = this.mData.size();
        if (dataSize == size) {
            this.notifyDataSetChanged();
        }
    }

    public abstract void bindHolder(@NotNull BaseViewHolder var1, int var2, T var3);

    public BaseRecyclerViewAdapter(@NotNull Context context, @LayoutRes int layoutRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mContext = context;
        this.mLayoutResId = layoutRes;
        this.mData = new ArrayList();
    }

    public BaseRecyclerViewAdapter(@NotNull Context context, @LayoutRes int layoutResId, @Nullable List<T> data) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mContext = context;
        List<T> list = data;
        if (list == null) {
            list = this.mData = (List<T>)new ArrayList();
        }
        if (layoutResId != 0) {
            this.mLayoutResId = layoutResId;
        }
    }
}

