/*
 * Decompiled with CFR 0.152.
 */
package com.allever.lib.common.ui.widget.recycler;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.util.Linkify;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import androidx.annotation.IdRes;
import androidx.collection.SparseArrayCompat;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000 A2\u00020\u0001:\u0001AB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\t\u001a\u0004\u0018\u0001H\n\"\b\b\u0000\u0010\n*\u00020\u00052\b\b\u0001\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fJ\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010!\u001a\u00020\fJ\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fJ\u0016\u0010$\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010%\u001a\u00020(J\u0016\u0010)\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010%\u001a\u00020*J\u0016\u0010+\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010,\u001a\u00020\fJ\u001e\u0010+\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fJ\u0016\u0010-\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u0012J\u001e\u0010-\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\fJ\u0016\u0010/\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u00100\u001a\u000201J\u001e\u0010/\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u00102\u001a\u00020\f2\u0006\u00100\u001a\u000201J\u0016\u00103\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u00104\u001a\u000205J\u0016\u00106\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u00107\u001a\u00020\fJ\u0016\u00108\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u00109\u001a\u00020\fJ\u001a\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<2\n\u0010=\u001a\u00020>\"\u00020\fJ\u0016\u0010?\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010@\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/allever/lib/common/ui/widget/recycler/BaseViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "mContext", "Landroid/content/Context;", "itemView", "Landroid/view/View;", "(Landroid/content/Context;Landroid/view/View;)V", "mViews", "Landroidx/collection/SparseArrayCompat;", "getView", "V", "res", "", "(I)Landroid/view/View;", "linkify", "viewId", "setAlpha", "value", "", "setBackgroundColor", "color", "setBackgroundRes", "backgroundRes", "setChecked", "checked", "", "setImageBitmap", "bitmap", "Landroid/graphics/Bitmap;", "setImageDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setImageResource", "resId", "setMax", "max", "setOnClickListener", "listener", "Landroid/view/View$OnClickListener;", "setOnLongClickListener", "Landroid/view/View$OnLongClickListener;", "setOnTouchListener", "Landroid/view/View$OnTouchListener;", "setProgress", "progress", "setRating", "rating", "setTag", "tag", "", "key", "setText", "text", "", "setTextColor", "textColor", "setTextColorRes", "textColorRes", "setTypeface", "typeface", "Landroid/graphics/Typeface;", "viewIds", "", "setVisible", "visible", "Companion", "common_release"})
public final class BaseViewHolder
extends RecyclerView.ViewHolder {
    private final SparseArrayCompat<View> mViews;
    private final Context mContext;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final <V extends View> V getView(@IdRes int res) {
        View view;
        View v = (View)this.mViews.get(res);
        if (v == null) {
            v = this.itemView.findViewById(res);
            this.mViews.put(res, (Object)v);
        }
        if (!((view = v) instanceof View)) {
            view = null;
        }
        return (V)view;
    }

    @NotNull
    public final BaseViewHolder setText(int viewId, @NotNull String text) {
        block0: {
            TextView view;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            TextView textView = view = (TextView)this.getView(viewId);
            if (textView == null) break block0;
            textView.setText((CharSequence)text);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setImageResource(int viewId, int resId) {
        block0: {
            ImageView view;
            ImageView imageView = view = (ImageView)this.getView(viewId);
            if (imageView == null) break block0;
            imageView.setImageResource(resId);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setImageBitmap(int viewId, @NotNull Bitmap bitmap) {
        block0: {
            ImageView view;
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            ImageView imageView = view = (ImageView)this.getView(viewId);
            if (imageView == null) break block0;
            imageView.setImageBitmap(bitmap);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setImageDrawable(int viewId, @NotNull Drawable drawable) {
        block0: {
            ImageView view;
            Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
            ImageView imageView = view = (ImageView)this.getView(viewId);
            if (imageView == null) break block0;
            imageView.setImageDrawable(drawable);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setBackgroundColor(int viewId, int color) {
        block0: {
            Object view;
            Object v = view = this.getView(viewId);
            if (v == null) break block0;
            v.setBackgroundColor(color);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setBackgroundRes(int viewId, int backgroundRes) {
        block0: {
            Object view;
            Object v = view = this.getView(viewId);
            if (v == null) break block0;
            v.setBackgroundResource(backgroundRes);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setTextColor(int viewId, int textColor) {
        block0: {
            TextView view;
            TextView textView = view = (TextView)this.getView(viewId);
            if (textView == null) break block0;
            textView.setTextColor(textColor);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setTextColorRes(int viewId, int textColorRes) {
        block0: {
            TextView view;
            TextView textView = view = (TextView)this.getView(viewId);
            if (textView == null) break block0;
            textView.setTextColor(this.mContext.getResources().getColor(textColorRes));
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setAlpha(int viewId, float value) {
        block0: {
            Object v = this.getView(viewId);
            if (v == null) break block0;
            v.setAlpha(value);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setVisible(int viewId, boolean visible) {
        block0: {
            Object view;
            Object v = view = this.getView(viewId);
            if (v == null) break block0;
            v.setVisibility(visible ? 0 : 8);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder linkify(int viewId) {
        TextView textView = (TextView)this.getView(viewId);
        if (textView == null) {
            return this;
        }
        TextView view = textView;
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    @NotNull
    public final BaseViewHolder setTypeface(@NotNull Typeface typeface, int ... viewIds) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        Intrinsics.checkNotNullParameter((Object)viewIds, (String)"viewIds");
        for (int viewId : viewIds) {
            TextView view = (TextView)this.getView(viewId);
            if (view == null) {
                continue;
            }
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setProgress(int viewId, int progress) {
        block0: {
            ProgressBar view;
            ProgressBar progressBar = view = (ProgressBar)this.getView(viewId);
            if (progressBar == null) break block0;
            progressBar.setProgress(progress);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setProgress(int viewId, int progress, int max) {
        block1: {
            ProgressBar view;
            ProgressBar progressBar = view = (ProgressBar)this.getView(viewId);
            if (progressBar != null) {
                progressBar.setMax(max);
            }
            ProgressBar progressBar2 = view;
            if (progressBar2 == null) break block1;
            progressBar2.setProgress(progress);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setMax(int viewId, int max) {
        block0: {
            ProgressBar view;
            ProgressBar progressBar = view = (ProgressBar)this.getView(viewId);
            if (progressBar == null) break block0;
            progressBar.setMax(max);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setRating(int viewId, float rating) {
        block0: {
            RatingBar view;
            RatingBar ratingBar = view = (RatingBar)this.getView(viewId);
            if (ratingBar == null) break block0;
            ratingBar.setRating(rating);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setRating(int viewId, float rating, int max) {
        block1: {
            RatingBar view;
            RatingBar ratingBar = view = (RatingBar)this.getView(viewId);
            if (ratingBar != null) {
                ratingBar.setMax(max);
            }
            RatingBar ratingBar2 = view;
            if (ratingBar2 == null) break block1;
            ratingBar2.setRating(rating);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setTag(int viewId, @NotNull Object tag) {
        block0: {
            Object view;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Object v = view = this.getView(viewId);
            if (v == null) break block0;
            v.setTag(tag);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setTag(int viewId, int key, @NotNull Object tag) {
        block0: {
            Object view;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Object v = view = this.getView(viewId);
            if (v == null) break block0;
            v.setTag(key, tag);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setChecked(int viewId, boolean checked) {
        block1: {
            Checkable view;
            Object v = this.getView(viewId);
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.Checkable");
            }
            Checkable checkable = view = (Checkable)v;
            if (checkable == null) break block1;
            checkable.setChecked(checked);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setOnClickListener(int viewId, @NotNull View.OnClickListener listener) {
        block0: {
            Object view;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Object v = view = this.getView(viewId);
            if (v == null) break block0;
            v.setOnClickListener(listener);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setOnTouchListener(int viewId, @NotNull View.OnTouchListener listener) {
        block0: {
            Object view;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Object v = view = this.getView(viewId);
            if (v == null) break block0;
            v.setOnTouchListener(listener);
        }
        return this;
    }

    @NotNull
    public final BaseViewHolder setOnLongClickListener(int viewId, @NotNull View.OnLongClickListener listener) {
        block0: {
            Object view;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Object v = view = this.getView(viewId);
            if (v == null) break block0;
            v.setOnLongClickListener(listener);
        }
        return this;
    }

    public BaseViewHolder(@NotNull Context mContext, @NotNull View itemView) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        super(itemView);
        this.mContext = mContext;
        this.mViews = new SparseArrayCompat();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/allever/lib/common/ui/widget/recycler/BaseViewHolder$Companion;", "", "()V", "getHolder", "Lcom/allever/lib/common/ui/widget/recycler/BaseViewHolder;", "context", "Landroid/content/Context;", "parent", "Landroid/view/ViewGroup;", "layoutId", "", "common_release"})
    public static final class Companion {
        @NotNull
        public final BaseViewHolder getHolder(@NotNull Context context, @NotNull ViewGroup parent, int layoutId) {
            View itemView;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            View view = itemView = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            BaseViewHolder holder = new BaseViewHolder(context, view);
            itemView.setTag((Object)holder);
            return holder;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

