/*
 * Decompiled with CFR 0.152.
 */
package com.allever.lib.common.util;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.allever.lib.common.app.App;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0006J\b\u0010\r\u001a\u00020\u000bH\u0002J\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/allever/lib/common/util/DisplayUtils;", "", "()V", "TAG", "", "dip2px", "", "dip", "", "getDeviceDensity", "getDisplayMetrics", "Landroid/util/DisplayMetrics;", "getScreenHeight", "getScreenRealMetrics", "getScreenWidth", "px2dip", "px", "px2sp", "sp2px", "sp", "common_release"})
public final class DisplayUtils {
    private static final String TAG;
    @NotNull
    public static final DisplayUtils INSTANCE;

    public final int px2dip(int px) {
        Resources resources = App.Companion.getContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"App.context.resources");
        float density = resources.getDisplayMetrics().density;
        int result = (int)((float)px / density + 0.5f);
        return result;
    }

    public final int dip2px(int dip) {
        Resources resources = App.Companion.getContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"App.context.resources");
        float density = resources.getDisplayMetrics().density;
        int result = (int)((float)dip * density + 0.5f);
        return result;
    }

    public final int dip2px(float dip) {
        Resources resources = App.Companion.getContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"App.context.resources");
        float density = resources.getDisplayMetrics().density;
        int result = (int)(dip * density + 0.5f);
        return result;
    }

    public final int px2sp(int px) {
        Resources resources = App.Companion.getContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"App.context.resources");
        float scaledDensity = resources.getDisplayMetrics().scaledDensity;
        return (int)((float)px / scaledDensity + 0.5f);
    }

    public final int sp2px(int sp) {
        Resources resources = App.Companion.getContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"App.context.resources");
        float scaledDensity = resources.getDisplayMetrics().scaledDensity;
        return (int)((float)sp * scaledDensity + 0.5f);
    }

    public final float getDeviceDensity() {
        Resources resources = App.Companion.getContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"App.context.resources");
        return resources.getDisplayMetrics().density;
    }

    @NotNull
    public final DisplayMetrics getDisplayMetrics() {
        Resources resources = App.Companion.getContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"App.context.resources");
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"App.context.resources.displayMetrics");
        return displayMetrics;
    }

    public final int getScreenWidth() {
        return this.getScreenRealMetrics().widthPixels;
    }

    public final int getScreenHeight() {
        return this.getScreenRealMetrics().heightPixels;
    }

    private final DisplayMetrics getScreenRealMetrics() {
        DisplayMetrics displayMetrics;
        block1: {
            WindowManager wm;
            WindowManager windowManager;
            displayMetrics = new DisplayMetrics();
            Object object = App.Companion.getContext().getSystemService("window");
            if (!(object instanceof WindowManager)) {
                object = null;
            }
            if ((windowManager = (wm = (WindowManager)object)) == null || (windowManager = windowManager.getDefaultDisplay()) == null) break block1;
            windowManager.getRealMetrics(displayMetrics);
        }
        return displayMetrics;
    }

    private DisplayUtils() {
    }

    static {
        DisplayUtils displayUtils;
        INSTANCE = displayUtils = new DisplayUtils();
        TAG = "DisplayUtil";
    }
}

