/*
 * Decompiled with CFR 0.152.
 */
package com.allever.lib.common.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtil {
    private static final String LOG_TAG = "FileUtil";
    private static final String SCHEME_FILE = "file";
    private static final String[] IMAGE_FILE_EXT = new String[]{"jpg", "jpeg", "gif", "png", "bmp"};
    public static final String GOSHARE_MEDIA_FILE_SAVE_DIR = Environment.getExternalStorageDirectory() + "/ZEROSMS/.goshare/";

    public static InputStream unzipSingleFile(String zipFilePath, String singleFileName) throws Exception {
        ZipFile zipFile = new ZipFile(zipFilePath);
        ZipEntry zipEntry = zipFile.getEntry(singleFileName);
        return zipFile.getInputStream(zipEntry);
    }

    public static String extractZipComment(String filename) {
        if (filename == null || filename.equals("")) {
            return null;
        }
        String retStr = null;
        try {
            File file = new File(filename);
            int fileLen = (int)file.length();
            FileInputStream in = new FileInputStream(file);
            byte[] buffer = new byte[Math.min(fileLen, 2048)];
            in.skip(fileLen - buffer.length);
            int len = in.read(buffer);
            if (len > 0 && (retStr = FileUtil.getZipCommentFromBuffer(buffer, len)) != null) {
                retStr = retStr.trim();
            }
            in.close();
        }
        catch (Exception e) {
            Log.w((String)LOG_TAG, (String)"Exception on reading ZIP comment!", (Throwable)e);
        }
        return retStr;
    }

    private static String getZipCommentFromBuffer(byte[] buffer, int len) {
        byte[] magicDirEnd = new byte[]{80, 75, 5, 6};
        int buffLen = Math.min(buffer.length, len);
        for (int i = buffLen - magicDirEnd.length - 22; i >= 0; --i) {
            boolean isMagicStart = true;
            for (int k = 0; k < magicDirEnd.length; ++k) {
                if (buffer[i + k] == magicDirEnd[k]) continue;
                isMagicStart = false;
                break;
            }
            if (!isMagicStart) continue;
            int commentLen = buffer[i + 20] + buffer[i + 21] * 256;
            int realLen = buffLen - i - 22;
            if (commentLen != realLen) {
                Log.w((String)LOG_TAG, (String)"ZIP comment size mismatch!");
            }
            String comment = new String(buffer, i + 22, Math.min(commentLen, realLen));
            return comment;
        }
        Log.w((String)LOG_TAG, (String)"ZIP comment NOT found!");
        return null;
    }

    public static boolean deleteFilesInFolder(String folderPath) {
        File folder = new File(folderPath);
        try {
            if (folder.exists() && folder.isDirectory()) {
                File[] files;
                for (File file : files = folder.listFiles()) {
                    file.delete();
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkExist(String path) {
        if (path == null || path.equals("")) {
            return false;
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean buildFolderIfNotFound(String folderPath) {
        try {
            File folder = new File(folderPath);
            if (!folder.exists()) {
                if (!folder.mkdirs()) {
                    Log.i((String)LOG_TAG, (String)("The folder is already exist: " + folderPath));
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception ex) {
            Log.w((String)LOG_TAG, (String)("Fail to build folder: " + folderPath + ", " + ex.getMessage()));
            return false;
        }
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int len;
        FileInputStream input = new FileInputStream(sourceFile);
        BufferedInputStream inBuff = new BufferedInputStream(input);
        FileOutputStream output = new FileOutputStream(targetFile);
        BufferedOutputStream outBuff = new BufferedOutputStream(output);
        byte[] b = new byte[5120];
        while ((len = inBuff.read(b)) != -1) {
            outBuff.write(b, 0, len);
        }
        outBuff.flush();
        inBuff.close();
        outBuff.close();
        output.close();
        input.close();
    }

    private String readAssetsTextFile(Context context, String path) {
        String result = "";
        if (FileUtil.checkExist(path)) {
            return result;
        }
        try {
            AssetManager assetManager = context.getAssets();
            result = FileUtil.readInputStream(assetManager.open(path), "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void copyAssets(AssetManager assetManager, String oldPath, String newPath) {
        try {
            InputStream is = assetManager.open(oldPath);
            FileOutputStream fos = new FileOutputStream(new File(newPath));
            byte[] buffer = new byte[1024];
            int byteCount = 0;
            while ((byteCount = is.read(buffer)) != -1) {
                fos.write(buffer, 0, byteCount);
            }
            fos.flush();
            is.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean moveFile(File sourceFile, File targetFile) {
        if (sourceFile == null) {
            Log.w((String)LOG_TAG, (String)"Argument 'sourceFile' is null.");
            return false;
        }
        if (targetFile == null) {
            Log.w((String)LOG_TAG, (String)"Argument 'targetFile' is null.");
            return false;
        }
        try {
            FileUtil.copyFile(sourceFile, targetFile);
            FileUtil.deleteFile(sourceFile.getAbsolutePath());
            return true;
        }
        catch (Exception e) {
            Log.w((String)LOG_TAG, (String)("Exception on moveFile(): " + e.getMessage()));
            return false;
        }
    }

    public static void deleteFile(String filePath) {
        try {
            File file = new File(filePath);
            file.delete();
        }
        catch (Exception e) {
            Log.w((String)LOG_TAG, (String)("Exception on deleting file: " + filePath + ", " + e.getMessage()));
        }
    }

    public static void deleteFolder(String folderPath) {
        try {
            File file = new File(folderPath);
            if (!file.exists()) {
                return;
            }
            FileUtil.deleteAllFiles(folderPath);
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void deleteAllFiles(String folderPath) {
        try {
            File file = new File(folderPath);
            File[] listFiles = file.listFiles();
            if (listFiles != null) {
                for (File item : listFiles) {
                    if (item.isFile()) {
                        item.delete();
                        continue;
                    }
                    FileUtil.deleteFolder(item.getAbsolutePath());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isSDCardMounted() {
        String status = Environment.getExternalStorageState();
        return status.equals("mounted");
    }

    public static void callToScanMediaFile(Context context) {
        if (context == null) {
            Log.w((String)LOG_TAG, (String)"Argument 'context' is null.");
            return;
        }
        context.sendBroadcast(new Intent("android.intent.action.MEDIA_MOUNTED", Uri.parse((String)("file://" + Environment.getExternalStorageDirectory()))));
    }

    public static void callToScanMediaFile(Context context, String filePath) {
        if (context == null) {
            Log.w((String)LOG_TAG, (String)"Argument 'context' is null.");
            return;
        }
        if (filePath == null || filePath.length() == 0) {
            Log.w((String)LOG_TAG, (String)"Argument 'filePath' is null or empty.");
            return;
        }
        Uri uri = Uri.parse((String)("file://" + filePath));
        if (uri == null) {
            Log.w((String)LOG_TAG, (String)("Error on parsing file path to URI, filePath: " + filePath));
            return;
        }
        context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri));
    }

    public static boolean isNonImageFileUri(Uri uri) {
        if (uri == null) {
            Log.w((String)LOG_TAG, (String)"Argument 'uri' is null.");
            return false;
        }
        if (!uri.isHierarchical()) {
            return false;
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equals(SCHEME_FILE)) {
            return false;
        }
        String path = uri.getPath();
        int extStartIndex = path.lastIndexOf(46);
        if (extStartIndex <= 0 || extStartIndex >= path.length() - 1) {
            return true;
        }
        String ext = uri.getPath().substring(extStartIndex + 1);
        for (int i = 0; i < IMAGE_FILE_EXT.length; ++i) {
            if (!ext.equalsIgnoreCase(IMAGE_FILE_EXT[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean saveByteToSDFile(byte[] byteData, String filePathName) {
        boolean result = false;
        try {
            File newFile = FileUtil.createNewFile(filePathName, false);
            FileOutputStream fileOutputStream = new FileOutputStream(newFile);
            fileOutputStream.write(byteData);
            fileOutputStream.flush();
            fileOutputStream.close();
            result = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveStringToFile(String str, String filePathName) {
        boolean result = false;
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter writer = null;
        try {
            File newFile = FileUtil.createNewFile(filePathName, false);
            fileOutputStream = new FileOutputStream(newFile);
            writer = new OutputStreamWriter(fileOutputStream);
            writer.append(str);
            writer.flush();
            result = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static void createDir(String dir) {
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
    }

    public static File createNewFile(String path, boolean append) {
        File newFile = new File(path);
        if (!append && newFile.exists()) {
            newFile.delete();
        }
        if (!newFile.exists()) {
            try {
                File parent = newFile.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                newFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newFile;
    }

    public static String getMediaFilePath(Context context, Uri uri, Cursor c) {
        String filePath = null;
        try {
            filePath = c.getString(c.getColumnIndexOrThrow("_data"));
        }
        catch (IllegalArgumentException e) {
            try {
                filePath = c.getString(c.getColumnIndexOrThrow("_data"));
            }
            catch (IllegalArgumentException ex) {
                filePath = uri.getPath();
            }
        }
        return filePath;
    }

    public static String getMediaFileMimeType(Context context, Uri uri, Cursor c) {
        String contentType = null;
        try {
            contentType = c.getString(c.getColumnIndexOrThrow("mime_type"));
        }
        catch (IllegalArgumentException e) {
            try {
                contentType = c.getString(c.getColumnIndexOrThrow("mimetype"));
            }
            catch (IllegalArgumentException ex) {
                contentType = context.getContentResolver().getType(uri);
            }
        }
        return contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMediaFile(Context context, Uri uri, String filePath) {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = context.getContentResolver().openInputStream(uri);
            os = new FileOutputStream(filePath);
            byte[] buffer = new byte[8192];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        catch (Throwable e) {
            Log.e((String)"", (String)"", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable buffer) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable buffer) {}
            }
        }
    }

    public static void takePersistableUriPermission(Context context, Uri uri, int takeFlags) {
        try {
            Method takePersistableUriPermissionMethod = ContentResolver.class.getMethod("takePersistableUriPermission", Uri.class, Integer.TYPE);
            takePersistableUriPermissionMethod.invoke((Object)context.getContentResolver(), uri, takeFlags);
        }
        catch (Throwable tr) {
            Log.e((String)"", (String)"", (Throwable)tr);
        }
    }

    public static String checkLackESD(String path) {
        block6: {
            if (TextUtils.isEmpty((CharSequence)path)) {
                return path;
            }
            try {
                String fixedPath;
                File fixedFile;
                File file = new File(path);
                if (file == null || file.canRead()) break block6;
                try {
                    Log.e((String)LOG_TAG, (String)("Path Error:" + path));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!path.startsWith("/mnt/sdcard") && !path.startsWith(Environment.getExternalStorageDirectory().getPath()) && (fixedFile = new File(fixedPath = Environment.getExternalStorageDirectory().getPath() + path)).canRead() && fixedFile.isFile()) {
                    return fixedPath;
                }
            }
            catch (Throwable tr) {
                Log.e((String)LOG_TAG, (String)"", (Throwable)tr);
            }
        }
        return path;
    }

    public static long getFileSize(String path) {
        try {
            Log.e((String)LOG_TAG, (String)("FileSize Error:" + path));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (path == null) {
            return 0L;
        }
        try {
            File file = new File(path);
            return file.length();
        }
        catch (Throwable tr) {
            Log.e((String)LOG_TAG, (String)"", (Throwable)tr);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePicToFile(String filePath, byte[] files) {
        FileOutputStream out = null;
        try {
            File newFile = new File(filePath);
            if (!newFile.exists()) {
                newFile.createNewFile();
            }
            out = new FileOutputStream(newFile);
            out.write(files);
        }
        catch (IOException iOException) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getMmsPartSrc(String src) {
        if (TextUtils.isEmpty((CharSequence)src)) {
            return src;
        }
        src = src.replace(' ', '_');
        if ((src = src.replace('=', '_')).length() > 20) {
            src = src.substring(src.length() - 20);
        }
        return src;
    }

    public static boolean isExistsFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        File file = new File(fileName);
        return file.exists();
    }

    public static boolean isFileEmpty(String file) {
        FileReader fr = null;
        try {
            fr = new FileReader(file);
            if (fr.read() == -1) {
                fr.close();
                return true;
            }
            fr.close();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String formetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.#");
        String fileSizeString = "";
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((float)fileS / 1024.0f) + "KB" : (fileS < 0x40000000L ? df.format((float)fileS / 1048576.0f) + "MB" : df.format((float)fileS / 1.0737418E9f) + "GB"));
        return fileSizeString;
    }

    public static String getFileName(String pathName) {
        if (TextUtils.isEmpty((CharSequence)pathName)) {
            return null;
        }
        String name = pathName.substring(pathName.lastIndexOf(File.separator) + 1, pathName.length());
        return name;
    }

    public static String getParentFilePath(String pathName) {
        if (TextUtils.isEmpty((CharSequence)pathName)) {
            return null;
        }
        return pathName.substring(0, pathName.lastIndexOf(File.separator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readInputStream(InputStream in, String charset) throws IOException {
        if (in == null) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean var3 = true;
        try {
            String var7;
            int len;
            byte[] buf = new byte[1024];
            boolean var6 = false;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            byte[] data = out.toByteArray();
            String string = var7 = new String(data, TextUtils.isEmpty((CharSequence)charset) ? "UTF-8" : charset);
            return string;
        }
        catch (Exception var11) {
            var11.printStackTrace();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return null;
    }

    public static String readFileToString(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            return FileUtil.readInputStream(inputStream, "UTF-8");
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public static boolean inputStream2File(InputStream ins, File outFile) {
        try {
            int len;
            FileOutputStream outStream = new FileOutputStream(outFile);
            byte[] buffer = new byte[1024];
            while ((len = ins.read(buffer)) != -1) {
                ((OutputStream)outStream).write(buffer, 0, len);
            }
            ((OutputStream)outStream).close();
            ins.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getFilePathByUri(Context context, Uri uri) {
        if (uri == null) {
            return "";
        }
        if ("content".equalsIgnoreCase(uri.getScheme())) {
            int sdkVersion = Build.VERSION.SDK_INT;
            if (sdkVersion >= 19) {
                return FileUtil.getRealPathFromUriAboveApi19(context, uri);
            }
            return FileUtil.getRealPathFromUriBelowAPI19(context, uri);
        }
        if (SCHEME_FILE.equalsIgnoreCase(uri.getScheme())) {
            return uri.getPath();
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private static String getRealPathFromUriAboveApi19(Context context, Uri uri) {
        String filePath = null;
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            String docId;
            String[] split;
            String type;
            String documentId = DocumentsContract.getDocumentId((Uri)uri);
            if (FileUtil.isMediaDocument(uri)) {
                String type2 = documentId.split(":")[0];
                String id2 = documentId.split(":")[1];
                String selection = "_id=?";
                String[] selectionArgs = new String[]{id2};
                Uri contentUri = null;
                if ("image".equals(type2)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type2)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type2)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                filePath = FileUtil.getDataColumn(context, contentUri, selection, selectionArgs);
            } else if (FileUtil.isDownloadsDocument(uri)) {
                Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(documentId));
                filePath = FileUtil.getDataColumn(context, contentUri, null, null);
            } else if (FileUtil.isExternalStorageDocument(uri) && "primary".equalsIgnoreCase(type = (split = (docId = DocumentsContract.getDocumentId((Uri)uri)).split(":"))[0])) {
                filePath = Environment.getExternalStorageDirectory() + "/" + split[1];
            }
        } else if ("content".equalsIgnoreCase(uri.getScheme())) {
            filePath = FileUtil.getDataColumn(context, uri, null, null);
        } else if (SCHEME_FILE.equals(uri.getScheme())) {
            filePath = uri.getPath();
        }
        return filePath;
    }

    private static String getRealPathFromUriBelowAPI19(Context context, Uri uri) {
        return FileUtil.getDataColumn(context, uri, null, null);
    }

    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        String path;
        block3: {
            path = null;
            String[] projection = new String[]{"_data"};
            Cursor cursor = null;
            try {
                cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
                if (cursor != null && cursor.moveToFirst()) {
                    int columnIndex = cursor.getColumnIndexOrThrow(projection[0]);
                    path = cursor.getString(columnIndex);
                }
            }
            catch (Exception e) {
                if (cursor == null) break block3;
                cursor.close();
            }
        }
        return path;
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }
}

