/*
 * Decompiled with CFR 0.152.
 */
package com.allever.lib.common.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.allever.lib.common.app.App;
import com.allever.lib.common.util.ExtFunctionKt;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J;\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0018\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/allever/lib/common/util/FileUtils;", "", "()V", "checkExist", "", "path", "", "getDataColumn", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getFileName", "getFilePathByUri", "getRealPathFromUriAboveApi19", "getRealPathFromUriBelowAPI19", "isDownloadsDocument", "isExternalStorageDocument", "isMediaDocument", "readAssetsTextFile", "readTextFile", "readTextFileFromInputStream", "inputStream", "Ljava/io/InputStream;", "common_release"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE;

    @NotNull
    public final String getFileName(@Nullable String path) {
        List array;
        String fileName = "Unknown";
        String string2 = path;
        List list = array = string2 != null ? StringsKt.split$default((CharSequence)string2, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null) : null;
        if (list != null) {
            Collection collection = list;
            boolean bl = false;
            if (!collection.isEmpty()) {
                fileName = (String)array.get(array.size() - 1);
            }
        }
        return fileName;
    }

    public final boolean checkExist(@Nullable String path) {
        boolean bl;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        try {
            File file = new File(path);
            bl = file.exists();
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String readTextFile(@Nullable String path) {
        String result = "";
        if (!this.checkExist(path)) {
            return result;
        }
        try {
            result = this.readTextFileFromInputStream(new FileInputStream(path));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @NotNull
    public final String readAssetsTextFile(@Nullable String path) {
        String result = "";
        if (this.checkExist(path)) {
            return result;
        }
        try {
            AssetManager assetManager = App.Companion.getContext().getAssets();
            String string2 = path;
            Intrinsics.checkNotNull((Object)string2);
            InputStream inputStream = assetManager.open(string2);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assetManager.open(path!!)");
            result = this.readTextFileFromInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readTextFileFromInputStream(InputStream inputStream) {
        String result = "";
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            boolean bl;
            int len = -1;
            byte[] buffer = new byte[1024];
            while (true) {
                int n = bufferedInputStream.read(buffer);
                boolean bl2 = false;
                bl = false;
                int it = n;
                boolean bl3 = false;
                len = it;
                if (n == -1) break;
                byteArrayOutputStream.write(buffer, 0, len);
            }
            byte[] dataArray = byteArrayOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)dataArray, (String)"dataArray");
            byte[] byArray = dataArray;
            bl = false;
            result = new String(byArray, Charsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bufferedInputStream.close();
            byteArrayOutputStream.close();
            inputStream.close();
        }
        return result;
    }

    @Nullable
    public final String getFilePathByUri(@NotNull Context context, @Nullable Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (uri == null) {
            return "";
        }
        if (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true)) {
            int sdkVersion = Build.VERSION.SDK_INT;
            return sdkVersion >= 19 ? this.getRealPathFromUriAboveApi19(context, uri) : this.getRealPathFromUriBelowAPI19(context, uri);
        }
        if (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true)) {
            return uri.getPath();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"NewApi"})
    private final String getRealPathFromUriAboveApi19(Context context, Uri uri) {
        String filePath = null;
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            String documentId = DocumentsContract.getDocumentId((Uri)uri);
            if (this.isMediaDocument(uri)) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                void $this$toTypedArray$iv2;
                List list2;
                boolean bl;
                Collection $this$dropLastWhile$iv2;
                String string2 = documentId;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"documentId");
                Object object = string2;
                String string3 = ":";
                int n = 0;
                string3 = new Regex(string3);
                n = 0;
                boolean bl2 = false;
                object = string3.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv2.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        bl = false;
                        CharSequence charSequence = it;
                        boolean bl3 = false;
                        if (charSequence.length() == 0) continue;
                        list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv2 = list2;
                boolean $i$f$toTypedArray22 = false;
                String thisCollection$iv = $this$toTypedArray$iv2;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String type = stringArray[0];
                Object $i$f$toTypedArray22 = documentId;
                thisCollection$iv = ":";
                int it = 0;
                thisCollection$iv = new Regex(thisCollection$iv);
                it = 0;
                bl = false;
                $i$f$toTypedArray22 = thisCollection$iv.split((CharSequence)$i$f$toTypedArray22, it);
                boolean $i$f$dropLastWhile2 = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it2 = (String)iterator$iv.previous();
                        boolean bl4 = false;
                        CharSequence charSequence = it2;
                        boolean bl5 = false;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv2 = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String id2 = stringArray2[1];
                String selection = "_id=?";
                String[] selectionArgs = new String[]{id2};
                Uri contentUri = null;
                switch (type) {
                    case "image": {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        break;
                    }
                    case "video": {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        break;
                    }
                    case "audio": {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                        break;
                    }
                }
                filePath = this.getDataColumn(context, contentUri, selection, selectionArgs);
            } else if (this.isDownloadsDocument(uri)) {
                Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
                Long l = Long.valueOf(documentId);
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(documentId)");
                Uri contentUri = ContentUris.withAppendedId((Uri)uri2, (long)l);
                filePath = this.getDataColumn(context, contentUri, null, null);
            } else if (this.isExternalStorageDocument(uri)) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                String docId;
                String string4 = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"docId");
                Object selection = string4;
                String selectionArgs = ":";
                int contentUri = 0;
                selectionArgs = new Regex(selectionArgs);
                contentUri = 0;
                boolean it2 = false;
                selection = selectionArgs.split((CharSequence)selection, contentUri);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        CharSequence charSequence = it;
                        boolean bl6 = false;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                if (StringsKt.equals((String)"primary", (String)type, (boolean)true)) {
                    filePath = Environment.getExternalStorageDirectory().toString() + "/" + split[1];
                }
            } else {
                ExtFunctionKt.log(this, "\u8def\u5f84\u9519\u8bef");
            }
        } else {
            String string5 = uri.getScheme();
            Intrinsics.checkNotNull((Object)string5);
            if (StringsKt.equals((String)"content", (String)string5, (boolean)true)) {
                filePath = this.getDataColumn(context, uri, null, null);
            } else if (Intrinsics.areEqual((Object)"file", (Object)uri.getScheme())) {
                filePath = uri.getPath();
            }
        }
        return filePath;
    }

    private final String getRealPathFromUriBelowAPI19(Context context, Uri uri) {
        return this.getDataColumn(context, uri, null, null);
    }

    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        String path;
        block2: {
            path = null;
            String[] projection = new String[]{"_data"};
            Cursor cursor = null;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri2 = uri;
                Intrinsics.checkNotNull((Object)uri2);
                cursor = contentResolver.query(uri2, projection, selection, selectionArgs, null);
                if (cursor == null || !cursor.moveToFirst()) break block2;
                int columnIndex = cursor.getColumnIndexOrThrow(projection[0]);
                path = cursor.getString(columnIndex);
            }
            catch (Exception e) {
                Cursor cursor2 = cursor;
                if (cursor2 == null) break block2;
                cursor2.close();
            }
        }
        return path;
    }

    private final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    private final boolean isExternalStorageDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    private final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
    }
}

