/*
 * Decompiled with CFR 0.152.
 */
package com.allever.lib.common.util;

import android.app.Activity;
import android.app.Fragment;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import com.allever.lib.common.R;
import com.allever.lib.common.app.App;
import com.allever.lib.common.util.ExtFunctionKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lcom/allever/lib/common/util/ShareHelper;", "", "()V", "getShareAudioIntent", "Landroid/content/Intent;", "path", "", "getShareImageIntent", "getShareTextIntent", "msg", "share", "", "obj", "intent", "shareAudio", "shareImage", "shareText", "common_release"})
public final class ShareHelper {
    @NotNull
    public static final ShareHelper INSTANCE;

    public final void shareText(@NotNull Object obj, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.share(obj, this.getShareTextIntent(msg));
    }

    public final void shareAudio(@NotNull Object obj, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.share(obj, this.getShareAudioIntent(path));
    }

    public final void shareImage(@NotNull Object obj, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.share(obj, this.getShareImageIntent(path));
    }

    private final void share(Object obj, Intent intent) {
        try {
            Object object = obj;
            if (object instanceof androidx.fragment.app.Fragment) {
                ((androidx.fragment.app.Fragment)obj).startActivity(intent);
            } else if (object instanceof Fragment) {
                ((Fragment)obj).startActivity(intent);
            } else if (object instanceof Activity) {
                ((Activity)obj).startActivity(intent);
            } else if (object instanceof Service) {
                ((Service)obj).startActivity(intent);
            } else {
                ExtFunctionKt.toast((Object)this, R.string.common_share_tips_no_intent);
            }
        }
        catch (Exception e) {
            ExtFunctionKt.toast((Object)this, R.string.common_share_tips_no_intent);
            e.printStackTrace();
        }
    }

    private final Intent getShareTextIntent(String msg) {
        Intent shareIntent = new Intent();
        shareIntent.setAction("android.intent.action.SEND");
        shareIntent.putExtra("android.intent.extra.TEXT", msg);
        shareIntent.setType("text/plain");
        Intent intent = Intent.createChooser((Intent)shareIntent, (CharSequence)ExtFunctionKt.getString(this, R.string.common_share_to));
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent.createChooser(\n  \u2026ommon_share_to)\n        )");
        return intent;
    }

    private final Intent getShareImageIntent(String path) {
        Uri uri;
        File file = new File(path);
        Uri fileUri = null;
        if (Build.VERSION.SDK_INT >= 24) {
            Uri uri2 = FileProvider.getUriForFile((Context)App.Companion.getContext(), (String)(App.Companion.getContext().getPackageName() + ".fileprovider"), (File)file);
            uri = uri2;
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"FileProvider.getUriForFi\u2026ame}.fileprovider\", file)");
        } else {
            Uri uri3 = Uri.fromFile((File)file);
            uri = uri3;
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"Uri.fromFile(file)");
        }
        fileUri = uri;
        Intent shareIntent = new Intent();
        shareIntent.setAction("android.intent.action.SEND");
        shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)fileUri);
        shareIntent.setType("image/*");
        return shareIntent;
    }

    private final Intent getShareAudioIntent(String path) {
        Uri uri;
        Intent shareIntent = new Intent("android.intent.action.SEND");
        shareIntent.setType("audio/*");
        File file = new File(path);
        Uri fileUri = null;
        if (Build.VERSION.SDK_INT >= 24) {
            Uri uri2 = FileProvider.getUriForFile((Context)App.Companion.getContext(), (String)(App.Companion.getContext().getPackageName() + ".fileprovider"), (File)file);
            uri = uri2;
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"FileProvider.getUriForFi\u2026ame}.fileprovider\", file)");
        } else {
            Uri uri3 = Uri.fromFile((File)file);
            uri = uri3;
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"Uri.fromFile(file)");
        }
        fileUri = uri;
        shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)fileUri);
        Intent intent = Intent.createChooser((Intent)shareIntent, (CharSequence)ExtFunctionKt.getString(this, R.string.common_share_to));
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent.createChooser(\n  \u2026ommon_share_to)\n        )");
        return intent;
    }

    private ShareHelper() {
    }

    static {
        ShareHelper shareHelper;
        INSTANCE = shareHelper = new ShareHelper();
    }
}

