/*
 * Decompiled with CFR 0.152.
 */
package com.allever.lib.common.util;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.Window;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/allever/lib/common/util/SystemUiUtils;", "", "()V", "NAVIGATION_BAR_HEIGHT", "", "STATUS_BAR_HEIGHT", "getNavigationBarHeight", "", "context", "Landroid/content/Context;", "getStatusBarHeight", "getXBarHeight", "parameterName", "setFullScreen", "", "window", "Landroid/view/Window;", "setStatusBarTransparent", "common_release"})
public final class SystemUiUtils {
    private static final String STATUS_BAR_HEIGHT = "status_bar_height";
    private static final String NAVIGATION_BAR_HEIGHT = "navigation_bar_height";
    @NotNull
    public static final SystemUiUtils INSTANCE;

    public final void setStatusBarTransparent(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (Build.VERSION.SDK_INT >= 21) {
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
            view.setSystemUiVisibility(1024);
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(Color.argb((int)0, (int)0, (int)0, (int)0));
        } else if (Build.VERSION.SDK_INT >= 19) {
            window.addFlags(0x4000000);
        }
    }

    public final void setFullScreen(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (Build.VERSION.SDK_INT >= 16) {
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
            view.setSystemUiVisibility(1028);
        }
    }

    public final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getXBarHeight(context, STATUS_BAR_HEIGHT);
    }

    public final int getNavigationBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getXBarHeight(context, NAVIGATION_BAR_HEIGHT);
    }

    private final int getXBarHeight(Context context, String parameterName) {
        int height = 0;
        int resourceId = context.getResources().getIdentifier(parameterName, "dimen", "android");
        if (resourceId > 0) {
            height = context.getResources().getDimensionPixelSize(resourceId);
        }
        return height;
    }

    private SystemUiUtils() {
    }

    static {
        SystemUiUtils systemUiUtils;
        INSTANCE = systemUiUtils = new SystemUiUtils();
    }
}

