/*
 * Decompiled with CFR 0.152.
 */
package com.allever.lib.common.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.LocaleList;
import android.os.PowerManager;
import android.provider.MediaStore;
import android.widget.Toast;
import com.allever.lib.common.app.App;
import com.allever.lib.common.util.ExtFunctionKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nJ\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0016"}, d2={"Lcom/allever/lib/common/util/SystemUtils;", "", "()V", "chooseImageFromGallery", "", "activity", "Landroid/app/Activity;", "requestCode", "", "getManifestDataByKey", "", "context", "Landroid/content/Context;", "key", "getStatusBarHeight", "isChineseLang", "", "openUrl", "url", "startWebView", "uri", "wakeUpAndUnlock", "common_release"})
public final class SystemUtils {
    @NotNull
    public static final SystemUtils INSTANCE;

    public final void chooseImageFromGallery(@NotNull Activity activity, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intent albumIntent = new Intent("android.intent.action.PICK");
        albumIntent.setType("image/*");
        albumIntent.setData(MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        activity.startActivityForResult(albumIntent, requestCode);
    }

    public final void openUrl(@NotNull Activity activity, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        try {
            intent.addFlags(524288);
            ExtFunctionKt.log(this, "Launching intent: " + intent + " with extras: " + intent.getExtras());
            activity.startActivity(intent);
        }
        catch (ActivityNotFoundException ignored) {
            ExtFunctionKt.log(this, "Nothing available to handle " + intent);
        }
    }

    public final boolean isChineseLang() {
        Locale lang;
        LocaleList langList;
        Resources resources = App.Companion.getContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"App.context.resources");
        Configuration configuration = resources.getConfiguration();
        if (Build.VERSION.SDK_INT < 24) {
            Locale locale = configuration.locale;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"configuration.locale");
            return Intrinsics.areEqual((Object)locale.getLanguage(), (Object)"zh");
        }
        Configuration configuration2 = configuration;
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"configuration");
        LocaleList localeList = langList = configuration2.getLocales();
        Intrinsics.checkNotNullExpressionValue((Object)localeList, (String)"langList");
        if (localeList.isEmpty()) {
            return true;
        }
        Locale locale = lang = langList.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"lang");
        return Intrinsics.areEqual((Object)locale.getLanguage(), (Object)"zh");
    }

    public final void startWebView(@NotNull Context context, @NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
        intent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT < 21) {
            intent.addFlags(524288);
        } else {
            intent.addFlags(524288);
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)context, (CharSequence)"Sorry, Your mobile can't be supported", (int)1).show();
        }
    }

    @NotNull
    public final String getManifestDataByKey(@NotNull Context context, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ApplicationInfo appInfo = App.Companion.getContext().getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        String msg = appInfo.metaData.getString(key);
        ExtFunctionKt.log(this, key + " - " + msg);
        String string2 = msg;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int statusBarHeight = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = context.getResources().getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }

    @SuppressLint(value={"InvalidWakeLockTag"})
    public final void wakeUpAndUnlock(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("keyguard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.KeyguardManager");
        }
        KeyguardManager km = (KeyguardManager)object;
        KeyguardManager.KeyguardLock kl = km.newKeyguardLock("unLock");
        kl.disableKeyguard();
        Object object2 = context.getSystemService("power");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.os.PowerManager");
        }
        PowerManager pm = (PowerManager)object2;
        PowerManager.WakeLock wl = pm.newWakeLock(0x10000006, "bright");
        wl.acquire(600000L);
        wl.release();
    }

    private SystemUtils() {
    }

    static {
        SystemUtils systemUtils;
        INSTANCE = systemUtils = new SystemUtils();
    }
}

