/*
 * Decompiled with CFR 0.152.
 */
package com.allever.lib.common.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.allever.lib.common.R;
import com.allever.lib.common.util.ToastUtils;

public class Tool {
    public static void openAppInPlay(Context context, String uristring, String appstore) {
        if (!uristring.startsWith("market") && !uristring.startsWith("http")) {
            uristring = "market://details?id=" + uristring;
        }
        Uri uri = Uri.parse((String)uristring);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        intent.setFlags(0x10000000);
        if (!TextUtils.isEmpty((CharSequence)appstore) && Tool.isThereApp(context, appstore)) {
            intent.setPackage(appstore);
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            ToastUtils.INSTANCE.show(context.getResources().getString(R.string.common_has_not_google_service));
        }
    }

    public static void openInGooglePlay(Context context, String uriString) {
        Tool.openAppInPlay(context, uriString, "com.android.vending");
    }

    public static void openAppInPlay(Context context, String uristring) {
        Tool.openAppInPlay(context, uristring, null);
    }

    public static boolean isThereApp(Context context, String pkg) {
        try {
            PackageInfo packageInfo;
            if (pkg.startsWith("market")) {
                pkg = pkg.replaceAll(".*id=", "");
            }
            if (null != (packageInfo = context.getPackageManager().getPackageInfo(pkg, 128))) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getPackeName(String pkg) {
        String str = pkg.replace(".", "");
        return str;
    }
}

