/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen;

import com.netflix.graphql.dgs.codegen.CodeGen;
import com.netflix.graphql.dgs.codegen.CodeGenConfig;
import com.netflix.graphql.dgs.codegen.Language;
import io.github.deweyjose.graphqlcodegen.Properties;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class Codegen
extends AbstractMojo {
    @Parameter(property="schemaPaths", defaultValue="${project.build.resources}/schema")
    private File[] schemaPaths;
    @Parameter(property="schemaJarFilesFromDependencies")
    private File[] schemaJarFilesFromDependencies;
    @Parameter(property="packageName", defaultValue="")
    private String packageName;
    @Parameter(property="subPackageNameClient", defaultValue="client")
    private String subPackageNameClient;
    @Parameter(property="subPackageNameDatafetchers", defaultValue="datafetchers")
    private String subPackageNameDatafetchers;
    @Parameter(property="subPackageNameTypes", defaultValue="types")
    private String subPackageNameTypes;
    @Parameter(property="language", defaultValue="java")
    private String language;
    @Parameter(property="typeMapping")
    private Map<String, String> typeMapping;
    @Parameter(property="generateBoxedTypes", defaultValue="false")
    private boolean generateBoxedTypes;
    @Parameter(property="generateClientApi", defaultValue="false")
    private boolean generateClientApi;
    @Parameter(property="generateClientApiV2", defaultValue="false")
    private boolean generateClientApiV2;
    @Parameter(property="generateDataTypes", defaultValue="true")
    private boolean generateDataTypes;
    @Parameter(property="generateInterfaces", defaultValue="false")
    private boolean generateInterfaces;
    @Parameter(property="generateKotlinNullableClasses", defaultValue="false")
    private boolean generateKotlinNullableClasses;
    @Parameter(property="generateKotlinClosureProjections", defaultValue="false")
    private boolean generateKotlinClosureProjections;
    @Parameter(property="outputDir", defaultValue="${project.build.directory}/generated-sources")
    private File outputDir;
    @Parameter(property="exampleOutputDir", defaultValue="${project.build.directory}/generated-examples")
    private File exampleOutputDir;
    @Parameter(property="includeQueries")
    private String[] includeQueries;
    @Parameter(property="includeMutations")
    private String[] includeMutations;
    @Parameter(property="skipEntityQueries", defaultValue="false")
    private boolean skipEntityQueries;
    @Parameter(property="shortProjectionNames", defaultValue="false")
    private boolean shortProjectionNames;
    @Parameter(property="maxProjectionDepth", defaultValue="10")
    private int maxProjectionDepth;
    @Parameter(property="omitNullInputFields", defaultValue="false")
    private boolean omitNullInputFields;
    @Parameter(property="kotlinAllFieldsOptional", defaultValue="false")
    private boolean kotlinAllFieldsOptional;
    @Parameter(property="snakeCaseConstantNames", defaultValue="false")
    private boolean snakeCaseConstantNames;
    @Parameter(property="writeToFiles", defaultValue="true")
    private boolean writeToFiles;
    @Parameter(property="includeSubscriptions")
    private String[] includeSubscriptions;
    @Parameter(property="generateInterfaceSetters", defaultValue="false")
    private boolean generateInterfaceSetters;
    @Parameter(property="generateInterfaceMethodsForInterfaceFields", defaultValue="false")
    private boolean generateInterfaceMethodsForInterfaceFields;
    @Parameter(property="javaGenerateAllConstructor", defaultValue="false")
    private boolean javaGenerateAllConstructor;
    @Parameter(property="implementSerializable", defaultValue="false")
    private boolean implementSerializable;
    @Parameter(property="addGeneratedAnnotation", defaultValue="false")
    private boolean addGeneratedAnnotation;
    @Parameter(property="addDeprecatedAnnotation", defaultValue="false")
    private boolean addDeprecatedAnnotation;
    @Parameter(property="dgs.codegen.skip", defaultValue="false", required=false)
    private boolean skip;
    @Parameter(property="generateCustomAnnotations", defaultValue="false")
    private boolean generateCustomAnnotations;
    @Parameter(property="includeImports")
    private Map<String, String> includeImports;
    @Parameter(property="includeEnumImports")
    private Map<String, Properties> includeEnumImports;
    @Parameter(property="includeClassImports")
    private Map<String, Properties> includeClassImports;

    private void verifySettings() {
        if (Objects.isNull(this.packageName)) {
            throw new RuntimeException("Please specify a packageName");
        }
        if (this.schemaPaths.length != Arrays.stream(this.schemaPaths).collect(Collectors.toSet()).size()) {
            throw new RuntimeException("Duplicate entries in schemaPaths");
        }
        for (File schemaPath : this.schemaPaths) {
            if (schemaPath.exists()) continue;
            try {
                throw new RuntimeException(String.format("Schema File: %s does not exist!", schemaPath.getCanonicalPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.verifySettings();
            CodeGenConfig config = new CodeGenConfig(Collections.emptySet(), Arrays.stream(this.schemaPaths).collect(Collectors.toSet()), Arrays.stream(this.schemaJarFilesFromDependencies).collect(Collectors.toList()), this.outputDir.toPath(), this.exampleOutputDir.toPath(), this.writeToFiles, this.packageName, this.subPackageNameClient, this.subPackageNameDatafetchers, this.subPackageNameTypes, Language.valueOf((String)this.language.toUpperCase()), this.generateBoxedTypes, this.generateClientApi, this.generateClientApiV2, this.generateInterfaces, this.generateKotlinNullableClasses, this.generateKotlinClosureProjections, this.typeMapping, Arrays.stream(this.includeQueries).collect(Collectors.toSet()), Arrays.stream(this.includeMutations).collect(Collectors.toSet()), Arrays.stream(this.includeSubscriptions).collect(Collectors.toSet()), this.skipEntityQueries, this.shortProjectionNames, this.generateDataTypes, this.omitNullInputFields, this.maxProjectionDepth, this.kotlinAllFieldsOptional, this.snakeCaseConstantNames, this.generateInterfaceSetters, this.generateInterfaceMethodsForInterfaceFields, this.includeImports, this.includeEnumImports.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Properties)entry.getValue()).getProperties())), this.includeClassImports.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Properties)entry.getValue()).getProperties())), this.generateCustomAnnotations, this.javaGenerateAllConstructor, this.implementSerializable, this.addGeneratedAnnotation, this.addDeprecatedAnnotation);
            this.getLog().info((CharSequence)String.format("Codegen config: %n%s", config));
            CodeGen codeGen = new CodeGen(config);
            codeGen.generate();
        }
    }
}

