/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFileManifest {
    private static final Logger log = LoggerFactory.getLogger(SchemaFileManifest.class);
    private Set<File> files;
    private Properties manifest;
    private File manifestPath;

    public SchemaFileManifest(Set<File> files, File manifestPath) {
        this.files = files;
        this.manifestPath = manifestPath;
        this.manifest = SchemaFileManifest.loadManifest(manifestPath);
    }

    public SchemaFileManifest(File manifestPath) {
        this.manifestPath = manifestPath;
        this.manifest = SchemaFileManifest.loadManifest(manifestPath);
    }

    public void setFiles(Set<File> files) {
        this.files = files;
    }

    public Set<File> getChangedFiles() {
        HashSet<File> changed = new HashSet<File>();
        for (File file : this.files) {
            String oldChecksum = this.manifest.getProperty(file.getPath());
            if (oldChecksum == null) {
                log.info("{} is new, will generate code", (Object)file.getName());
            } else if (!oldChecksum.equals(SchemaFileManifest.generateChecksum(file))) {
                log.info("{} has changed, will generate code", (Object)file.getName());
            } else {
                log.info("{} has not changed, will not generate code", (Object)file.getName());
                continue;
            }
            changed.add(file);
        }
        return changed;
    }

    public void syncManifest() {
        this.manifest.clear();
        for (File file : this.files) {
            this.manifest.put(file.getPath(), SchemaFileManifest.generateChecksum(file));
        }
        try (FileOutputStream fos = new FileOutputStream(this.manifestPath);){
            this.manifest.store(fos, "Schema Manifest");
            fos.flush();
        }
    }

    public static Properties loadManifest(File manifestPath) {
        Properties properties = new Properties();
        if (manifestPath.exists()) {
            try (FileInputStream fis = new FileInputStream(manifestPath);){
                properties.load(fis);
            }
        }
        return properties;
    }

    public static String generateChecksum(File path) {
        byte[] data = Files.readAllBytes(Paths.get(path.toURI()));
        byte[] hash = MessageDigest.getInstance("MD5").digest(data);
        String checksum = new BigInteger(1, hash).toString(16);
        return checksum;
    }

    public static boolean isGraphqlFile(File file) {
        return file.getName().endsWith(".graphqls") || file.getName().endsWith(".graphql");
    }

    public static Set<File> findGraphQLSFiles(File directory) {
        HashSet<File> result = new HashSet<File>();
        File[] contents = directory.listFiles();
        if (contents != null) {
            for (File content : contents) {
                if (content.isFile() && SchemaFileManifest.isGraphqlFile(content)) {
                    result.add(content);
                    continue;
                }
                if (!content.isDirectory()) continue;
                Set<File> subdirectoryGraphQLSFiles = SchemaFileManifest.findGraphQLSFiles(content);
                result.addAll(subdirectoryGraphQLSFiles);
            }
        }
        return result;
    }
}

