/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Set;
import nu.studer.java.util.OrderedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFileManifest {
    private static final Logger log = LoggerFactory.getLogger(SchemaFileManifest.class);
    private Set<File> files;
    private final File manifestPath;
    private final File projectPath;

    public SchemaFileManifest(Set<File> files, File manifestPath, File projectPath) {
        this.files = files;
        this.manifestPath = manifestPath;
        this.projectPath = projectPath;
    }

    public SchemaFileManifest(File manifestPath, File projectPath) {
        this.manifestPath = manifestPath;
        this.projectPath = projectPath;
    }

    public static String generateChecksum(File path) {
        byte[] data = Files.readAllBytes(Paths.get(path.toURI()));
        byte[] hash = MessageDigest.getInstance("MD5").digest(data);
        String checksum = new BigInteger(1, hash).toString(16);
        return checksum;
    }

    public static boolean isGraphqlFile(File file) {
        return file.getName().endsWith(".graphqls") || file.getName().endsWith(".graphql");
    }

    public static Set<File> findGraphQLSFiles(File directory) {
        HashSet<File> result = new HashSet<File>();
        File[] contents = directory.listFiles();
        if (contents != null) {
            for (File content : contents) {
                if (content.isFile() && SchemaFileManifest.isGraphqlFile(content)) {
                    result.add(content);
                    continue;
                }
                if (!content.isDirectory()) continue;
                Set<File> subdirectoryGraphQLSFiles = SchemaFileManifest.findGraphQLSFiles(content);
                result.addAll(subdirectoryGraphQLSFiles);
            }
        }
        return result;
    }

    public void setFiles(Set<File> files) {
        this.files = files;
    }

    public Set<File> getChangedFiles() {
        HashSet<File> changed = new HashSet<File>();
        OrderedProperties manifest = this.loadManifest();
        for (File file : this.files) {
            String oldChecksum = manifest.getProperty(this.relativizeToProject(file));
            if (oldChecksum == null) {
                log.info("{} is new, will generate code", (Object)file.getName());
            } else if (!oldChecksum.equals(SchemaFileManifest.generateChecksum(file))) {
                log.info("{} has changed, will generate code", (Object)file.getName());
            } else {
                log.info("{} has not changed, will not generate code", (Object)file.getName());
                continue;
            }
            changed.add(file);
        }
        return changed;
    }

    public void syncManifest() {
        OrderedProperties manifest = new OrderedProperties.OrderedPropertiesBuilder().withSuppressDateInComment(true).build();
        for (File file : this.files) {
            manifest.setProperty(this.relativizeToProject(file), SchemaFileManifest.generateChecksum(file));
        }
        if (!this.manifestPath.exists()) {
            this.manifestPath.getParentFile().mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(this.manifestPath);){
            manifest.store((OutputStream)fos, "Schema Manifest");
            fos.flush();
        }
    }

    private OrderedProperties loadManifest() {
        OrderedProperties properties = new OrderedProperties.OrderedPropertiesBuilder().withSuppressDateInComment(true).build();
        if (this.manifestPath.exists()) {
            try (FileInputStream fis = new FileInputStream(this.manifestPath);){
                properties.load((InputStream)fis);
            }
        }
        return properties;
    }

    private String relativizeToProject(File file) {
        return this.projectPath.toPath().relativize(file.toPath()).toString();
    }
}

