/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;

public class Validations {
    public static void verifyPackageName(String name) {
        if (Objects.isNull(name)) {
            throw new IllegalArgumentException("Please specify a packageName");
        }
    }

    public static void verifySchemaPaths(Collection<File> files) {
        ArrayList<File> sortedFiles = new ArrayList<File>(files);
        sortedFiles.sort(Comparator.comparing(File::getPath));
        HashSet<File> encounteredDirectories = new HashSet<File>();
        HashSet<String> encounteredPaths = new HashSet<String>();
        for (File file : sortedFiles) {
            if (!file.exists()) {
                throw new IllegalArgumentException("Configured path %s does not exist" + file.getPath());
            }
            String path = file.getPath();
            for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                if (!encounteredDirectories.contains(parent)) continue;
                throw new IllegalArgumentException(String.format("Overlap configured: %s contains %s", parent.getPath(), file.getPath()));
            }
            if (file.isDirectory()) {
                encounteredDirectories.add(file);
            }
            encounteredPaths.add(path);
        }
    }
}

