/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen;

import com.netflix.graphql.dgs.codegen.CodeGen;
import com.netflix.graphql.dgs.codegen.CodeGenConfig;
import com.netflix.graphql.dgs.codegen.Language;
import io.github.deweyjose.graphqlcodegen.DependencySchemaExtractor;
import io.github.deweyjose.graphqlcodegen.Properties;
import io.github.deweyjose.graphqlcodegen.SchemaFileManifest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class Codegen
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="schemaPaths", defaultValue="${project.basedir}/src/main/resources/schema")
    private File[] schemaPaths;
    @Parameter(alias="schemaJarFilesFromDependencies", property="schemaJarFilesFromDependencies")
    private String[] schemaJarFilesFromDependencies;
    @Parameter(property="packageName", defaultValue="")
    private String packageName;
    @Parameter(property="subPackageNameClient", defaultValue="client")
    private String subPackageNameClient;
    @Parameter(property="subPackageNameDatafetchers", defaultValue="datafetchers")
    private String subPackageNameDatafetchers;
    @Parameter(property="subPackageNameTypes", defaultValue="types")
    private String subPackageNameTypes;
    @Parameter(property="subPackageNameDocs", defaultValue="docs")
    private String subPackageNameDocs;
    @Parameter(property="language", defaultValue="java")
    private String language;
    @Parameter(property="typeMapping")
    private Map<String, String> typeMapping;
    @Parameter(property="typeMappingPropertiesFiles")
    private String[] typeMappingPropertiesFiles;
    @Parameter(property="generateBoxedTypes", defaultValue="false")
    private boolean generateBoxedTypes;
    @Parameter(property="generateClientApi", defaultValue="false")
    private boolean generateClientApi;
    @Parameter(property="generateClientApiV2", defaultValue="false")
    private boolean generateClientApiV2;
    @Parameter(property="generateDataTypes", defaultValue="true")
    private boolean generateDataTypes;
    @Parameter(property="generateInterfaces", defaultValue="false")
    private boolean generateInterfaces;
    @Parameter(property="generateKotlinNullableClasses", defaultValue="false")
    private boolean generateKotlinNullableClasses;
    @Parameter(property="generateKotlinClosureProjections", defaultValue="false")
    private boolean generateKotlinClosureProjections;
    @Parameter(property="outputDir", defaultValue="${project.build.directory}/generated-sources")
    private File outputDir;
    @Parameter(property="exampleOutputDir", defaultValue="${project.build.directory}/generated-examples")
    private File exampleOutputDir;
    @Parameter(property="schemaManifestOutputDir", defaultValue="${project.build.directory}/graphqlcodegen")
    private File schemaManifestOutputDir;
    @Parameter(property="includeQueries")
    private String[] includeQueries;
    @Parameter(property="includeMutations")
    private String[] includeMutations;
    @Parameter(property="skipEntityQueries", defaultValue="false")
    private boolean skipEntityQueries;
    @Parameter(property="shortProjectionNames", defaultValue="false")
    private boolean shortProjectionNames;
    @Parameter(property="maxProjectionDepth", defaultValue="10")
    private int maxProjectionDepth;
    @Parameter(property="omitNullInputFields", defaultValue="false")
    private boolean omitNullInputFields;
    @Parameter(property="kotlinAllFieldsOptional", defaultValue="false")
    private boolean kotlinAllFieldsOptional;
    @Parameter(property="snakeCaseConstantNames", defaultValue="false")
    private boolean snakeCaseConstantNames;
    @Parameter(property="writeToFiles", defaultValue="true")
    private boolean writeToFiles;
    @Parameter(property="includeSubscriptions")
    private String[] includeSubscriptions;
    @Parameter(property="generateInterfaceSetters", defaultValue="false")
    private boolean generateInterfaceSetters;
    @Parameter(property="generateInterfaceMethodsForInterfaceFields", defaultValue="false")
    private boolean generateInterfaceMethodsForInterfaceFields;
    @Parameter(property="generateDocs", defaultValue="false")
    private Boolean generateDocs;
    @Parameter(property="generatedDocsFolder", defaultValue="./generated-docs")
    private String generatedDocsFolder;
    @Parameter(property="javaGenerateAllConstructor", defaultValue="false")
    private boolean javaGenerateAllConstructor;
    @Parameter(property="implementSerializable", defaultValue="false")
    private boolean implementSerializable;
    @Parameter(property="addGeneratedAnnotation", defaultValue="false")
    private boolean addGeneratedAnnotation;
    @Parameter(property="addDeprecatedAnnotation", defaultValue="false")
    private boolean addDeprecatedAnnotation;
    @Parameter(property="dgs.codegen.skip", defaultValue="false", required=false)
    private boolean skip;
    @Parameter(property="generateCustomAnnotations", defaultValue="false")
    private boolean generateCustomAnnotations;
    @Parameter(property="includeImports")
    private Map<String, String> includeImports;
    @Parameter(property="includeEnumImports")
    private Map<String, Properties> includeEnumImports;
    @Parameter(property="includeClassImports")
    private Map<String, Properties> includeClassImports;
    @Parameter(property="onlyGenerateChanged", defaultValue="true")
    private boolean onlyGenerateChanged;
    @Parameter(property="disableDatesInGeneratedAnnotation", defaultValue="false")
    private boolean disableDatesInGeneratedAnnotation;
    @Parameter(property="generateIsGetterForPrimitiveBooleanFields", defaultValue="false")
    private boolean generateIsGetterForPrimitiveBooleanFields;

    private Set<File> expandSchemaPaths() {
        if (this.onlyGenerateChanged) {
            Set configuredSchemaPaths = Arrays.stream(this.schemaPaths).collect(Collectors.toSet());
            HashSet<File> expandedSchemaPaths = new HashSet<File>();
            for (File path : configuredSchemaPaths) {
                if (path.isFile()) {
                    expandedSchemaPaths.add(path);
                    continue;
                }
                expandedSchemaPaths.addAll(SchemaFileManifest.findGraphQLSFiles(path));
            }
            this.getLog().info((CharSequence)String.format("expanded schema paths: %s", expandedSchemaPaths));
            return expandedSchemaPaths;
        }
        return Arrays.stream(this.schemaPaths).collect(Collectors.toSet());
    }

    public void execute() {
        if (!this.skip) {
            this.verifyPackageName();
            Set<File> fullSchemaPaths = this.expandSchemaPaths();
            this.verifySchemaFiles(fullSchemaPaths);
            SchemaFileManifest manifest = new SchemaFileManifest(new File(this.schemaManifestOutputDir, "schema-manifest.props"), this.project.getBasedir());
            if (this.onlyGenerateChanged) {
                manifest.setFiles(new HashSet<File>(fullSchemaPaths));
                fullSchemaPaths.retainAll(manifest.getChangedFiles());
                this.getLog().info((CharSequence)String.format("changed schema files: %s", fullSchemaPaths));
            }
            if (fullSchemaPaths.isEmpty() && this.schemaJarFilesFromDependencies.length < 1) {
                this.getLog().info((CharSequence)"no files to generate");
                return;
            }
            if (this.typeMappingPropertiesFiles != null && this.typeMappingPropertiesFiles.length > 0) {
                Set dependencies = this.project.getArtifacts();
                java.util.Properties typeMappingProperties = new java.util.Properties();
                for (Artifact dependency : dependencies) {
                    File artifactFile = dependency.getFile();
                    if (artifactFile == null || !artifactFile.isFile()) continue;
                    this.loadPropertiesFile(typeMappingProperties, artifactFile, this.typeMappingPropertiesFiles);
                }
                if (this.typeMapping == null) {
                    this.typeMapping = new HashMap<String, String>();
                }
                typeMappingProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.typeMapping.putIfAbsent(String.valueOf(k), String.valueOf(v))));
            }
            CodeGenConfig config = new CodeGenConfig(Collections.emptySet(), fullSchemaPaths, DependencySchemaExtractor.extract(this.project, this.schemaJarFilesFromDependencies), this.outputDir.toPath(), this.exampleOutputDir.toPath(), this.writeToFiles, this.packageName, this.subPackageNameClient, this.subPackageNameDatafetchers, this.subPackageNameTypes, this.subPackageNameDocs, Language.valueOf((String)this.language.toUpperCase()), this.generateBoxedTypes, this.generateIsGetterForPrimitiveBooleanFields, this.generateClientApi, this.generateClientApiV2, this.generateInterfaces, this.generateKotlinNullableClasses, this.generateKotlinClosureProjections, this.typeMapping, Arrays.stream(this.includeQueries).collect(Collectors.toSet()), Arrays.stream(this.includeMutations).collect(Collectors.toSet()), Arrays.stream(this.includeSubscriptions).collect(Collectors.toSet()), this.skipEntityQueries, this.shortProjectionNames, this.generateDataTypes, this.omitNullInputFields, this.maxProjectionDepth, this.kotlinAllFieldsOptional, this.snakeCaseConstantNames, this.generateInterfaceSetters, this.generateInterfaceMethodsForInterfaceFields, this.generateDocs.booleanValue(), Paths.get(this.generatedDocsFolder, new String[0]), this.includeImports, this.includeEnumImports.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Properties)entry.getValue()).getProperties())), this.includeClassImports.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Properties)entry.getValue()).getProperties())), this.generateCustomAnnotations, this.javaGenerateAllConstructor, this.implementSerializable, this.addGeneratedAnnotation, this.disableDatesInGeneratedAnnotation, this.addDeprecatedAnnotation);
            this.getLog().info((CharSequence)String.format("Codegen config: \n%s", config));
            CodeGen codeGen = new CodeGen(config);
            codeGen.generate();
            if (this.onlyGenerateChanged) {
                try {
                    manifest.syncManifest();
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)"error syncing manifest", (Throwable)e);
                }
            }
        }
    }

    private void loadPropertiesFile(java.util.Properties typeMappingProperties, File artifactFile, String[] typeMappingPropertiesFiles) {
        try (JarFile jarFile = new JarFile(artifactFile);){
            for (String file : typeMappingPropertiesFiles) {
                ZipEntry entry = jarFile.getEntry(file);
                if (entry == null) continue;
                try (InputStream inputStream = jarFile.getInputStream(entry);){
                    this.getLog().info((CharSequence)String.format("Loading typeMapping from %s in artifact %s", file, artifactFile.getAbsolutePath()));
                    typeMappingProperties.load(inputStream);
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    public void verifyPackageName() {
        if (Objects.isNull(this.packageName)) {
            throw new IllegalArgumentException("Please specify a packageName");
        }
    }

    public void verifySchemaFiles(Set<File> fullSchemaPaths) {
        if (fullSchemaPaths.isEmpty() && this.schemaJarFilesFromDependencies.length < 1) {
            this.getLog().error((CharSequence)"No schema files found and no schemaJarFilesFromDependencies specified. Refer to documentation for schemaPaths and schemaJarFilesFromDependencies. ");
            throw new IllegalArgumentException("No schema files found. Please check your configuration.");
        }
    }
}

