/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen;

import com.netflix.graphql.dgs.codegen.CodeGen;
import com.netflix.graphql.dgs.codegen.CodeGenConfig;
import com.netflix.graphql.dgs.codegen.Language;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class Codegen
extends AbstractMojo {
    @Parameter(property="schemaPaths", defaultValue="${project.build.resources}/schema")
    private File[] schemaPaths;
    @Parameter(property="packageName", defaultValue="")
    private String packageName;
    @Parameter(property="typeMapping")
    private Map typeMapping;
    @Parameter(property="subPackageNameClient", defaultValue="client")
    private String subPackageNameClient;
    @Parameter(property="subPackageNameDatafetchers", defaultValue="datafetchers")
    private String subPackageNameDatafetchers;
    @Parameter(property="subPackageNameTypes", defaultValue="types")
    private String subPackageNameTypes;
    @Parameter(property="generateBoxedTypes", defaultValue="false")
    private boolean generateBoxedTypes;
    @Parameter(property="generateClient", defaultValue="false")
    private boolean generateClient;
    @Parameter(property="generateInterfaces", defaultValue="false")
    private boolean generateInterfaces;
    @Parameter(property="outputDir", defaultValue="${project.basedir}/target/generated-sources")
    private File outputDir;
    @Parameter(property="exampleOutputDir", defaultValue="${project.basedir}/target/generated-examples")
    private File exampleOutputDir;
    @Parameter(property="includeQueries")
    private String[] includeQueries;
    @Parameter(property="includeMutations")
    private String[] includeMutations;
    @Parameter(property="skipEntityQueries", defaultValue="false")
    private boolean skipEntityQueries;
    @Parameter(property="shortProjectionNames", defaultValue="false")
    private boolean shortProjectionNames;
    @Parameter(property="generateDataTypes", defaultValue="true")
    private boolean generateDataTypes;
    @Parameter(property="maxProjectionDepth", defaultValue="10")
    private int maxProjectionDepth;

    private String getLanguage() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapper");
            return "KOTLIN";
        }
        catch (ClassNotFoundException e) {
            return "JAVA";
        }
    }

    private void verifySettings() {
        if (this.packageName == null) {
            throw new RuntimeException("Please specify a packageName");
        }
        if (this.schemaPaths.length != Arrays.stream(this.schemaPaths).collect(Collectors.toSet()).size()) {
            throw new RuntimeException("Duplicate entries in schemaPaths");
        }
        for (int i = 0; i < this.schemaPaths.length; ++i) {
            if (this.schemaPaths[i].exists()) continue;
            try {
                throw new RuntimeException("Schema File: " + this.schemaPaths[i].getCanonicalPath() + " does not exist!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.verifySettings();
        CodeGenConfig config = new CodeGenConfig(Collections.emptySet(), Arrays.stream(this.schemaPaths).collect(Collectors.toSet()), this.outputDir.toPath(), this.exampleOutputDir.toPath(), true, this.packageName, this.subPackageNameClient, this.subPackageNameDatafetchers, this.subPackageNameTypes, Language.valueOf((String)this.getLanguage().toUpperCase()), this.generateBoxedTypes, this.generateClient, this.generateInterfaces, this.typeMapping, Arrays.stream(this.includeQueries).collect(Collectors.toSet()), Arrays.stream(this.includeMutations).collect(Collectors.toSet()), this.skipEntityQueries, this.shortProjectionNames, this.generateDataTypes, this.maxProjectionDepth);
        this.getLog().info((CharSequence)("Codegen config: " + config));
        CodeGen codeGen = new CodeGen(config);
        codeGen.generate();
    }
}

