/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen;

import com.netflix.graphql.dgs.codegen.CodeGen;
import com.netflix.graphql.dgs.codegen.CodeGenConfig;
import com.netflix.graphql.dgs.codegen.Language;
import io.github.deweyjose.codegen.generated.GeneratedCodeGenConfigBuilder;
import io.github.deweyjose.graphqlcodegen.CodegenConfigProvider;
import io.github.deweyjose.graphqlcodegen.DependencySchemaExtractor;
import io.github.deweyjose.graphqlcodegen.ParameterMap;
import io.github.deweyjose.graphqlcodegen.SchemaFileManifest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;

public class CodegenExecutor {
    private final Log log;

    public CodegenExecutor(Log log) {
        this.log = log;
    }

    public void execute(CodegenConfigProvider request, Set<Artifact> artifacts, File projectBaseDir) {
        Set<File> fullSchemaPaths;
        if (request.isSkip()) {
            this.log.info((CharSequence)"Skipping code generation as requested (skip=true)");
            return;
        }
        if (request.isOnlyGenerateChanged()) {
            fullSchemaPaths = CodegenExecutor.expandSchemaPaths(request.getSchemaPaths());
            this.log.info((CharSequence)String.format("expanded schema paths: %s", fullSchemaPaths));
        } else {
            fullSchemaPaths = Arrays.stream(request.getSchemaPaths()).collect(Collectors.toSet());
        }
        for (String url : request.getSchemaUrls()) {
            fullSchemaPaths.add(CodegenExecutor.saveUrlToFile(url, request.getSchemaManifestOutputDir()));
        }
        CodegenExecutor.verifySchemaFiles(fullSchemaPaths, request.getSchemaJarFilesFromDependencies());
        SchemaFileManifest manifest = new SchemaFileManifest(new File(request.getSchemaManifestOutputDir(), "schema-manifest.props"), projectBaseDir);
        Set<File> filteredSchemaFiles = fullSchemaPaths;
        if (request.isOnlyGenerateChanged()) {
            filteredSchemaFiles = CodegenExecutor.filterChangedSchemaFiles(fullSchemaPaths, manifest);
            this.log.info((CharSequence)String.format("changed schema files: %s", filteredSchemaFiles));
        }
        if (filteredSchemaFiles.isEmpty() && request.getSchemaJarFilesFromDependencies().length < 1) {
            this.log.info((CharSequence)"no files to generate");
            return;
        }
        Map<String, String> typeMapping = CodegenExecutor.mergeTypeMapping(request.getTypeMapping(), request.getTypeMappingPropertiesFiles(), artifacts);
        List<File> schemaJarFiles = DependencySchemaExtractor.extract(artifacts, request.getSchemaJarFilesFromDependencies());
        CodeGenConfig config = new GeneratedCodeGenConfigBuilder().setSchemas(Collections.emptySet()).setSchemaFiles(filteredSchemaFiles).setSchemaJarFilesFromDependencies(schemaJarFiles).setOutputDir(request.getOutputDir().toPath()).setExamplesOutputDir(request.getExamplesOutputDir().toPath()).setWriteToFiles(request.isWriteToFiles()).setPackageName(request.getPackageName()).setSubPackageNameClient(request.getSubPackageNameClient()).setSubPackageNameDatafetchers(request.getSubPackageNameDatafetchers()).setSubPackageNameTypes(request.getSubPackageNameTypes()).setSubPackageNameDocs(request.getSubPackageNameDocs()).setLanguage(Language.valueOf((String)request.getLanguage().toUpperCase())).setGenerateBoxedTypes(request.isGenerateBoxedTypes()).setGenerateIsGetterForPrimitiveBooleanFields(request.isGenerateIsGetterForPrimitiveBooleanFields()).setGenerateClientApi(request.isGenerateClientApi()).setGenerateClientApiv2(request.isGenerateClientApiv2()).setGenerateInterfaces(request.isGenerateInterfaces()).setGenerateKotlinNullableClasses(request.isGenerateKotlinNullableClasses()).setGenerateKotlinClosureProjections(request.isGenerateKotlinClosureProjections()).setTypeMapping(typeMapping).setIncludeQueries(CodegenExecutor.toSet(request.getIncludeQueries())).setIncludeMutations(CodegenExecutor.toSet(request.getIncludeMutations())).setIncludeSubscriptions(CodegenExecutor.toSet(request.getIncludeSubscriptions())).setSkipEntityQueries(request.isSkipEntityQueries()).setShortProjectionNames(request.isShortProjectionNames()).setGenerateDataTypes(request.isGenerateDataTypes()).setOmitNullInputFields(request.isOmitNullInputFields()).setMaxProjectionDepth(request.getMaxProjectionDepth()).setKotlinAllFieldsOptional(request.isKotlinAllFieldsOptional()).setSnakeCaseConstantNames(request.isSnakeCaseConstantNames()).setGenerateInterfaceSetters(request.isGenerateInterfaceSetters()).setGenerateInterfaceMethodsForInterfaceFields(request.isGenerateInterfaceMethodsForInterfaceFields()).setGenerateDocs(request.getGenerateDocs()).setGeneratedDocsFolder(Paths.get(request.getGeneratedDocsFolder(), new String[0])).setIncludeImports(Optional.ofNullable(request.getIncludeImports()).orElse(Collections.emptyMap())).setIncludeEnumImports(CodegenExecutor.toMap(request.getIncludeEnumImports())).setIncludeClassImports(CodegenExecutor.toMap(request.getIncludeClassImports())).setGenerateCustomAnnotations(request.isGenerateCustomAnnotations()).setJavaGenerateAllConstructor(request.isJavaGenerateAllConstructor()).setImplementSerializable(request.isImplementSerializable()).setAddGeneratedAnnotation(request.isAddGeneratedAnnotation()).setDisableDatesInGeneratedAnnotation(request.isDisableDatesInGeneratedAnnotation()).setAddDeprecatedAnnotation(request.isAddDeprecatedAnnotation()).setTrackInputFieldSet(request.isTrackInputFieldSet()).build();
        this.log.info((CharSequence)String.format("Codegen config: \n%s", config));
        CodeGen codeGen = new CodeGen(config);
        codeGen.generate();
        if (request.isOnlyGenerateChanged()) {
            try {
                manifest.syncManifest();
            }
            catch (Exception e) {
                this.log.warn((CharSequence)"error syncing manifest", (Throwable)e);
            }
        }
    }

    public static Set<File> expandSchemaPaths(File[] schemaPaths) {
        Set configuredSchemaPaths = Arrays.stream(schemaPaths).collect(Collectors.toSet());
        HashSet<File> expandedSchemaPaths = new HashSet<File>();
        for (File path : configuredSchemaPaths) {
            if (path.isFile()) {
                expandedSchemaPaths.add(path);
                continue;
            }
            expandedSchemaPaths.addAll(SchemaFileManifest.findGraphQLSFiles(path));
        }
        return expandedSchemaPaths;
    }

    public static Map<String, String> loadPropertiesFile(File artifactFile, String[] typeMappingPropertiesFiles) {
        HashMap<String, String> typeMapping = new HashMap<String, String>();
        try (JarFile jarFile = new JarFile(artifactFile);){
            for (String file : typeMappingPropertiesFiles) {
                ZipEntry entry = jarFile.getEntry(file);
                if (entry == null) continue;
                try (InputStream inputStream = jarFile.getInputStream(entry);){
                    Properties typeMappingProperties = new Properties();
                    typeMappingProperties.load(inputStream);
                    typeMappingProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> typeMapping.putIfAbsent(String.valueOf(k), String.valueOf(v))));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return typeMapping;
    }

    public static void verifyPackageName(String packageName) {
        if (Objects.isNull(packageName)) {
            throw new IllegalArgumentException("Please specify a packageName");
        }
    }

    public static void verifySchemaFiles(Set<File> fullSchemaPaths, String[] schemaJarFilesFromDependencies) {
        if (fullSchemaPaths.isEmpty() && (schemaJarFilesFromDependencies == null || schemaJarFilesFromDependencies.length < 1)) {
            throw new IllegalArgumentException("No schema files found. Please check your configuration.");
        }
    }

    public static Map<String, String> mergeTypeMapping(Map<String, String> userTypeMapping, String[] typeMappingPropertiesFiles, Set<Artifact> artifacts) {
        HashMap<String, String> jarTypeMapping = new HashMap<String, String>();
        if (typeMappingPropertiesFiles != null && typeMappingPropertiesFiles.length > 0) {
            for (Artifact dependency : artifacts) {
                File artifactFile = dependency.getFile();
                if (artifactFile == null || !artifactFile.isFile()) continue;
                jarTypeMapping.putAll(CodegenExecutor.loadPropertiesFile(artifactFile, typeMappingPropertiesFiles));
            }
        }
        HashMap<String, String> finalTypeMapping = new HashMap<String, String>(jarTypeMapping);
        if (userTypeMapping != null) {
            finalTypeMapping.putAll(userTypeMapping);
        }
        return finalTypeMapping;
    }

    public static Set<File> filterChangedSchemaFiles(Set<File> allSchemaFiles, SchemaFileManifest manifest) {
        manifest.setFiles(new HashSet<File>(allSchemaFiles));
        HashSet<File> changed = new HashSet<File>(allSchemaFiles);
        changed.retainAll(manifest.getChangedFiles());
        return changed;
    }

    public static Set<String> toSet(String[] arr) {
        return Optional.ofNullable(arr).map(a -> Arrays.stream(a).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public static Map<String, Map<String, String>> toMap(Map<String, ParameterMap> m) {
        if (m == null) {
            return Collections.emptyMap();
        }
        return m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() == null ? Collections.emptyMap() : ((ParameterMap)e.getValue()).getProperties()));
    }

    public static String fetchSchema(String url) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        String body = response.body();
        return body;
    }

    public static File saveUrlToFile(String url, File outputDir) throws IOException, InterruptedException {
        String content = CodegenExecutor.fetchSchema(url);
        String fileName = "remote-schemas/" + CodegenExecutor.md5Hex(url) + ".graphqls";
        File outFile = new File(outputDir, fileName);
        Files.createDirectories(outFile.getParentFile().toPath(), new FileAttribute[0]);
        Files.writeString(outFile.toPath(), (CharSequence)content, new OpenOption[0]);
        return outFile;
    }

    private static String md5Hex(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compute MD5 hash", e);
        }
    }
}

