/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen;

import io.github.deweyjose.graphqlcodegen.CodegenConfigProvider;
import io.github.deweyjose.graphqlcodegen.CodegenExecutor;
import io.github.deweyjose.graphqlcodegen.ParameterMap;
import java.io.File;
import java.util.Map;
import lombok.Generated;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class Codegen
extends AbstractMojo
implements CodegenConfigProvider {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="schemaPaths", defaultValue="${project.basedir}/src/main/resources/schema")
    private File[] schemaPaths;
    @Parameter(property="schemaUrls")
    private String[] schemaUrls;
    @Parameter(alias="schemaJarFilesFromDependencies", property="schemaJarFilesFromDependencies")
    private String[] schemaJarFilesFromDependencies;
    @Parameter(property="schemaManifestOutputDir", defaultValue="${project.build.directory}/graphqlcodegen")
    private File schemaManifestOutputDir;
    @Parameter(property="onlyGenerateChanged", defaultValue="true")
    private boolean onlyGenerateChanged;
    @Parameter(property="typeMappingPropertiesFiles")
    private String[] typeMappingPropertiesFiles;
    @Parameter(property="dgs.codegen.skip", defaultValue="false", required=false)
    private boolean skip;
    @Parameter(property="outputDir", defaultValue="${project.build.directory}/generated-sources")
    private File outputDir;
    @Parameter(property="examplesOutputDir", defaultValue="${project.build.directory}/generated-examples")
    private File examplesOutputDir;
    @Parameter(property="writeToFiles", defaultValue="true")
    private boolean writeToFiles;
    @Parameter(property="packageName", defaultValue="")
    private String packageName;
    @Parameter(property="subPackageNameClient", defaultValue="client")
    private String subPackageNameClient;
    @Parameter(property="subPackageNameDatafetchers", defaultValue="datafetchers")
    private String subPackageNameDatafetchers;
    @Parameter(property="subPackageNameTypes", defaultValue="types")
    private String subPackageNameTypes;
    @Parameter(property="subPackageNameDocs", defaultValue="docs")
    private String subPackageNameDocs;
    @Parameter(property="language", defaultValue="java")
    private String language;
    @Parameter(property="typeMapping")
    private Map<String, String> typeMapping;
    @Parameter(property="generateBoxedTypes", defaultValue="false")
    private boolean generateBoxedTypes;
    @Parameter(property="generateIsGetterForPrimitiveBooleanFields", defaultValue="false")
    private boolean generateIsGetterForPrimitiveBooleanFields;
    @Parameter(property="generateClientApi", defaultValue="false")
    private boolean generateClientApi;
    @Parameter(property="generateClientApiv2", defaultValue="false")
    private boolean generateClientApiv2;
    @Parameter(property="generateInterfaces", defaultValue="false")
    private boolean generateInterfaces;
    @Parameter(property="generateKotlinNullableClasses", defaultValue="false")
    private boolean generateKotlinNullableClasses;
    @Parameter(property="generateKotlinClosureProjections", defaultValue="false")
    private boolean generateKotlinClosureProjections;
    @Parameter(property="includeQueries")
    private String[] includeQueries;
    @Parameter(property="includeMutations")
    private String[] includeMutations;
    @Parameter(property="includeSubscriptions")
    private String[] includeSubscriptions;
    @Parameter(property="skipEntityQueries", defaultValue="false")
    private boolean skipEntityQueries;
    @Parameter(property="shortProjectionNames", defaultValue="false")
    private boolean shortProjectionNames;
    @Parameter(property="generateDataTypes", defaultValue="true")
    private boolean generateDataTypes;
    @Parameter(property="omitNullInputFields", defaultValue="false")
    private boolean omitNullInputFields;
    @Parameter(property="maxProjectionDepth", defaultValue="10")
    private int maxProjectionDepth;
    @Parameter(property="kotlinAllFieldsOptional", defaultValue="false")
    private boolean kotlinAllFieldsOptional;
    @Parameter(property="snakeCaseConstantNames", defaultValue="false")
    private boolean snakeCaseConstantNames;
    @Parameter(property="generateInterfaceSetters", defaultValue="false")
    private boolean generateInterfaceSetters;
    @Parameter(property="generateInterfaceMethodsForInterfaceFields", defaultValue="false")
    private boolean generateInterfaceMethodsForInterfaceFields;
    @Parameter(property="generateDocs", defaultValue="false")
    private Boolean generateDocs;
    @Parameter(property="generatedDocsFolder", defaultValue="./generated-docs")
    private String generatedDocsFolder;
    @Parameter(property="javaGenerateAllConstructor", defaultValue="false")
    private boolean javaGenerateAllConstructor;
    @Parameter(property="implementSerializable", defaultValue="false")
    private boolean implementSerializable;
    @Parameter(property="addGeneratedAnnotation", defaultValue="false")
    private boolean addGeneratedAnnotation;
    @Parameter(property="addDeprecatedAnnotation", defaultValue="false")
    private boolean addDeprecatedAnnotation;
    @Parameter(property="trackInputFieldSet", defaultValue="false")
    private boolean trackInputFieldSet;
    @Parameter(property="generateCustomAnnotations", defaultValue="false")
    private boolean generateCustomAnnotations;
    @Parameter(property="includeImports")
    private Map<String, String> includeImports;
    @Parameter(property="includeEnumImports")
    private Map<String, ParameterMap> includeEnumImports;
    @Parameter(property="includeClassImports")
    private Map<String, ParameterMap> includeClassImports;
    @Parameter(property="disableDatesInGeneratedAnnotation", defaultValue="false")
    private boolean disableDatesInGeneratedAnnotation;
    @Parameter(property="autoAddSource", defaultValue="true")
    private boolean autoAddSource;

    public void execute() {
        new CodegenExecutor(this.getLog()).execute(this, this.project.getArtifacts(), this.project.getBasedir());
        if (this.autoAddSource) {
            this.project.addCompileSourceRoot(this.outputDir.getAbsolutePath());
        }
    }

    @Override
    public File[] getSchemaPaths() {
        return this.schemaPaths;
    }

    @Override
    public String[] getSchemaUrls() {
        return this.schemaUrls;
    }

    @Generated
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    @Generated
    public String[] getSchemaJarFilesFromDependencies() {
        return this.schemaJarFilesFromDependencies;
    }

    @Override
    @Generated
    public File getSchemaManifestOutputDir() {
        return this.schemaManifestOutputDir;
    }

    @Override
    @Generated
    public boolean isOnlyGenerateChanged() {
        return this.onlyGenerateChanged;
    }

    @Override
    @Generated
    public String[] getTypeMappingPropertiesFiles() {
        return this.typeMappingPropertiesFiles;
    }

    @Override
    @Generated
    public boolean isSkip() {
        return this.skip;
    }

    @Override
    @Generated
    public File getOutputDir() {
        return this.outputDir;
    }

    @Override
    @Generated
    public File getExamplesOutputDir() {
        return this.examplesOutputDir;
    }

    @Override
    @Generated
    public boolean isWriteToFiles() {
        return this.writeToFiles;
    }

    @Override
    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @Generated
    public String getSubPackageNameClient() {
        return this.subPackageNameClient;
    }

    @Override
    @Generated
    public String getSubPackageNameDatafetchers() {
        return this.subPackageNameDatafetchers;
    }

    @Override
    @Generated
    public String getSubPackageNameTypes() {
        return this.subPackageNameTypes;
    }

    @Override
    @Generated
    public String getSubPackageNameDocs() {
        return this.subPackageNameDocs;
    }

    @Override
    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Override
    @Generated
    public Map<String, String> getTypeMapping() {
        return this.typeMapping;
    }

    @Override
    @Generated
    public boolean isGenerateBoxedTypes() {
        return this.generateBoxedTypes;
    }

    @Override
    @Generated
    public boolean isGenerateIsGetterForPrimitiveBooleanFields() {
        return this.generateIsGetterForPrimitiveBooleanFields;
    }

    @Override
    @Generated
    public boolean isGenerateClientApi() {
        return this.generateClientApi;
    }

    @Override
    @Generated
    public boolean isGenerateClientApiv2() {
        return this.generateClientApiv2;
    }

    @Override
    @Generated
    public boolean isGenerateInterfaces() {
        return this.generateInterfaces;
    }

    @Override
    @Generated
    public boolean isGenerateKotlinNullableClasses() {
        return this.generateKotlinNullableClasses;
    }

    @Override
    @Generated
    public boolean isGenerateKotlinClosureProjections() {
        return this.generateKotlinClosureProjections;
    }

    @Override
    @Generated
    public String[] getIncludeQueries() {
        return this.includeQueries;
    }

    @Override
    @Generated
    public String[] getIncludeMutations() {
        return this.includeMutations;
    }

    @Override
    @Generated
    public String[] getIncludeSubscriptions() {
        return this.includeSubscriptions;
    }

    @Override
    @Generated
    public boolean isSkipEntityQueries() {
        return this.skipEntityQueries;
    }

    @Override
    @Generated
    public boolean isShortProjectionNames() {
        return this.shortProjectionNames;
    }

    @Override
    @Generated
    public boolean isGenerateDataTypes() {
        return this.generateDataTypes;
    }

    @Override
    @Generated
    public boolean isOmitNullInputFields() {
        return this.omitNullInputFields;
    }

    @Override
    @Generated
    public int getMaxProjectionDepth() {
        return this.maxProjectionDepth;
    }

    @Override
    @Generated
    public boolean isKotlinAllFieldsOptional() {
        return this.kotlinAllFieldsOptional;
    }

    @Override
    @Generated
    public boolean isSnakeCaseConstantNames() {
        return this.snakeCaseConstantNames;
    }

    @Override
    @Generated
    public boolean isGenerateInterfaceSetters() {
        return this.generateInterfaceSetters;
    }

    @Override
    @Generated
    public boolean isGenerateInterfaceMethodsForInterfaceFields() {
        return this.generateInterfaceMethodsForInterfaceFields;
    }

    @Override
    @Generated
    public Boolean getGenerateDocs() {
        return this.generateDocs;
    }

    @Override
    @Generated
    public String getGeneratedDocsFolder() {
        return this.generatedDocsFolder;
    }

    @Override
    @Generated
    public boolean isJavaGenerateAllConstructor() {
        return this.javaGenerateAllConstructor;
    }

    @Override
    @Generated
    public boolean isImplementSerializable() {
        return this.implementSerializable;
    }

    @Override
    @Generated
    public boolean isAddGeneratedAnnotation() {
        return this.addGeneratedAnnotation;
    }

    @Override
    @Generated
    public boolean isAddDeprecatedAnnotation() {
        return this.addDeprecatedAnnotation;
    }

    @Override
    @Generated
    public boolean isTrackInputFieldSet() {
        return this.trackInputFieldSet;
    }

    @Override
    @Generated
    public boolean isGenerateCustomAnnotations() {
        return this.generateCustomAnnotations;
    }

    @Override
    @Generated
    public Map<String, String> getIncludeImports() {
        return this.includeImports;
    }

    @Override
    @Generated
    public Map<String, ParameterMap> getIncludeEnumImports() {
        return this.includeEnumImports;
    }

    @Override
    @Generated
    public Map<String, ParameterMap> getIncludeClassImports() {
        return this.includeClassImports;
    }

    @Override
    @Generated
    public boolean isDisableDatesInGeneratedAnnotation() {
        return this.disableDatesInGeneratedAnnotation;
    }

    @Override
    @Generated
    public boolean isAutoAddSource() {
        return this.autoAddSource;
    }
}

