/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen;

import com.netflix.graphql.dgs.codegen.CodeGen;
import com.netflix.graphql.dgs.codegen.CodeGenConfig;
import com.netflix.graphql.dgs.codegen.Language;
import io.github.deweyjose.codegen.generated.GeneratedCodeGenConfigBuilder;
import io.github.deweyjose.graphqlcodegen.CodegenConfigProvider;
import io.github.deweyjose.graphqlcodegen.Logger;
import io.github.deweyjose.graphqlcodegen.parameters.ParameterMap;
import io.github.deweyjose.graphqlcodegen.services.SchemaFileService;
import io.github.deweyjose.graphqlcodegen.services.TypeMappingService;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;

public class CodegenExecutor {
    private final SchemaFileService schemaFileService;
    private final TypeMappingService typeMappingService;

    public CodegenExecutor(SchemaFileService schemaFileService, TypeMappingService typeMappingService) {
        this.schemaFileService = schemaFileService;
        this.typeMappingService = typeMappingService;
    }

    public void execute(CodegenConfigProvider request, Set<Artifact> artifacts, File projectBaseDir) {
        if (request.isOnlyGenerateChanged()) {
            this.schemaFileService.loadExpandedSchemaPaths(CodegenExecutor.toSet(request.getSchemaPaths()));
            Logger.info("expanded schema paths: {}", this.schemaFileService.getSchemaPaths());
        } else {
            this.schemaFileService.setSchemaPaths(CodegenExecutor.toSet(request.getSchemaPaths()));
        }
        this.schemaFileService.loadSchemaJarFilesFromDependencies(artifacts, CodegenExecutor.toSet(request.getSchemaJarFilesFromDependencies()));
        this.schemaFileService.loadSchemaUrls(request.getSchemaUrls());
        this.schemaFileService.loadIntrospectedSchemas(request.getIntrospectionRequests());
        this.schemaFileService.checkHasSchemaFiles();
        if (request.isOnlyGenerateChanged()) {
            this.schemaFileService.filterChangedSchemaFiles();
            Logger.info("changed schema files: {}", this.schemaFileService.getSchemaPaths());
        }
        if (this.schemaFileService.noWorkToDo()) {
            Logger.info("no files to generate", new Object[0]);
            return;
        }
        Map<String, String> typeMapping = this.typeMappingService.mergeTypeMapping(request.getTypeMapping(), request.getTypeMappingPropertiesFiles(), artifacts);
        CodeGenConfig config = new GeneratedCodeGenConfigBuilder().setSchemas(Collections.emptySet()).setSchemaFiles(this.schemaFileService.getSchemaPaths()).setSchemaJarFilesFromDependencies(this.schemaFileService.getSchemaJarFilesFromDependencies()).setOutputDir(request.getOutputDir().toPath()).setExamplesOutputDir(request.getExamplesOutputDir().toPath()).setWriteToFiles(request.isWriteToFiles()).setPackageName(request.getPackageName()).setSubPackageNameClient(request.getSubPackageNameClient()).setSubPackageNameDatafetchers(request.getSubPackageNameDatafetchers()).setSubPackageNameTypes(request.getSubPackageNameTypes()).setSubPackageNameDocs(request.getSubPackageNameDocs()).setLanguage(Language.valueOf((String)request.getLanguage().toUpperCase())).setGenerateBoxedTypes(request.isGenerateBoxedTypes()).setGenerateIsGetterForPrimitiveBooleanFields(request.isGenerateIsGetterForPrimitiveBooleanFields()).setGenerateClientApi(request.isGenerateClientApi()).setGenerateClientApiv2(request.isGenerateClientApiv2()).setGenerateInterfaces(request.isGenerateInterfaces()).setGenerateKotlinNullableClasses(request.isGenerateKotlinNullableClasses()).setGenerateKotlinClosureProjections(request.isGenerateKotlinClosureProjections()).setTypeMapping(typeMapping).setIncludeQueries(CodegenExecutor.toSet(request.getIncludeQueries())).setIncludeMutations(CodegenExecutor.toSet(request.getIncludeMutations())).setIncludeSubscriptions(CodegenExecutor.toSet(request.getIncludeSubscriptions())).setSkipEntityQueries(request.isSkipEntityQueries()).setShortProjectionNames(request.isShortProjectionNames()).setGenerateDataTypes(request.isGenerateDataTypes()).setOmitNullInputFields(request.isOmitNullInputFields()).setMaxProjectionDepth(request.getMaxProjectionDepth()).setKotlinAllFieldsOptional(request.isKotlinAllFieldsOptional()).setSnakeCaseConstantNames(request.isSnakeCaseConstantNames()).setGenerateInterfaceSetters(request.isGenerateInterfaceSetters()).setGenerateInterfaceMethodsForInterfaceFields(request.isGenerateInterfaceMethodsForInterfaceFields()).setGenerateDocs(request.getGenerateDocs()).setGeneratedDocsFolder(Paths.get(request.getGeneratedDocsFolder(), new String[0])).setIncludeImports(Optional.ofNullable(request.getIncludeImports()).orElse(Collections.emptyMap())).setIncludeEnumImports(CodegenExecutor.toMap(request.getIncludeEnumImports())).setIncludeClassImports(CodegenExecutor.toMap(request.getIncludeClassImports())).setGenerateCustomAnnotations(request.isGenerateCustomAnnotations()).setJavaGenerateAllConstructor(request.isJavaGenerateAllConstructor()).setImplementSerializable(request.isImplementSerializable()).setAddGeneratedAnnotation(request.isAddGeneratedAnnotation()).setDisableDatesInGeneratedAnnotation(request.isDisableDatesInGeneratedAnnotation()).setAddDeprecatedAnnotation(request.isAddDeprecatedAnnotation()).setTrackInputFieldSet(request.isTrackInputFieldSet()).build();
        Logger.info("Codegen config: \n{}", config);
        CodeGen codeGen = new CodeGen(config);
        codeGen.generate();
        if (request.isOnlyGenerateChanged()) {
            this.schemaFileService.syncManifest();
        }
    }

    public static <T> Set<T> toSet(T[] arr) {
        return Optional.ofNullable(arr).map(a -> Arrays.stream(a).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public static Map<String, Map<String, String>> toMap(Map<String, ParameterMap> m) {
        if (m == null) {
            return Collections.emptyMap();
        }
        return m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() == null ? Collections.emptyMap() : ((ParameterMap)e.getValue()).getProperties()));
    }
}

