/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen.services;

import io.github.deweyjose.graphqlcodegen.parameters.IntrospectionRequest;
import io.github.deweyjose.graphqlcodegen.services.RemoteSchemaService;
import io.github.deweyjose.graphqlcodegen.services.SchemaManifestService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.maven.artifact.Artifact;

public class SchemaFileService {
    private final File outputDir;
    private final SchemaManifestService manifest;
    private final RemoteSchemaService remoteSchemaService;
    private Set<File> schemaPaths = new HashSet<File>();
    private List<File> schemaJarFilesFromDependencies;

    public SchemaFileService(File outputDir, SchemaManifestService manifest) {
        this(outputDir, manifest, new RemoteSchemaService());
    }

    public SchemaFileService(File outputDir, SchemaManifestService manifest, RemoteSchemaService remoteSchemaService) {
        this.outputDir = outputDir;
        this.manifest = manifest;
        this.remoteSchemaService = remoteSchemaService;
    }

    public void loadExpandedSchemaPaths(Collection<File> schemaPaths) {
        this.setSchemaPaths(schemaPaths.stream().map(path -> {
            if (path.isFile()) {
                return Stream.of(path);
            }
            return SchemaFileService.findGraphQLSFiles(path).stream();
        }).flatMap(stream -> stream).collect(Collectors.toSet()));
    }

    public void loadSchemaJarFilesFromDependencies(Set<Artifact> artifacts, Collection<String> schemaJarFilesFromDependencies) {
        this.schemaJarFilesFromDependencies = SchemaFileService.extractSchemaFilesFromDependencies(artifacts, schemaJarFilesFromDependencies);
    }

    public void loadSchemaUrls(String[] schemaUrls) {
        for (String url : schemaUrls) {
            String content = this.remoteSchemaService.getRemoteSchemaFile(url);
            this.schemaPaths.add(this.saveUrlToFile(url, content));
        }
    }

    public void loadIntrospectedSchemas(Collection<IntrospectionRequest> schemaUrls) {
        for (IntrospectionRequest request : schemaUrls) {
            String query = Optional.ofNullable(request.getQuery()).orElse("query IntrospectionQuery {\n  __schema {\n    queryType { name }\n    mutationType { name }\n    subscriptionType { name }\n    types {\n      ...FullType\n    }\n    directives {\n      name\n      description\n      locations\n      args {\n        ...InputValue\n      }\n    }\n  }\n}\n\nfragment FullType on __Type {\n  kind\n  name\n  description\n  fields(includeDeprecated: true) {\n    name\n    description\n    args {\n      ...InputValue\n    }\n    type {\n      ...TypeRef\n    }\n    isDeprecated\n    deprecationReason\n  }\n  inputFields {\n    ...InputValue\n  }\n  interfaces {\n    ...TypeRef\n  }\n  enumValues(includeDeprecated: true) {\n    name\n    description\n    isDeprecated\n    deprecationReason\n  }\n  possibleTypes {\n    ...TypeRef\n  }\n}\n\nfragment InputValue on __InputValue {\n  name\n  description\n  type {\n    ...TypeRef\n  }\n  defaultValue\n}\n\nfragment TypeRef on __Type {\n  kind\n  name\n  ofType {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n            }\n          }\n        }\n      }\n    }\n  }\n}\n");
            String operationName = Optional.ofNullable(request.getOperationName()).orElse("IntrospectionQuery");
            RemoteSchemaService.IntrospectionOperation operation = RemoteSchemaService.IntrospectionOperation.builder().query(query).operationName(operationName).build();
            String content = this.remoteSchemaService.getIntrospectedSchemaFile(request.getUrl(), operation, request.getHeaders());
            this.schemaPaths.add(this.saveUrlToFile(request.getUrl(), content));
        }
    }

    public void checkHasSchemaFiles() {
        if (this.getSchemaPaths().isEmpty() && Optional.ofNullable(this.getSchemaJarFilesFromDependencies()).orElse(Collections.emptyList()).isEmpty()) {
            throw new IllegalArgumentException("No schema files found. Please check your configuration.");
        }
    }

    public boolean noWorkToDo() {
        return this.getSchemaPaths().isEmpty() && this.getSchemaJarFilesFromDependencies().isEmpty();
    }

    public void syncManifest() {
        try {
            this.manifest.syncManifest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void filterChangedSchemaFiles() {
        this.manifest.setFiles(new HashSet<File>(this.schemaPaths));
        HashSet<File> changed = new HashSet<File>(this.schemaPaths);
        changed.retainAll(this.manifest.getChangedFiles());
        this.setSchemaPaths(changed);
    }

    public String fetchSchema(String url) throws IOException, InterruptedException {
        return this.remoteSchemaService.getRemoteSchemaFile(url);
    }

    private File saveUrlToFile(String url, String content) throws IOException, InterruptedException {
        String fileName = "remote-schemas/" + Base64.getEncoder().encodeToString(url.getBytes()) + ".graphqls";
        File outFile = new File(this.outputDir, fileName);
        Files.createDirectories(outFile.getParentFile().toPath(), new FileAttribute[0]);
        Files.writeString(outFile.toPath(), (CharSequence)content, new OpenOption[0]);
        return outFile;
    }

    public static Set<File> findGraphQLSFiles(File directory) {
        HashSet<File> result = new HashSet<File>();
        File[] contents = directory.listFiles();
        if (contents != null) {
            for (File content : contents) {
                if (content.isFile() && SchemaFileService.isGraphqlFile(content)) {
                    result.add(content);
                    continue;
                }
                if (!content.isDirectory()) continue;
                Set<File> subdirectoryGraphQLSFiles = SchemaFileService.findGraphQLSFiles(content);
                result.addAll(subdirectoryGraphQLSFiles);
            }
        }
        return result;
    }

    public static boolean isGraphqlFile(File file) {
        return file.getName().endsWith(".graphqls") || file.getName().endsWith(".graphql") || file.getName().endsWith(".gqls");
    }

    public static List<File> extractSchemaFilesFromDependencies(Set<Artifact> dependencyArtifacts, Collection<String> schemaJarFilesFromDependencies) {
        return schemaJarFilesFromDependencies.stream().map(String::trim).filter(jarDep -> !jarDep.isEmpty()).map(jarDep -> SchemaFileService.findArtifactFromDependencies(dependencyArtifacts, jarDep)).filter(Optional::isPresent).map(Optional::get).map(Artifact::getFile).toList();
    }

    private static Optional<Artifact> findArtifactFromDependencies(Set<Artifact> dependencyArtifacts, String artifactRef) {
        String cleanRef = artifactRef.trim();
        for (Artifact artifact : dependencyArtifacts) {
            String ref = String.format("%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            if (!ref.equals(cleanRef)) continue;
            return Optional.of(artifact);
        }
        return Optional.empty();
    }

    @Generated
    public File getOutputDir() {
        return this.outputDir;
    }

    @Generated
    public SchemaManifestService getManifest() {
        return this.manifest;
    }

    @Generated
    public RemoteSchemaService getRemoteSchemaService() {
        return this.remoteSchemaService;
    }

    @Generated
    public Set<File> getSchemaPaths() {
        return this.schemaPaths;
    }

    @Generated
    public List<File> getSchemaJarFilesFromDependencies() {
        return this.schemaJarFilesFromDependencies;
    }

    @Generated
    public void setSchemaPaths(Set<File> schemaPaths) {
        this.schemaPaths = schemaPaths;
    }

    @Generated
    public void setSchemaJarFilesFromDependencies(List<File> schemaJarFilesFromDependencies) {
        this.schemaJarFilesFromDependencies = schemaJarFilesFromDependencies;
    }
}

