/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.button;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsAttribute;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.component.button.ButtonStyleHelper;
import com.didi.hummer.component.text.FontManager;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.render.component.view.HMBase;
import java.util.HashMap;
import java.util.Map;

@Component(value="Button")
public class Button
extends HMBase<android.widget.Button> {
    private Drawable orgBackground;
    private ColorStateList orgTextColors;
    private float orgTextSize;
    private Typeface orgTypeface;
    private Map<Integer, Integer> textColorMap = new HashMap<Integer, Integer>();
    private Map<Integer, Drawable> bgDrawableMap = new HashMap<Integer, Drawable>();
    @JsProperty(value="text")
    private String text;
    @JsProperty(value="pressed")
    private Map<String, Object> pressed;
    @JsProperty(value="disabled")
    private Map<String, Object> disabled;

    public Button(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
    }

    protected android.widget.Button createViewInstance(Context context) {
        return new android.widget.Button(context);
    }

    public void onCreate() {
        super.onCreate();
        this.orgBackground = ((android.widget.Button)this.getView()).getBackground();
        this.orgTextColors = ((android.widget.Button)this.getView()).getTextColors();
        this.orgTextSize = ((android.widget.Button)this.getView()).getTextSize();
        ((android.widget.Button)this.getView()).setBackground(null);
        ((android.widget.Button)this.getView()).setAllCaps(false);
        ((android.widget.Button)this.getView()).setTypeface(null, 0);
        this.setFontFamily("DEFAULT_FONT_FAMILY");
        this.orgTypeface = ((android.widget.Button)this.getView()).getTypeface();
        if (Build.VERSION.SDK_INT >= 21) {
            ((android.widget.Button)this.getView()).setStateListAnimator(null);
        }
    }

    private void requestLayout() {
        this.getYogaNode().dirty();
        ((android.widget.Button)this.getView()).requestLayout();
    }

    public void setBackgroundColor(Object color) {
        super.setBackgroundColor(color);
        ((android.widget.Button)this.getView()).setMinWidth(0);
        ((android.widget.Button)this.getView()).setMinHeight(0);
        ((android.widget.Button)this.getView()).setMinimumHeight(0);
        ((android.widget.Button)this.getView()).setMinimumWidth(0);
        ((android.widget.Button)this.getView()).setPadding(0, 0, 0, 0);
    }

    public void setBackgroundImage(String image) {
        super.setBackgroundImage(image);
        ((android.widget.Button)this.getView()).setMinWidth(0);
        ((android.widget.Button)this.getView()).setMinHeight(0);
        ((android.widget.Button)this.getView()).setMinimumHeight(0);
        ((android.widget.Button)this.getView()).setMinimumWidth(0);
        ((android.widget.Button)this.getView()).setPadding(0, 0, 0, 0);
    }

    public void setText(String text) {
        ((android.widget.Button)this.getView()).setText((CharSequence)text);
        this.requestLayout();
        this.getNode().setContent(text);
    }

    public void setPressed(Map<String, Object> pressed) {
        this.pressed = pressed;
        this.mergePressedStyle();
        this.updateBackground();
    }

    public void setDisabled(Map<String, Object> disabled) {
        this.disabled = disabled;
        this.mergeDisabledStyle();
        this.updateBackground();
    }

    private void mergePressedStyle() {
        Integer textColor;
        ButtonStyleHelper.fillButtonPressedAndDisabledStyle(this.style, this.pressed);
        Drawable bgDrawable = ButtonStyleHelper.pickButtonBackgroundDrawable(this.pressed);
        if (bgDrawable != null) {
            this.bgDrawableMap.put(1, bgDrawable);
        }
        if ((textColor = ButtonStyleHelper.pickButtonTextColor(this.pressed)) != null) {
            this.textColorMap.put(1, textColor);
        }
    }

    private void mergeDisabledStyle() {
        Integer textColor;
        ButtonStyleHelper.fillButtonPressedAndDisabledStyle(this.style, this.disabled);
        Drawable bgDrawable = ButtonStyleHelper.pickButtonBackgroundDrawable(this.disabled);
        if (bgDrawable != null) {
            this.bgDrawableMap.put(2, bgDrawable);
        }
        if ((textColor = ButtonStyleHelper.pickButtonTextColor(this.disabled)) != null) {
            this.textColorMap.put(2, textColor);
        }
    }

    @JsAttribute(value={"textAlign"})
    public void setTextAlign(String textAlign) {
        switch (textAlign.toLowerCase()) {
            default: {
                ((android.widget.Button)this.getView()).setGravity(17);
                break;
            }
            case "left": {
                ((android.widget.Button)this.getView()).setGravity(8388627);
                break;
            }
            case "right": {
                ((android.widget.Button)this.getView()).setGravity(8388629);
            }
        }
    }

    @JsAttribute(value={"fontFamily"})
    public void setFontFamily(String fontFamily) {
        if (TextUtils.isEmpty((CharSequence)fontFamily)) {
            return;
        }
        String[] fontArray = fontFamily.split(",");
        if (fontArray.length == 0) {
            return;
        }
        int style = 0;
        if (((android.widget.Button)this.getView()).getTypeface() != null) {
            style = ((android.widget.Button)this.getView()).getTypeface().getStyle();
        }
        for (String font : fontArray) {
            Typeface typeface = FontManager.getInstance().getTypeface((HummerContext)this.getContext(), font.trim(), style);
            if (typeface == null) continue;
            ((android.widget.Button)this.getView()).setTypeface(typeface);
            this.requestLayout();
            break;
        }
    }

    @JsAttribute(value={"fontSize"})
    public void setFontSize(float fontSize) {
        ((android.widget.Button)this.getView()).setTextSize(0, fontSize);
        this.requestLayout();
    }

    @JsAttribute(value={"color"})
    public void setColor(int color) {
        ((android.widget.Button)this.getView()).setTextColor(color);
    }

    public void onStyleUpdated(Map<String, Object> newStyle) {
        if (newStyle.containsKey("backgroundColor")) {
            this.bgDrawableMap.put(0, this.backgroundHelper.getBackgroundDrawable());
        }
        if (newStyle.containsKey("color")) {
            this.textColorMap.put(0, ButtonStyleHelper.pickButtonTextColor(newStyle));
        }
        this.mergePressedStyle();
        this.mergeDisabledStyle();
        this.updateBackground();
    }

    private void updateBackground() {
        this.updateBackgroundDrawable();
        this.updateTextColor();
    }

    private void updateBackgroundDrawable() {
        if (this.bgDrawableMap.containsKey(1) || this.bgDrawableMap.containsKey(2)) {
            StateListDrawable stateListDrawable = ButtonStyleHelper.makeButtonBackgroundColorStateList(this.bgDrawableMap);
            this.backgroundHelper.setBackgroundDrawable((Drawable)stateListDrawable);
        }
    }

    private void updateTextColor() {
        Integer color;
        if (this.textColorMap.containsKey(1) || this.textColorMap.containsKey(2)) {
            ColorStateList color2;
            if (!this.textColorMap.containsKey(0)) {
                this.textColorMap.put(0, -16777216);
            }
            if ((color2 = ButtonStyleHelper.makeButtonTextColorStateList(this.textColorMap)) != null) {
                ((android.widget.Button)this.getView()).setTextColor(color2);
            }
        } else if (this.textColorMap.containsKey(0) && (color = this.textColorMap.get(0)) != null) {
            ((android.widget.Button)this.getView()).setTextColor(color.intValue());
        }
    }

    public void resetStyle() {
        super.resetStyle();
        ((android.widget.Button)this.getView()).setBackground(this.orgBackground);
        ((android.widget.Button)this.getView()).setTextColor(this.orgTextColors);
        ((android.widget.Button)this.getView()).setTextSize(0, this.orgTextSize);
        ((android.widget.Button)this.getView()).setTypeface(this.orgTypeface);
        this.setTextAlign("center");
    }

    public boolean setStyle(String key, Object value) {
        switch (key) {
            case "color": {
                this.setColor((Integer)value);
                break;
            }
            case "fontSize": {
                this.setFontSize(((Float)value).floatValue());
                break;
            }
            case "fontFamily": {
                this.setFontFamily(String.valueOf(value));
                break;
            }
            case "textAlign": {
                this.setTextAlign(String.valueOf(value));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

