/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.button;

import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import com.didi.hummer.render.component.view.BackgroundDrawable;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.didi.hummer.render.utility.YogaAttrUtils;
import java.util.ArrayList;
import java.util.Map;

public class ButtonStyleHelper {
    public static final String KEY_BACKGROUND_COLOR = "backgroundColor";
    public static final String KEY_BORDER_WIDTH = "borderWidth";
    public static final String KEY_BORDER_COLOR = "borderColor";
    public static final String KEY_BORDER_RADIUS = "borderRadius";
    public static final String KEY_BORDER_STYLE = "borderStyle";
    public static final String KEY_TEXT_COLOR = "color";
    public static final int KEY_ON_NORMAL = 0;
    public static final int KEY_ON_PRESS = 1;
    public static final int KEY_ON_DISABLE = 2;

    public static void fillButtonPressedAndDisabledStyle(Map<String, Object> fullStyle, Map<String, Object> subStyle) {
        if (fullStyle == null || subStyle == null) {
            return;
        }
        if (fullStyle.containsKey(KEY_BACKGROUND_COLOR) && !subStyle.containsKey(KEY_BACKGROUND_COLOR)) {
            subStyle.put(KEY_BACKGROUND_COLOR, fullStyle.get(KEY_BACKGROUND_COLOR));
        }
        if (fullStyle.containsKey(KEY_BORDER_WIDTH) && !subStyle.containsKey(KEY_BORDER_WIDTH)) {
            subStyle.put(KEY_BORDER_WIDTH, fullStyle.get(KEY_BORDER_WIDTH));
        }
        if (fullStyle.containsKey(KEY_BORDER_COLOR) && !subStyle.containsKey(KEY_BORDER_COLOR)) {
            subStyle.put(KEY_BORDER_COLOR, fullStyle.get(KEY_BORDER_COLOR));
        }
        if (fullStyle.containsKey(KEY_BORDER_RADIUS) && !subStyle.containsKey(KEY_BORDER_RADIUS)) {
            subStyle.put(KEY_BORDER_RADIUS, fullStyle.get(KEY_BORDER_RADIUS));
        }
        if (fullStyle.containsKey(KEY_BORDER_STYLE) && !subStyle.containsKey(KEY_BORDER_STYLE)) {
            subStyle.put(KEY_BORDER_STYLE, fullStyle.get(KEY_BORDER_STYLE));
        }
        if (fullStyle.containsKey(KEY_TEXT_COLOR) && !subStyle.containsKey(KEY_TEXT_COLOR)) {
            subStyle.put(KEY_TEXT_COLOR, fullStyle.get(KEY_TEXT_COLOR));
        }
    }

    public static Drawable pickButtonBackgroundDrawable(Map<String, Object> style) {
        Object stl;
        Object radius;
        Object width;
        if (style == null) {
            return null;
        }
        Object bgColor = null;
        if (style.containsKey(KEY_BACKGROUND_COLOR)) {
            bgColor = style.get(KEY_BACKGROUND_COLOR);
            bgColor = HummerStyleUtils.convertColor((Object)bgColor);
        }
        BackgroundDrawable drawable = new BackgroundDrawable();
        drawable.setColor(bgColor);
        if (style.containsKey(KEY_BORDER_WIDTH) && (width = style.get(KEY_BORDER_WIDTH)) != null) {
            drawable.setBorderWidth(HummerStyleUtils.convertNumber((Object)width));
        }
        if (style.containsKey(KEY_BORDER_COLOR)) {
            Object color = style.get(KEY_BORDER_COLOR);
            if ((color = HummerStyleUtils.convertColor((Object)color)) != null) {
                drawable.setBorderColor(((Integer)color).intValue());
            }
        }
        if (style.containsKey(KEY_BORDER_RADIUS) && (radius = style.get(KEY_BORDER_RADIUS)) != null) {
            drawable.setBorderRadius(HummerStyleUtils.convertNumber((Object)radius));
        }
        if (style.containsKey(KEY_BORDER_STYLE) && (stl = style.get(KEY_BORDER_STYLE)) != null) {
            drawable.setBorderStyle((String)stl);
        }
        return drawable;
    }

    public static StateListDrawable makeButtonBackgroundColorStateList(Map<Integer, Drawable> bgDrawableMap) {
        int[] state;
        StateListDrawable stateListDrawable = new StateListDrawable();
        if (bgDrawableMap.containsKey(2)) {
            state = new int[]{-16842910};
            stateListDrawable.addState(state, bgDrawableMap.get(2));
        }
        if (bgDrawableMap.containsKey(1)) {
            state = new int[]{16842919};
            stateListDrawable.addState(state, bgDrawableMap.get(1));
        }
        if (bgDrawableMap.containsKey(0)) {
            state = new int[]{};
            stateListDrawable.addState(state, bgDrawableMap.get(0));
        }
        return stateListDrawable;
    }

    public static Integer pickButtonTextColor(Map<String, Object> style) {
        Object object;
        if (style == null) {
            return null;
        }
        Integer color = null;
        if (style.containsKey(KEY_TEXT_COLOR) && (object = style.get(KEY_TEXT_COLOR)) instanceof String) {
            color = YogaAttrUtils.parseColor((String)((String)object));
        }
        return color;
    }

    public static ColorStateList makeButtonTextColorStateList(Map<Integer, Integer> textColorMap) {
        ArrayList<int[]> states = new ArrayList<int[]>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        if (textColorMap.containsKey(2)) {
            states.add(new int[]{-16842910});
            colors.add(textColorMap.get(2));
        }
        if (textColorMap.containsKey(1)) {
            states.add(new int[]{16842919});
            colors.add(textColorMap.get(1));
        }
        if (textColorMap.containsKey(0)) {
            states.add(new int[0]);
            colors.add(textColorMap.get(0));
        }
        if (states.size() <= 0) {
            return null;
        }
        int[][] stateArray = new int[states.size()][];
        int[] colorArray = new int[colors.size()];
        for (int i = 0; i < colors.size(); ++i) {
            colorArray[i] = (Integer)colors.get(i);
        }
        return new ColorStateList((int[][])states.toArray((T[])stateArray), colorArray);
    }
}

