/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.canvas;

import android.graphics.Color;
import android.graphics.Paint;
import android.text.TextPaint;

public class CanvasContext {
    private static final String TAG = "CanvasDrawHelperView";
    private Paint linePaint = new Paint();
    private Paint fillPaint = new Paint();
    private TextPaint textPaint = new TextPaint();

    public CanvasContext() {
        this.fillPaint.setAntiAlias(true);
        this.linePaint.setAntiAlias(true);
        this.textPaint.setAntiAlias(true);
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public TextPaint getTextPaint() {
        return this.textPaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void lineWidth(float w) {
        this.linePaint.setStrokeWidth(w);
    }

    public void lineCap(int cap) {
        switch (cap) {
            case 0: {
                this.linePaint.setStrokeCap(Paint.Cap.BUTT);
                break;
            }
            case 1: {
                this.linePaint.setStrokeCap(Paint.Cap.ROUND);
                break;
            }
            case 2: {
                this.linePaint.setStrokeCap(Paint.Cap.SQUARE);
                break;
            }
            default: {
                this.linePaint.setStrokeCap(Paint.Cap.BUTT);
            }
        }
    }

    public void lineJoin(int join) {
        switch (join) {
            case 0: {
                this.linePaint.setStrokeJoin(Paint.Join.MITER);
                break;
            }
            case 1: {
                this.linePaint.setStrokeJoin(Paint.Join.ROUND);
                break;
            }
            case 2: {
                this.linePaint.setStrokeJoin(Paint.Join.BEVEL);
                break;
            }
            default: {
                this.linePaint.setStrokeJoin(Paint.Join.MITER);
            }
        }
    }

    public void lineColor(String color) {
        this.fillPaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setColor(Color.parseColor((String)color));
    }

    public void fillColor(String color) {
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.fillPaint.setColor(Color.parseColor((String)color));
    }

    public void textColor(String color) {
        this.textPaint.setColor(Color.parseColor((String)color));
    }
}

