/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.canvas;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.didi.hummer.component.canvas.CanvasContext;
import com.didi.hummer.component.canvas.CanvasPath;
import com.didi.hummer.render.style.HummerStyleUtils;
import java.util.ArrayList;
import java.util.List;

public class CanvasDrawHelperView
extends View {
    private static final String TAG = "CanvasDrawHelperView";
    private CanvasContext canvasContext = new CanvasContext();
    private List<CanvasAction> actions = new ArrayList<CanvasAction>();

    public CanvasDrawHelperView(Context context) {
        super(context);
    }

    public CanvasDrawHelperView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CanvasDrawHelperView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CanvasContext getCanvasContext() {
        return this.canvasContext;
    }

    private Paint getLinePaint() {
        return this.canvasContext.getLinePaint();
    }

    private Paint getFillPaint() {
        return this.canvasContext.getFillPaint();
    }

    private TextPaint getTextPaint() {
        return this.canvasContext.getTextPaint();
    }

    private float dp2px(Object v) {
        return HummerStyleUtils.convertNumber((Object)v);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (CanvasAction action : this.actions) {
            action.draw(canvas);
        }
    }

    public void drawImage(Bitmap bitmap, Object x, Object y, Object dWidth, Object dHeight) {
        this.actions.add(canvas -> {
            if (bitmap == null) {
                return;
            }
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            float w_px = this.dp2px(dWidth);
            float h_px = this.dp2px(dHeight);
            float scaleWidth = w_px / (float)width;
            float scaleHeight = h_px / (float)height;
            matrix.postScale(scaleWidth, scaleHeight);
            Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            float x_px = this.dp2px(x);
            float y_px = this.dp2px(y);
            canvas.drawBitmap(newBitmap, x_px, y_px, this.getLinePaint());
        });
        this.invalidate();
    }

    public void fillRect(Object x, Object y, Object width, Object height) {
        Log.i((String)TAG, (String)"fillRect do");
        this.actions.add(canvas -> {
            this.getFillPaint().setStyle(Paint.Style.FILL);
            Log.i((String)TAG, (String)"fillRect Action");
            float x_px = this.dp2px(x);
            float y_px = this.dp2px(y);
            float width_px = this.dp2px(width);
            float height_px = this.dp2px(height);
            Rect rect = new Rect((int)x_px, (int)y_px, (int)(x_px + width_px), (int)(y_px + height_px));
            canvas.drawRect(rect, this.getFillPaint());
        });
        this.invalidate();
    }

    public void strokeRect(Object x, Object y, Object width, Object height) {
        this.actions.add(canvas -> {
            this.getLinePaint().setStyle(Paint.Style.STROKE);
            float x_px = this.dp2px(x);
            float y_px = this.dp2px(y);
            float width_px = this.dp2px(width);
            float height_px = this.dp2px(height);
            Rect rect = new Rect((int)x_px, (int)y_px, (int)(x_px + width_px), (int)(y_px + height_px));
            canvas.drawRect(rect, this.getLinePaint());
        });
        this.invalidate();
    }

    public void fillCircle(Object x, Object y, Object radius) {
        this.actions.add(canvas -> {
            this.getFillPaint().setStyle(Paint.Style.FILL);
            float x_px = this.dp2px(x);
            float y_px = this.dp2px(y);
            float radius_px = this.dp2px(radius);
            canvas.drawCircle(x_px, y_px, radius_px, this.getFillPaint());
        });
        this.invalidate();
    }

    public void strokeCircle(Object x, Object y, Object radius) {
        this.actions.add(canvas -> {
            this.getLinePaint().setStyle(Paint.Style.STROKE);
            float x_px = this.dp2px(x);
            float y_px = this.dp2px(y);
            float radius_px = this.dp2px(radius);
            canvas.drawCircle(x_px, y_px, radius_px, this.getLinePaint());
        });
        this.invalidate();
    }

    public void fontSize(float size) {
        this.actions.add(canvas -> {
            float size_px = this.dp2px(Float.valueOf(size));
            this.getTextPaint().setTextSize(size_px);
        });
    }

    public void fillText(String text, Object x, Object y, Object maxWidth) {
        this.actions.add(canvas -> {
            float x_px = this.dp2px(x);
            float y_px = this.dp2px(y);
            float width_px = this.dp2px(maxWidth);
            StaticLayout staticLayout = new StaticLayout((CharSequence)text, this.getTextPaint(), (int)width_px, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            canvas.save();
            canvas.translate(x_px, y_px);
            staticLayout.draw(canvas);
            canvas.restore();
        });
        this.invalidate();
    }

    public void arc(Object x, Object y, Object radius, Object startAngle, Object endAngle, Object anticlockwise) {
        this.actions.add(canvas -> {
            float x_px = this.dp2px(x);
            float y_px = this.dp2px(y);
            float radius_px = this.dp2px(radius);
            boolean anticlockwiseBool = Boolean.parseBoolean(anticlockwise.toString());
            float startAngle_px = this.piToAngle(startAngle);
            float endAngle_px = this.piToAngle(endAngle);
            float sweepAngle = this.getSweepAngle(startAngle_px, endAngle_px, anticlockwiseBool);
            RectF rectF = new RectF(x_px - radius_px, y_px - radius_px, x_px + radius_px, y_px + radius_px);
            canvas.drawArc(rectF, startAngle_px, sweepAngle, false, this.getLinePaint());
        });
    }

    private float getSweepAngle(float startAngle, float endAngle, boolean anticlockwiseBool) {
        if (startAngle == endAngle) {
            return 0.0f;
        }
        if (anticlockwiseBool) {
            if (endAngle > startAngle) {
                return endAngle - (startAngle + 360.0f);
            }
            return -Math.abs(startAngle - endAngle);
        }
        if (endAngle > startAngle) {
            return endAngle - startAngle;
        }
        return 360.0f - Math.abs(endAngle - startAngle);
    }

    private float piToAngle(Object pi) {
        double p = Double.parseDouble(pi.toString());
        double rate = p / Math.PI;
        return (float)(rate * 180.0);
    }

    public void drawLine(Object startX, Object startY, Object stopX, Object stopY) {
        Log.i((String)TAG, (String)"drawLine do");
        this.actions.add(canvas -> {
            float x_start_px = this.dp2px(startX);
            float y_start_px = this.dp2px(startY);
            float x_stop_px = this.dp2px(stopX);
            float y_stop_px = this.dp2px(stopY);
            Log.i((String)TAG, (String)"drawLine Action");
            canvas.drawLine(x_start_px, y_start_px, x_stop_px, y_stop_px, this.getLinePaint());
        });
        this.invalidate();
    }

    public void drawLines(Object[] points) {
        this.actions.add(canvas -> {
            float[] points_px = new float[points.length];
            for (int i = 0; i < points.length; ++i) {
                points_px[i] = this.dp2px(points[i]);
            }
            Log.i((String)TAG, (String)"drawLines Action");
            canvas.drawLines(points_px, this.getLinePaint());
        });
        this.invalidate();
    }

    public void drawPath(CanvasPath path) {
        this.actions.add(canvas -> canvas.drawPath(path.getPath(), this.getLinePaint()));
        this.invalidate();
    }

    public void strokeEllipse(Object left, Object top, Object right, Object bottom) {
        this.actions.add(canvas -> {
            float left_px = this.dp2px(left);
            float top_px = this.dp2px(top);
            float right_px = this.dp2px(right);
            float bottom_px = this.dp2px(bottom);
            RectF rectF = new RectF(left_px, top_px, right_px, bottom_px);
            canvas.drawOval(rectF, this.getLinePaint());
        });
        this.invalidate();
    }

    public void fillEllipse(Object left, Object top, Object right, Object bottom) {
        this.actions.add(canvas -> {
            float left_px = this.dp2px(left);
            float top_px = this.dp2px(top);
            float right_px = this.dp2px(right);
            float bottom_px = this.dp2px(bottom);
            RectF rectF = new RectF(left_px, top_px, right_px, bottom_px);
            canvas.drawOval(rectF, this.getFillPaint());
        });
        this.invalidate();
    }

    public void lineWidth(float w) {
        this.actions.add(canvas -> {
            float width_px = this.dp2px(Float.valueOf(w));
            this.canvasContext.lineWidth(width_px);
        });
    }

    public void lineCap(int cap) {
        this.actions.add(canvas -> this.canvasContext.lineCap(cap));
    }

    public void lineColor(String color) {
        this.actions.add(canvas -> this.canvasContext.lineColor(color));
    }

    public void lineJoin(int join) {
        this.actions.add(canvas -> this.canvasContext.lineJoin(join));
    }

    public void fillColor(String color) {
        this.actions.add(canvas -> this.canvasContext.fillColor(color));
    }

    public void textColor(String color) {
        this.actions.add(canvas -> this.canvasContext.textColor(color));
    }

    private static interface CanvasAction {
        public void draw(Canvas var1);
    }
}

