/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.canvas;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.component.canvas.CanvasContext;
import com.didi.hummer.component.canvas.CanvasDrawHelperView;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.utility.YogaResUtils;
import com.didi.hummer.utils.JsSourceUtil;

@Component(value="CanvasView")
public class CanvasView
extends HMBase<CanvasDrawHelperView> {
    private HummerContext context;

    public CanvasView(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
        this.context = context;
    }

    protected CanvasDrawHelperView createViewInstance(Context context) {
        return new CanvasDrawHelperView(context);
    }

    @JsMethod(value="getCanvasContext")
    public CanvasContext getCanvasContext() {
        return ((CanvasDrawHelperView)this.getView()).getCanvasContext();
    }

    @JsMethod(value="drawImage")
    public void drawImage(Object bitmap, Object x, Object y, Object dWidth, Object dHeight) {
        if (bitmap instanceof Bitmap) {
            ((CanvasDrawHelperView)this.getView()).drawImage((Bitmap)bitmap, x, y, dWidth, dHeight);
        } else if (bitmap instanceof String) {
            String url = (String)bitmap;
            if (CanvasView.isRemoteImage(url)) {
                if (!TextUtils.isEmpty((CharSequence)url) && url.startsWith("//")) {
                    url = "https:" + url;
                }
                this.loadImageWithGlide(url, x, y, dWidth, dHeight);
            } else if (CanvasView.isLocalAbsoluteImage((String)bitmap)) {
                this.loadImageWithGlide((String)bitmap, x, y, dWidth, dHeight);
            } else if (CanvasView.isLocalRelativeImage((String)bitmap)) {
                String imageSrc = (String)bitmap;
                int jsSourceType = JsSourceUtil.getJsSourceType((String)this.context.getJsSourcePath());
                imageSrc = JsSourceUtil.getRealResourcePath((String)imageSrc, (String)this.context.getJsSourcePath());
                switch (jsSourceType) {
                    case 1: {
                        imageSrc = "file:///android_asset/" + imageSrc;
                        this.loadImageWithGlide(imageSrc, x, y, dWidth, dHeight);
                        break;
                    }
                    case 2: {
                        this.loadImageWithGlide(imageSrc, x, y, dWidth, dHeight);
                        break;
                    }
                }
            } else {
                int imageId = YogaResUtils.getResourceId((String)((String)bitmap), (String)"drawable", null);
                Bitmap bmp = BitmapFactory.decodeResource((Resources)((CanvasDrawHelperView)this.getView()).getContext().getResources(), (int)imageId);
                ((CanvasDrawHelperView)this.getView()).drawImage(bmp, x, y, dWidth, dHeight);
            }
        }
    }

    private void loadImageWithGlide(String url, final Object x, final Object y, final Object dWidth, final Object dHeight) {
        Glide.with((Context)this.getContext()).asBitmap().load(url).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(@NonNull Bitmap bmp, @Nullable Transition<? super Bitmap> transition) {
                ((CanvasDrawHelperView)CanvasView.this.getView()).drawImage(bmp, x, y, dWidth, dHeight);
            }
        });
    }

    @JsMethod(value="fillRect")
    public void fillRect(Object x, Object y, Object width, Object height) {
        ((CanvasDrawHelperView)this.getView()).fillRect(x, y, width, height);
    }

    @JsMethod(value="strokeRect")
    public void strokeRect(Object x, Object y, Object width, Object height) {
        ((CanvasDrawHelperView)this.getView()).strokeRect(x, y, width, height);
    }

    @JsMethod(value="fillCircle")
    public void fillCircle(Object x, Object y, Object radius) {
        ((CanvasDrawHelperView)this.getView()).fillCircle(x, y, radius);
    }

    @JsMethod(value="strokeCircle")
    public void strokeCircle(Object x, Object y, Object radius) {
        ((CanvasDrawHelperView)this.getView()).strokeCircle(x, y, radius);
    }

    @JsMethod(value="fontSize")
    public void fontSize(float size) {
        ((CanvasDrawHelperView)this.getView()).fontSize(size);
    }

    @JsMethod(value="fillText")
    public void fillText(String text, Object x, Object y, Object maxWidth) {
        ((CanvasDrawHelperView)this.getView()).fillText(text, x, y, maxWidth);
    }

    @JsMethod(value="arc")
    public void arc(Object x, Object y, Object radius, Object startAngle, Object endAngle, Object clockwise) {
        ((CanvasDrawHelperView)this.getView()).arc(x, y, radius, startAngle, endAngle, clockwise);
    }

    @JsMethod(value="drawLine")
    public void drawLine(Object startX, Object startY, Object stopX, Object stopY) {
        ((CanvasDrawHelperView)this.getView()).drawLine(startX, startY, stopX, stopY);
    }

    @JsMethod(value="drawLines")
    public void drawLines(Object[] points) {
        ((CanvasDrawHelperView)this.getView()).drawLines(points);
    }

    @JsMethod(value="strokeEllipse")
    public void ellipse(Object left, Object top, Object right, Object bottom) {
        ((CanvasDrawHelperView)this.getView()).strokeEllipse(left, top, right, bottom);
    }

    @JsMethod(value="fillEllipse")
    public void fillEllipse(Object left, Object top, Object right, Object bottom) {
        ((CanvasDrawHelperView)this.getView()).fillEllipse(left, top, right, bottom);
    }

    @JsMethod(value="lineWidth")
    public void lineWidth(float w) {
        ((CanvasDrawHelperView)this.getView()).lineWidth(w);
    }

    @JsMethod(value="lineColor")
    public void lineColor(String color) {
        ((CanvasDrawHelperView)this.getView()).lineColor(color);
    }

    @JsMethod(value="lineJoin")
    public void lineJoin(int join) {
        ((CanvasDrawHelperView)this.getView()).lineJoin(join);
    }

    @JsMethod(value="fillColor")
    public void fillColor(String color) {
        ((CanvasDrawHelperView)this.getView()).getCanvasContext().getLinePaint().setStyle(Paint.Style.FILL);
        ((CanvasDrawHelperView)this.getView()).fillColor(color);
    }

    @JsMethod(value="textColor")
    public void textColor(String color) {
        ((CanvasDrawHelperView)this.getView()).textColor(color);
    }

    @JsMethod(value="lineCap")
    public void lineCap(int cap) {
        ((CanvasDrawHelperView)this.getView()).lineCap(cap);
    }

    private static boolean isRemoteImage(String imageSrc) {
        return imageSrc != null && (imageSrc.startsWith("//") || imageSrc.toLowerCase().startsWith("http"));
    }

    private static boolean isLocalAbsoluteImage(String imageSrc) {
        return imageSrc != null && imageSrc.startsWith("/");
    }

    private static boolean isLocalRelativeImage(String imageSrc) {
        return imageSrc != null && imageSrc.startsWith("./");
    }
}

