/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.component.R;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerLayout;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaJustify;

@Component(value="Dialog")
public class Dialog {
    private Context context;
    private AlertDialog dialog;
    private HummerLayout customContainer;
    private HMBase customView;
    @JsProperty(value="cancelable")
    public boolean cancelable = true;
    @JsProperty(value="lowLayer")
    public boolean lowLayer = false;

    public Dialog(Context context) {
        this.context = context;
    }

    private void setDialogLayer(AlertDialog dialog, boolean isLowLayer) {
        if (isLowLayer && dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setType(1);
        }
    }

    @JsMethod(value="alert")
    public void alert(String msg, String btnText, JSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)btnText)) {
            btnText = this.context.getString(17039370);
        }
        this.dialog = new AlertDialog.Builder(this.context).setCancelable(this.cancelable).setMessage((CharSequence)msg).setPositiveButton((CharSequence)btnText, (dialog, which) -> {
            if (callback != null) {
                callback.call(new Object[0]);
            }
        }).create();
        this.setDialogLayer(this.dialog, this.lowLayer);
        this.dialog.show();
        this.dialog.getButton(-1).setTextColor(-16777216);
    }

    @JsMethod(value="confirm")
    public void confirm(String title, String msg, String okBtnText, String cancelBtnText, JSCallback okCallback, JSCallback cancelCallback) {
        if (TextUtils.isEmpty((CharSequence)okBtnText)) {
            okBtnText = this.context.getString(17039370);
        }
        if (TextUtils.isEmpty((CharSequence)cancelBtnText)) {
            cancelBtnText = this.context.getString(0x1040000);
        }
        this.dialog = new AlertDialog.Builder(this.context).setCancelable(this.cancelable).setTitle((CharSequence)title).setMessage((CharSequence)msg).setPositiveButton((CharSequence)okBtnText, (dialog, which) -> {
            if (okCallback != null) {
                okCallback.call(new Object[0]);
            }
        }).setNegativeButton((CharSequence)cancelBtnText, (dialog, which) -> {
            if (cancelCallback != null) {
                cancelCallback.call(new Object[0]);
            }
        }).create();
        this.setDialogLayer(this.dialog, this.lowLayer);
        this.dialog.show();
        this.dialog.getButton(-1).setTextColor(-16777216);
        this.dialog.getButton(-2).setTextColor(-7829368);
    }

    @JsMethod(value="loading")
    public void loading(String msg) {
        View view = View.inflate((Context)this.context, (int)R.layout.loading_dialog, null);
        TextView tVMsg = (TextView)view.findViewById(R.id.tv_msg);
        tVMsg.setText((CharSequence)msg);
        this.dialog = new AlertDialog.Builder(this.context, R.style.TransparentDialog).setCancelable(this.cancelable).setView(view).create();
        this.setDialogLayer(this.dialog, this.lowLayer);
        this.dialog.show();
    }

    @JsMethod(value="custom")
    public void custom(HMBase baseView) {
        baseView.getJSValue().protect();
        this.customView = baseView;
        if (this.customContainer == null) {
            this.customContainer = new HummerLayout(this.context);
            this.customContainer.getYogaNode().setJustifyContent(YogaJustify.CENTER);
            this.customContainer.getYogaNode().setAlignItems(YogaAlign.CENTER);
        } else {
            this.customContainer.removeAllViews();
        }
        this.customContainer.addView(baseView.getView());
        if (this.dialog == null) {
            this.dialog = new AlertDialog.Builder(this.context, R.style.TransparentDialog).setCancelable(this.cancelable).setView((View)this.customContainer).create();
            this.setDialogLayer(this.dialog, this.lowLayer);
        }
        this.dialog.show();
        if (this.dialog.getWindow() != null) {
            WindowManager.LayoutParams lp = this.dialog.getWindow().getAttributes();
            lp.width = -1;
            lp.height = -2;
            this.dialog.getWindow().setAttributes(lp);
        }
    }

    @JsMethod(value="dismiss")
    public void dismiss() {
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
        if (this.customView != null) {
            this.customView.getJSValue().unprotect();
            this.customView = null;
        }
    }
}

