/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.imageview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.ImageView;
import com.didi.hummer.adapter.imageloader.ImageSizeCallback;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsAttribute;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.component.imageview.ImageRenderUtil;
import com.didi.hummer.component.imageview.RoundedImageView;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.core.util.HMGsonUtil;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.facebook.yoga.YogaUnit;
import java.io.Serializable;
import java.util.Map;

@Component(value="Image")
public class Image
extends HMBase<RoundedImageView> {
    @Deprecated
    @JsProperty(value="src")
    private String src;
    @Deprecated
    @JsProperty(value="gifSrc")
    private String gifSrc;
    @Deprecated
    @JsProperty(value="gifRepeatCount")
    private int gifRepeatCount;

    public Image(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
    }

    protected RoundedImageView createViewInstance(Context context) {
        return new RoundedImageView(context);
    }

    public void onCreate() {
        super.onCreate();
        ((RoundedImageView)this.getView()).setScaleType(ImageView.ScaleType.FIT_XY);
        ((RoundedImageView)this.getView()).setFocusable(true);
    }

    private void requestLayout() {
        this.getYogaNode().dirty();
        ((RoundedImageView)this.getView()).requestLayout();
    }

    private void adjustWidthAndHeight(int imgWidth, int imgHeight) {
        if (this.getYogaNode().getWidth().unit == YogaUnit.AUTO && this.getYogaNode().getHeight().unit == YogaUnit.AUTO) {
            this.setWidthAndHeight(imgWidth, imgHeight);
        } else if (this.getYogaNode().getWidth().unit != YogaUnit.AUTO && this.getYogaNode().getHeight().unit == YogaUnit.AUTO) {
            if (this.getYogaNode().getWidth().unit == YogaUnit.PERCENT) {
                ((RoundedImageView)this.getView()).post(() -> {
                    float width = ((RoundedImageView)this.getView()).getWidth();
                    float height = width / (float)imgWidth * (float)imgHeight;
                    this.setWidthAndHeight(width, height);
                });
            } else {
                float width = this.getYogaNode().getWidth().value;
                float height = width / (float)imgWidth * (float)imgHeight;
                this.setWidthAndHeight(width, height);
            }
        } else if (this.getYogaNode().getWidth().unit == YogaUnit.AUTO && this.getYogaNode().getHeight().unit != YogaUnit.AUTO) {
            if (this.getYogaNode().getHeight().unit == YogaUnit.PERCENT) {
                ((RoundedImageView)this.getView()).post(() -> {
                    float height = ((RoundedImageView)this.getView()).getHeight();
                    float width = height / (float)imgHeight * (float)imgWidth;
                    this.setWidthAndHeight(width, height);
                });
            } else {
                float height = this.getYogaNode().getHeight().value;
                float width = height / (float)imgHeight * (float)imgWidth;
                this.setWidthAndHeight(width, height);
            }
        }
    }

    private void setWidthAndHeight(float width, float height) {
        this.getYogaNode().setWidth(width);
        this.getYogaNode().setHeight(height);
        this.requestLayout();
    }

    @Deprecated
    public void setSrc(String src) {
        this.src = src;
        this.loadImage(src);
    }

    @Deprecated
    public void setGifSrc(String gifSrc) {
        this.gifSrc = gifSrc;
        this.loadGif(gifSrc, this.gifRepeatCount);
    }

    @Deprecated
    public void setGifRepeatCount(int gifRepeatCount) {
        this.gifRepeatCount = gifRepeatCount;
    }

    @JsAttribute(value={"resize"})
    public void setContentMode(String resize) {
        switch (resize) {
            case "origin": {
                ((RoundedImageView)this.getView()).setScaleType(ImageView.ScaleType.CENTER);
                break;
            }
            case "contain": {
                ((RoundedImageView)this.getView()).setScaleType(ImageView.ScaleType.FIT_CENTER);
                break;
            }
            case "cover": {
                ((RoundedImageView)this.getView()).setScaleType(ImageView.ScaleType.CENTER_CROP);
                break;
            }
            default: {
                ((RoundedImageView)this.getView()).setScaleType(ImageView.ScaleType.FIT_XY);
            }
        }
    }

    @JsMethod(value="load")
    public void load(Object src, @Nullable JSCallback completeCallback) {
        ImageStyle style2;
        if (src instanceof String) {
            this.loadImage((String)src, completeCallback);
        } else if (src instanceof Map && (style2 = (ImageStyle)HMGsonUtil.fromJson((String)HMGsonUtil.toJson((Object)src), ImageStyle.class)) != null) {
            if (!TextUtils.isEmpty((CharSequence)style2.gifSrc)) {
                this.loadGif(style2.gifSrc, style2.placeholder, style2.failedImage, style2.gifRepeatCount, completeCallback);
            } else if (!TextUtils.isEmpty((CharSequence)style2.src)) {
                this.loadImage(style2.src, style2.placeholder, style2.failedImage, completeCallback);
            }
        }
    }

    private void loadImage(String url) {
        this.loadImage(url, null, null, null);
    }

    private void loadImage(String url, JSCallback completeCallback) {
        this.loadImage(url, null, null, completeCallback);
    }

    private void loadImage(String url, String placeholder, String failedImage, JSCallback completeCallback) {
        ImageSizeCallback callback = null;
        if (this.getYogaNode().getWidth().unit == YogaUnit.AUTO || this.getYogaNode().getHeight().unit == YogaUnit.AUTO) {
            callback = this::adjustWidthAndHeight;
        }
        ImageRenderUtil.renderImage((HummerContext)this.getContext(), (ImageView)this.getView(), url, placeholder, failedImage, callback, completeCallback);
        this.getNode().setContent(url);
    }

    private void loadGif(String url, int repeatCount) {
        this.loadGif(url, null, null, repeatCount, null);
    }

    private void loadGif(String url, String placeholder, String failedImage, int repeatCount, JSCallback completeCallback) {
        ImageSizeCallback callback = null;
        if (this.getYogaNode().getWidth().unit == YogaUnit.AUTO || this.getYogaNode().getHeight().unit == YogaUnit.AUTO) {
            callback = this::adjustWidthAndHeight;
        }
        ImageRenderUtil.renderGif((HummerContext)this.getContext(), (ImageView)this.getView(), url, placeholder, failedImage, repeatCount, callback, completeCallback);
        this.getNode().setContent(url);
    }

    public void setBorderWidth(float width) {
        ((RoundedImageView)this.getView()).setBorderWidth(width);
    }

    public void setBorderColor(int color) {
        ((RoundedImageView)this.getView()).setBorderColor(color);
    }

    public void setBorderStyle(String style2) {
        ((RoundedImageView)this.getView()).setBorderStyle(style2);
    }

    public void setBorderRadius(Object radius) {
        super.setBorderRadius(radius);
        if (HummerStyleUtils.isPercentValue((Object)radius)) {
            ((RoundedImageView)this.getView()).setBorderRadiusPercent(HummerStyleUtils.toPercent((Object)radius) / 100.0f);
        } else if (radius instanceof Float) {
            ((RoundedImageView)this.getView()).setBorderRadius(((Float)radius).floatValue());
        }
    }

    public void setBorderTopLeftRadius(Object radius) {
        super.setBorderTopLeftRadius(radius);
        ((RoundedImageView)this.getView()).setCornerRadii(this.backgroundHelper.getBorderRadii());
    }

    public void setBorderTopRightRadius(Object radius) {
        super.setBorderTopRightRadius(radius);
        ((RoundedImageView)this.getView()).setCornerRadii(this.backgroundHelper.getBorderRadii());
    }

    public void setBorderBottomRightRadius(Object radius) {
        super.setBorderBottomRightRadius(radius);
        ((RoundedImageView)this.getView()).setCornerRadii(this.backgroundHelper.getBorderRadii());
    }

    public void setBorderBottomLeftRadius(Object radius) {
        super.setBorderBottomLeftRadius(radius);
        ((RoundedImageView)this.getView()).setCornerRadii(this.backgroundHelper.getBorderRadii());
    }

    public void resetStyle() {
        super.resetStyle();
        this.setContentMode("origin");
        this.setBorderWidth(0.0f);
        this.setBorderColor(0);
        this.setBorderRadius(0);
    }

    public boolean setStyle(String key, Object value) {
        switch (key) {
            case "resize": {
                this.setContentMode(String.valueOf(value));
                break;
            }
            case "borderWidth": {
                this.setBorderWidth(((Float)value).floatValue());
                break;
            }
            case "borderColor": {
                this.setBorderColor((Integer)value);
                break;
            }
            case "borderStyle": {
                this.setBorderStyle((String)value);
                break;
            }
            case "borderRadius": {
                this.setBorderRadius(value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private class ImageStyle
    implements Serializable {
        public String src;
        public String placeholder;
        public String failedImage;
        public String gifSrc;
        public int gifRepeatCount;

        private ImageStyle() {
        }
    }
}

