/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.imageview;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Base64;
import android.widget.ImageView;
import com.didi.hummer.adapter.HummerAdapter;
import com.didi.hummer.adapter.imageloader.IImageLoaderAdapter;
import com.didi.hummer.adapter.imageloader.ImageSizeCallback;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.render.utility.YogaDrawableUtil;
import com.didi.hummer.render.utility.YogaResUtils;
import com.didi.hummer.utils.JsSourceUtil;

public class ImageRenderUtil {
    public static void renderImage(HummerContext context, ImageView imageView, String imageSrc, String placeholder, String failedImage) {
        ImageRenderUtil.renderImage(context, imageView, imageSrc, placeholder, failedImage, false, 0, null);
    }

    public static void renderImage(HummerContext context, ImageView imageView, String imageSrc, String placeholder, String failedImage, ImageSizeCallback callback, JSCallback completeCallback) {
        ImageRenderUtil.renderImage(context, imageView, imageSrc, placeholder, failedImage, false, 0, completeCallback);
        if (callback != null) {
            ImageRenderUtil.getImageLoader(context).getImageSize(imageSrc, callback);
        }
    }

    public static void renderGif(HummerContext context, ImageView imageView, String imageSrc, String placeholder, String failedImage, int repeatCount) {
        ImageRenderUtil.renderImage(context, imageView, imageSrc, placeholder, failedImage, true, repeatCount, null);
    }

    public static void renderGif(HummerContext context, ImageView imageView, String imageSrc, String placeholder, String failedImage, int repeatCount, ImageSizeCallback callback, JSCallback completeCallback) {
        ImageRenderUtil.renderImage(context, imageView, imageSrc, placeholder, failedImage, true, repeatCount, completeCallback);
        if (callback != null) {
            ImageRenderUtil.getImageLoader(context).getImageSize(imageSrc, callback);
        }
    }

    private static void renderImage(HummerContext context, ImageView imageView, String imageSrc, String placeholder, String failedImage, boolean isGif, int repeatCount, JSCallback completeCallback) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)imageSrc)) {
            return;
        }
        if (ImageRenderUtil.isRemoteImage(imageSrc)) {
            if (isGif) {
                ImageRenderUtil.renderRemoteGif(context, imageView, imageSrc, placeholder, failedImage, repeatCount, completeCallback);
            } else {
                ImageRenderUtil.renderRemoteImage(context, imageView, imageSrc, placeholder, failedImage, completeCallback);
            }
        } else if (ImageRenderUtil.isLocalAbsoluteImage(imageSrc)) {
            if (isGif) {
                ImageRenderUtil.renderLocalGif(context, imageView, imageSrc, repeatCount, completeCallback);
            } else {
                ImageRenderUtil.renderLocalImage(context, imageView, imageSrc, completeCallback);
            }
        } else if (ImageRenderUtil.isLocalRelativeImage(imageSrc)) {
            int jsSourceType = JsSourceUtil.getJsSourceType((String)context.getJsSourcePath());
            imageSrc = JsSourceUtil.getRealResourcePath((String)imageSrc, (String)context.getJsSourcePath());
            switch (jsSourceType) {
                case 1: {
                    if (isGif) {
                        ImageRenderUtil.renderAssetsGif(context, imageView, imageSrc, repeatCount, completeCallback);
                        break;
                    }
                    ImageRenderUtil.renderAssetsImage(context, imageView, imageSrc, completeCallback);
                    break;
                }
                case 2: {
                    if (isGif) {
                        ImageRenderUtil.renderLocalGif(context, imageView, imageSrc, repeatCount, completeCallback);
                        break;
                    }
                    ImageRenderUtil.renderLocalImage(context, imageView, imageSrc, completeCallback);
                    break;
                }
                case 3: {
                    if (isGif) {
                        ImageRenderUtil.renderRemoteGif(context, imageView, imageSrc, placeholder, failedImage, repeatCount, completeCallback);
                        break;
                    }
                    ImageRenderUtil.renderRemoteImage(context, imageView, imageSrc, placeholder, failedImage, completeCallback);
                    break;
                }
            }
        } else if (ImageRenderUtil.isBase64Image(imageSrc)) {
            ImageRenderUtil.renderBase64Image(imageView, imageSrc, completeCallback);
        } else if (isGif) {
            ImageRenderUtil.renderResourceGif(context, imageView, imageSrc, repeatCount, completeCallback);
        } else {
            ImageRenderUtil.renderResourceImage(context, imageView, imageSrc, completeCallback);
        }
    }

    private static boolean isRemoteImage(String imageSrc) {
        return imageSrc != null && (imageSrc.startsWith("//") || imageSrc.toLowerCase().startsWith("http"));
    }

    private static boolean isLocalAbsoluteImage(String imageSrc) {
        return imageSrc != null && imageSrc.startsWith("/");
    }

    private static boolean isLocalRelativeImage(String imageSrc) {
        return imageSrc != null && imageSrc.startsWith("./");
    }

    private static boolean isBase64Image(String imageSrc) {
        return imageSrc != null && (imageSrc.contains("base64") || imageSrc.contains("BASE64"));
    }

    private static String fitRemoteUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && url.startsWith("//")) {
            url = "https:" + url;
        }
        return url;
    }

    private static void renderRemoteImage(HummerContext context, ImageView imageView, String imageSrc, String placeholder, String failedImage, JSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)imageSrc)) {
            return;
        }
        YogaDrawableUtil.loadDrawable((HummerContext)context, (String)placeholder, drawable1 -> YogaDrawableUtil.loadDrawable((HummerContext)context, (String)failedImage, drawable2 -> ImageRenderUtil.getImageLoader(context).setImage(ImageRenderUtil.fitRemoteUrl(imageSrc), drawable1, drawable2, imageView, callback)));
    }

    private static void renderLocalImage(HummerContext context, ImageView imageView, String imageSrc, JSCallback completeCallback) {
        ImageRenderUtil.getImageLoader(context).setImage(imageSrc, imageView, completeCallback);
    }

    private static void renderAssetsImage(HummerContext context, ImageView imageView, String imageSrc, JSCallback completeCallback) {
        imageSrc = "file:///android_asset/" + imageSrc;
        ImageRenderUtil.getImageLoader(context).setImage(imageSrc, imageView, completeCallback);
    }

    private static void renderBase64Image(ImageView imageView, String imageSrc, JSCallback completeCallback) {
        block3: {
            try {
                byte[] bitmapArray = Base64.decode((String)imageSrc.split(",")[1], (int)0);
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bitmapArray, (int)0, (int)bitmapArray.length);
                imageView.setImageBitmap(bitmap);
                if (completeCallback != null) {
                    completeCallback.call(new Object[]{2, true});
                }
            }
            catch (Exception e) {
                if (completeCallback == null) break block3;
                completeCallback.call(new Object[]{0, false});
            }
        }
    }

    private static void renderResourceImage(HummerContext context, ImageView imageView, String imageSrc, JSCallback completeCallback) {
        int imageId = YogaResUtils.getResourceId((String)imageSrc, (String)"drawable", null);
        ImageRenderUtil.getImageLoader(context).setImage(imageId, imageView, completeCallback);
    }

    private static void renderRemoteGif(HummerContext context, ImageView imageView, String imageSrc, String placeholder, String failedImage, int repeatCount, JSCallback completeCallback) {
        if (TextUtils.isEmpty((CharSequence)imageSrc)) {
            return;
        }
        ImageRenderUtil.getImageLoader(context).setGif(ImageRenderUtil.fitRemoteUrl(imageSrc), repeatCount, imageView, completeCallback);
    }

    private static void renderLocalGif(HummerContext context, ImageView imageView, String imageSrc, int repeatCount, JSCallback completeCallback) {
        ImageRenderUtil.getImageLoader(context).setGif(imageSrc, repeatCount, imageView, completeCallback);
    }

    private static void renderAssetsGif(HummerContext context, ImageView imageView, String imageSrc, int repeatCount, JSCallback completeCallback) {
        imageSrc = "file:///android_asset/" + imageSrc;
        ImageRenderUtil.getImageLoader(context).setGif(imageSrc, repeatCount, imageView, completeCallback);
    }

    private static void renderResourceGif(HummerContext context, ImageView imageView, String imageSrc, int repeatCount, JSCallback completeCallback) {
        int imageId = YogaResUtils.getResourceId((String)imageSrc, (String)"drawable", null);
        ImageRenderUtil.getImageLoader(context).setGif(imageId, repeatCount, imageView, completeCallback);
    }

    private static IImageLoaderAdapter getImageLoader(HummerContext context) {
        return HummerAdapter.getImageLoaderAdapter((String)context.getNamespace());
    }
}

