/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.imageview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.text.TextUtils;
import android.util.AttributeSet;

public class RoundedImageView
extends AppCompatImageView {
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLORDRAWABLE_DIMENSION = 1;
    private final RectF mDrawableRect = new RectF();
    private final RectF mBorderRect = new RectF();
    private final Matrix mShaderMatrix = new Matrix();
    private final Paint mBitmapPaint = new Paint();
    private final Paint mBorderPaint = new Paint();
    private final Path roundPath = new Path();
    private int mBorderColor = 0;
    private float mBorderWidth = 0.0f;
    @BorderStyle
    private int mBorderStyle = 0;
    private Bitmap mBitmap;
    private BitmapShader mBitmapShader;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private float mCircleRadius;
    private float mRoundRadius;
    private RectF mClipBounds = new RectF();
    private Path mViewPath = new Path();
    private float[] mCornerRadii;
    private float mRoundRadiusPercent;
    private boolean mReady = true;
    private boolean mSetupPending;

    public RoundedImageView(Context context) {
        this(context, null);
    }

    public RoundedImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.mSetupPending) {
            this.setup();
            this.mSetupPending = false;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() == null) {
            return;
        }
        if (this.mCornerRadii != null) {
            this.mClipBounds.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            this.mViewPath.reset();
            this.mViewPath.addRoundRect(this.mClipBounds, this.mCornerRadii, Path.Direction.CW);
            canvas.clipPath(this.mViewPath);
        }
        if (this.mRoundRadius <= 0.0f && this.mRoundRadiusPercent > 0.0f) {
            this.mRoundRadius = (float)Math.min(this.getWidth(), this.getHeight()) * this.mRoundRadiusPercent;
        }
        if (this.mRoundRadius <= 0.0f) {
            super.onDraw(canvas);
        } else if (this.mRoundRadius >= Math.min(this.mDrawableRect.height() / 2.0f, this.mDrawableRect.width() / 2.0f)) {
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, this.mCircleRadius, this.mBitmapPaint);
        } else {
            this.roundPath.reset();
            this.roundPath.addRoundRect(this.mDrawableRect, this.mRoundRadius, this.mRoundRadius, Path.Direction.CW);
            canvas.drawPath(this.roundPath, this.mBitmapPaint);
        }
        if (this.mBorderWidth > 0.0f) {
            if (this.mRoundRadius <= 0.0f) {
                canvas.drawRect(this.mBorderRect, this.mBorderPaint);
            } else if (this.mRoundRadius >= Math.min(this.mDrawableRect.height() / 2.0f, this.mDrawableRect.width() / 2.0f)) {
                float radius = this.mCircleRadius;
                canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, radius, this.mBorderPaint);
            } else {
                this.roundPath.reset();
                this.roundPath.addRoundRect(this.mBorderRect, this.mRoundRadius, this.mRoundRadius, Path.Direction.CW);
                canvas.drawPath(this.roundPath, this.mBorderPaint);
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setup();
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(int borderColor) {
        if (borderColor == this.mBorderColor) {
            return;
        }
        this.mBorderColor = borderColor;
        this.mBorderPaint.setColor(this.mBorderColor);
        this.invalidate();
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        if ((double)Math.abs(this.mBorderWidth - borderWidth) < 1.0E-8) {
            return;
        }
        this.mBorderWidth = borderWidth;
        this.setup();
    }

    public void setBorderStyle(String style2) {
        int borderStyle = RoundedImageView.getStyle(style2);
        if (this.mBorderStyle == borderStyle) {
            return;
        }
        this.mBorderStyle = borderStyle;
        this.setup();
    }

    protected void setBorderRadius(float roundRadius) {
        if ((double)Math.abs(this.mRoundRadius - roundRadius) < 1.0E-8) {
            return;
        }
        this.mRoundRadius = roundRadius;
        this.mRoundRadiusPercent = 0.0f;
        this.setup();
    }

    protected void setBorderRadiusPercent(float roundRadiusPercent) {
        if ((double)Math.abs(this.mRoundRadiusPercent - roundRadiusPercent) < 1.0E-8) {
            return;
        }
        this.mRoundRadiusPercent = roundRadiusPercent;
        this.mRoundRadius = 0.0f;
        this.setup();
    }

    public void setCornerRadii(float[] radii) {
        this.mCornerRadii = radii;
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.mBitmap = bm;
        this.setup();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.mBitmap = this.getBitmapFromDrawable(drawable);
        this.setup();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.mBitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.setup();
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap = drawable instanceof ColorDrawable ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            return null;
        }
    }

    private void setup() {
        if (!this.mReady) {
            this.mSetupPending = true;
            return;
        }
        if (this.mBitmap == null) {
            return;
        }
        this.mBitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        this.mBorderPaint.setPathEffect(this.makePathEffect(this.mBorderStyle, this.mBorderWidth));
        this.mBitmapHeight = this.mBitmap.getHeight();
        this.mBitmapWidth = this.mBitmap.getWidth();
        this.mBorderRect.set(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f, (float)this.getWidth() - this.mBorderWidth / 2.0f, (float)this.getHeight() - this.mBorderWidth / 2.0f);
        this.mDrawableRect.set(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f, (float)this.getWidth() - this.mBorderWidth / 2.0f, (float)this.getHeight() - this.mBorderWidth / 2.0f);
        this.mCircleRadius = Math.min(this.mDrawableRect.height() / 2.0f, this.mDrawableRect.width() / 2.0f);
        this.updateShaderMatrix();
        this.invalidate();
    }

    private void updateShaderMatrix() {
        float scale;
        float dx = 0.0f;
        float dy = 0.0f;
        this.mShaderMatrix.set(null);
        if ((float)this.mBitmapWidth * this.mDrawableRect.height() > this.mDrawableRect.width() * (float)this.mBitmapHeight) {
            scale = this.mDrawableRect.height() / (float)this.mBitmapHeight;
            dx = (this.mDrawableRect.width() - (float)this.mBitmapWidth * scale) * 0.5f;
        } else {
            scale = this.mDrawableRect.width() / (float)this.mBitmapWidth;
            dy = (this.mDrawableRect.height() - (float)this.mBitmapHeight * scale) * 0.5f;
        }
        this.mShaderMatrix.setScale(scale, scale);
        this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)) + this.mBorderWidth, (float)((int)(dy + 0.5f)) + this.mBorderWidth);
        this.mBitmapShader.setLocalMatrix(this.mShaderMatrix);
    }

    @BorderStyle
    public static int getStyle(String styleName) {
        if (TextUtils.isEmpty((CharSequence)styleName)) {
            return 1;
        }
        switch (styleName.toUpperCase()) {
            case "SOLID": {
                return 1;
            }
            case "DASHED": {
                return 2;
            }
            case "DOTTED": {
                return 3;
            }
        }
        return 0;
    }

    @Nullable
    private PathEffect makePathEffect(@BorderStyle int style2, float borderWidth) {
        switch (style2) {
            default: {
                return null;
            }
            case 2: {
                return new DashPathEffect(new float[]{borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f}, 0.0f);
            }
            case 3: 
        }
        return new DashPathEffect(new float[]{borderWidth, borderWidth, borderWidth, borderWidth}, 0.0f);
    }

    public static @interface BorderStyle {
        public static final int NONE = 0;
        public static final int SOLID = 1;
        public static final int DASHED = 2;
        public static final int DOTTED = 3;
    }
}

