/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.input;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import com.didi.hummer.component.input.KeyboardUtil;

public class FocusUtil {
    public static void requestFocus(View view) {
        if (view == null) {
            return;
        }
        view.post(() -> {
            view.requestFocus();
            KeyboardUtil.showKeyboard(view);
        });
    }

    public static void clearFocus(View view) {
        if (view == null) {
            return;
        }
        view.post(() -> {
            FocusUtil.focusParent(view);
            view.clearFocus();
            KeyboardUtil.hideKeyboard(view);
        });
    }

    public static void clearFocus(Context context) {
        InputMethodManager imm;
        Activity activity;
        if (context instanceof Activity && (activity = (Activity)context).getCurrentFocus() != null && activity.getCurrentFocus().getWindowToken() != null && (imm = (InputMethodManager)activity.getSystemService("input_method")) != null && imm.isActive()) {
            FocusUtil.clearFocus(activity.getCurrentFocus());
        }
    }

    private static void focusParent(View view) {
        if (view.getParent() instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view.getParent();
            if (Build.VERSION.SDK_INT >= 26) {
                parent.setDefaultFocusHighlightEnabled(false);
            }
            parent.setFocusable(true);
            parent.setFocusableInTouchMode(true);
            parent.requestFocus();
        }
    }
}

