/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.input;

import android.content.Context;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.didi.hummer.component.input.FocusUtil;
import com.didi.hummer.component.text.FontManager;
import com.didi.hummer.context.HummerContext;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class HMInputProperty {
    private final EditText mView;
    private static final InputFilter[] EMPTY_FILTERS = new InputFilter[0];
    private int defaultInputType;
    private boolean isSingleLine;

    public HMInputProperty(EditText editText, boolean singleLine) {
        this.isSingleLine = singleLine;
        this.mView = editText;
        this.mView.setPadding(0, 0, 0, 0);
        this.mView.setSingleLine(singleLine);
        this.mView.setTextSize(16.0f);
        if (!this.isSingleLine) {
            this.mView.setGravity(0x800003);
        }
        this.defaultInputType = editText.getInputType();
        if (this.defaultInputType == 0) {
            this.defaultInputType = 1;
        }
    }

    public void setText(String text) {
        this.mView.setText((CharSequence)text);
        if (this.mView.getText().length() > 0) {
            this.mView.setSelection(this.mView.getText().length());
        }
    }

    public String getText() {
        return this.mView.getText().toString();
    }

    public void setPlaceholder(String placeholder) {
        this.mView.setHint((CharSequence)placeholder);
    }

    public void setType(String type) {
        this.mView.setInputType(this.getInputType(type));
    }

    private int getInputType(String type) {
        int inputType;
        switch (type) {
            case "email": {
                inputType = this.defaultInputType | 0x20;
                break;
            }
            case "number": {
                inputType = this.defaultInputType | 2;
                break;
            }
            case "tel": {
                inputType = this.defaultInputType | 3;
                break;
            }
            case "password": {
                inputType = this.defaultInputType | 0x80;
                break;
            }
            default: {
                inputType = this.defaultInputType;
            }
        }
        return inputType;
    }

    public void setTextColor(int color) {
        this.mView.setTextColor(color);
    }

    public void setPlaceholderColor(int color) {
        this.mView.setHintTextColor(color);
    }

    public void setCursorColor(int cursorColor) {
        try {
            if (Build.VERSION.SDK_INT >= 29) {
                BlendModeColorFilter colorFilter = new BlendModeColorFilter(cursorColor, BlendMode.SRC_ATOP);
                this.mView.getTextCursorDrawable().mutate().setColorFilter((ColorFilter)colorFilter);
                return;
            }
            Field cursorDrawableResField = TextView.class.getDeclaredField("mCursorDrawableRes");
            cursorDrawableResField.setAccessible(true);
            int drawableResId = cursorDrawableResField.getInt(this.mView);
            if (drawableResId == 0) {
                return;
            }
            Drawable drawable = ContextCompat.getDrawable((Context)this.mView.getContext(), (int)drawableResId);
            drawable.setColorFilter(cursorColor, PorterDuff.Mode.SRC_ATOP);
            Field editorField = TextView.class.getDeclaredField("mEditor");
            editorField.setAccessible(true);
            Object editor = editorField.get(this.mView);
            Class<?> clazz = editor.getClass();
            if (Build.VERSION.SDK_INT >= 28) {
                Field drawableForCursorField = clazz.getDeclaredField("mDrawableForCursor");
                drawableForCursorField.setAccessible(true);
                drawableForCursorField.set(editor, drawable);
            } else {
                Field cursorDrawableField = clazz.getDeclaredField("mCursorDrawable");
                cursorDrawableField.setAccessible(true);
                Drawable[] drawables = new Drawable[]{drawable, drawable};
                cursorDrawableField.set(editor, drawables);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetCursorColor() {
        try {
            if (Build.VERSION.SDK_INT >= 29) {
                this.mView.getTextCursorDrawable().mutate().setColorFilter(null);
                return;
            }
            Field cursorDrawableResField = TextView.class.getDeclaredField("mCursorDrawableRes");
            cursorDrawableResField.setAccessible(true);
            int drawableResId = cursorDrawableResField.getInt(this.mView);
            if (drawableResId == 0) {
                return;
            }
            Drawable drawable = ContextCompat.getDrawable((Context)this.mView.getContext(), (int)drawableResId);
            Field editorField = TextView.class.getDeclaredField("mEditor");
            editorField.setAccessible(true);
            Object editor = editorField.get(this.mView);
            Class<?> clazz = editor.getClass();
            if (Build.VERSION.SDK_INT >= 28) {
                Field drawableForCursorField = clazz.getDeclaredField("mDrawableForCursor");
                drawableForCursorField.setAccessible(true);
                drawableForCursorField.set(editor, drawable);
            } else {
                Field cursorDrawableField = clazz.getDeclaredField("mCursorDrawable");
                cursorDrawableField.setAccessible(true);
                Drawable[] drawables = new Drawable[]{drawable, drawable};
                cursorDrawableField.set(editor, drawables);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTextAlign(String align) {
        this.mView.setGravity(this.getGravity(align));
    }

    private int getGravity(String align) {
        switch (align) {
            default: {
                return this.isSingleLine ? 8388627 : 0x800003;
            }
            case "right": {
                return this.isSingleLine ? 8388629 : 0x800005;
            }
            case "center": 
        }
        return this.isSingleLine ? 17 : 1;
    }

    public void setFontFamily(Context context, String fontFamily) {
        if (TextUtils.isEmpty((CharSequence)fontFamily)) {
            return;
        }
        String[] fontArray = fontFamily.split(",");
        if (fontArray.length == 0) {
            return;
        }
        int style2 = 0;
        if (this.mView.getTypeface() != null) {
            style2 = this.mView.getTypeface().getStyle();
        }
        for (String font : fontArray) {
            Typeface typeface = FontManager.getInstance().getTypeface((HummerContext)context, font.trim(), style2);
            if (typeface == null) continue;
            this.mView.setTypeface(typeface);
            break;
        }
    }

    public void setFontSize(float fontSize) {
        this.mView.setTextSize(0, fontSize);
    }

    public void setPlaceholderFontSize(float fontSize) {
        this.mView.setTextSize(0, fontSize);
    }

    public void setMaxLength(int maxLength) {
        InputFilter[] currentFilters = this.mView.getFilters();
        InputFilter[] newFilters = EMPTY_FILTERS;
        if (maxLength == 0) {
            if (currentFilters.length > 0) {
                LinkedList<InputFilter> list = new LinkedList<InputFilter>();
                for (int i = 0; i < currentFilters.length; ++i) {
                    if (currentFilters[i] instanceof InputFilter.LengthFilter) continue;
                    list.add(currentFilters[i]);
                }
                if (!list.isEmpty()) {
                    newFilters = list.toArray(new InputFilter[list.size()]);
                }
            }
        } else if (currentFilters.length > 0) {
            newFilters = currentFilters;
            boolean replaced = false;
            for (int i = 0; i < currentFilters.length; ++i) {
                if (!(currentFilters[i] instanceof InputFilter.LengthFilter)) continue;
                currentFilters[i] = new InputFilter.LengthFilter(maxLength);
                replaced = true;
            }
            if (!replaced) {
                newFilters = new InputFilter[currentFilters.length + 1];
                System.arraycopy(currentFilters, 0, newFilters, 0, currentFilters.length);
                currentFilters[currentFilters.length] = new InputFilter.LengthFilter(maxLength);
            }
        } else {
            newFilters = new InputFilter[]{new InputFilter.LengthFilter(maxLength)};
        }
        this.mView.setFilters(newFilters);
    }

    public void setReturnKeyType(String type) {
        this.mView.setImeOptions(this.getImeOption(type));
        InputMethodManager imm = (InputMethodManager)this.mView.getContext().getSystemService("input_method");
        if (imm != null && imm.isActive()) {
            imm.restartInput((View)this.mView);
        }
    }

    private int getImeOption(String type) {
        switch (type) {
            case "go": {
                return 2;
            }
            case "search": {
                return 3;
            }
            case "send": {
                return 4;
            }
            case "next": {
                return 5;
            }
        }
        return 6;
    }

    public void setFocused(boolean focused) {
        if (focused) {
            FocusUtil.requestFocus((View)this.mView);
        } else {
            FocusUtil.clearFocus((View)this.mView);
        }
    }
}

