/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.input;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsAttribute;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.component.input.HMInputProperty;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.event.base.Event;
import com.didi.hummer.render.event.view.InputEvent;
import com.didi.hummer.render.style.HummerNode;

@Component(value="Input")
public class Input
extends HMBase<EditText> {
    protected final HMInputProperty mProperty;
    private ColorStateList orgTextColors;
    private ColorStateList orgHintColors;
    private float orgTextSize;
    private Typeface orgTypeface;
    protected int maxLines = 0;
    private TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            int lines = ((EditText)Input.this.getView()).getLineCount();
            if (Input.this.maxLines > 0 && lines > Input.this.maxLines) {
                int cursorEnd;
                String str = s.toString();
                int cursorStart = ((EditText)Input.this.getView()).getSelectionStart();
                str = cursorStart == (cursorEnd = ((EditText)Input.this.getView()).getSelectionEnd()) && cursorStart < str.length() && cursorStart >= 1 ? str.substring(0, cursorStart - 1) + str.substring(cursorStart) : str.substring(0, s.length() - 1);
                ((EditText)Input.this.getView()).removeTextChangedListener((TextWatcher)this);
                ((EditText)Input.this.getView()).setText((CharSequence)str);
                ((EditText)Input.this.getView()).addTextChangedListener((TextWatcher)this);
                ((EditText)Input.this.getView()).setSelection(((EditText)Input.this.getView()).getText().length());
                return;
            }
            InputEvent inputEvent = new InputEvent();
            inputEvent.setType("input");
            inputEvent.setText(s.toString());
            inputEvent.setState(2);
            inputEvent.setTimestamp(System.currentTimeMillis());
            Input.this.mEventManager.dispatchEvent("input", (Event)inputEvent);
            Input.this.requestLayout();
        }
    };
    private View.OnFocusChangeListener mOnFocusChangeListener = (v, hasFocus) -> {
        if (hasFocus) {
            InputEvent inputEvent = new InputEvent();
            inputEvent.setType("input");
            inputEvent.setText(((EditText)this.getView()).getText().toString());
            inputEvent.setState(1);
            inputEvent.setTimestamp(System.currentTimeMillis());
            this.mEventManager.dispatchEvent("input", (Event)inputEvent);
        } else {
            InputEvent inputEvent = new InputEvent();
            inputEvent.setType("input");
            inputEvent.setText(((EditText)this.getView()).getText().toString());
            inputEvent.setState(3);
            inputEvent.setTimestamp(System.currentTimeMillis());
            this.mEventManager.dispatchEvent("input", (Event)inputEvent);
        }
    };
    private View.OnKeyListener mOnKeyListener = (v, keyCode, event) -> {
        if (keyCode == 67 && event.getAction() == 0 && this.getView() != null && TextUtils.isEmpty((CharSequence)((EditText)this.getView()).getText())) {
            InputEvent inputEvent = new InputEvent();
            inputEvent.setType("input");
            inputEvent.setText("");
            inputEvent.setState(2);
            inputEvent.setTimestamp(System.currentTimeMillis());
            this.mEventManager.dispatchEvent("input", (Event)inputEvent);
        }
        return false;
    };
    private TextView.OnEditorActionListener mOnEditorActionListener = (v, actionId, event) -> {
        boolean handled = false;
        if (actionId == 2 || actionId == 3 || actionId == 4 || actionId == 5 || actionId == 6) {
            switch (actionId) {
                case 5: {
                    handled = false;
                    break;
                }
                case 6: {
                    this.setFocused(false);
                    break;
                }
                default: {
                    handled = true;
                }
            }
            InputEvent inputEvent = new InputEvent();
            inputEvent.setType("input");
            inputEvent.setText(((EditText)this.getView()).getText().toString());
            inputEvent.setState(4);
            inputEvent.setTimestamp(System.currentTimeMillis());
            this.mEventManager.dispatchEvent("input", (Event)inputEvent);
        }
        return handled;
    };
    @JsProperty(value="text")
    private String text;
    @JsProperty(value="placeholder")
    private String placeholder;
    @JsProperty(value="focused")
    private boolean focused;

    public Input(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
        this.mProperty = new HMInputProperty((EditText)this.getView(), this.isSingleLine());
    }

    public void onCreate() {
        super.onCreate();
        this.orgTextColors = ((EditText)this.getView()).getTextColors();
        this.orgHintColors = ((EditText)this.getView()).getHintTextColors();
        this.orgTextSize = ((EditText)this.getView()).getTextSize();
        this.setFontFamily("DEFAULT_FONT_FAMILY");
        this.orgTypeface = ((EditText)this.getView()).getTypeface();
        ((EditText)this.getView()).setBackgroundColor(0);
        ((EditText)this.getView()).setImeOptions(6);
        ((EditText)this.getView()).addTextChangedListener(this.mTextWatcher);
        ((EditText)this.getView()).setOnFocusChangeListener(this.mOnFocusChangeListener);
        ((EditText)this.getView()).setOnEditorActionListener(this.mOnEditorActionListener);
        ((EditText)this.getView()).setOnKeyListener(this.mOnKeyListener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ((EditText)this.getView()).setFocusable(enabled);
        ((EditText)this.getView()).setFocusableInTouchMode(enabled);
    }

    public void onDestroy() {
        super.onDestroy();
        ((EditText)this.getView()).removeTextChangedListener(this.mTextWatcher);
        ((EditText)this.getView()).setOnKeyListener(null);
    }

    protected boolean isSingleLine() {
        return true;
    }

    protected EditText createViewInstance(Context context) {
        return new EditText(context);
    }

    private void requestLayout() {
        this.getYogaNode().dirty();
        ((EditText)this.getView()).requestLayout();
    }

    public void setText(String text) {
        this.mProperty.setText(text);
        this.requestLayout();
    }

    public String getText() {
        return this.mProperty.getText();
    }

    public void setPlaceholder(String placeholder) {
        this.mProperty.setPlaceholder(placeholder);
        this.requestLayout();
    }

    public void setFocused(boolean focused) {
        if (((EditText)this.getView()).isFocused() && focused) {
            return;
        }
        this.mProperty.setFocused(focused);
    }

    public boolean getFocused() {
        return ((EditText)this.getView()).isFocused();
    }

    @JsAttribute(value={"type"})
    public void setType(String type) {
        this.mProperty.setType(type);
    }

    @JsAttribute(value={"color"})
    public void setColor(int color) {
        this.mProperty.setTextColor(color);
    }

    @JsAttribute(value={"placeholderColor"})
    public void setPlaceholderColor(int color) {
        this.mProperty.setPlaceholderColor(color);
    }

    @JsAttribute(value={"cursorColor"})
    public void setCursorColor(int cursorColor) {
        this.mProperty.setCursorColor(cursorColor);
    }

    @JsAttribute(value={"textAlign"})
    public void setTextAlign(String align) {
        this.mProperty.setTextAlign(align);
    }

    @JsAttribute(value={"fontFamily"})
    public void setFontFamily(String fontFamily) {
        this.mProperty.setFontFamily(this.getContext(), fontFamily);
        this.requestLayout();
    }

    @JsAttribute(value={"fontSize"})
    public void setFontSize(float fontSize) {
        this.mProperty.setFontSize(fontSize);
        this.requestLayout();
    }

    @Deprecated
    @JsAttribute(value={"placeholderFontSize"})
    public void setPlaceholderFontSize(float fontSize) {
        this.mProperty.setPlaceholderFontSize(fontSize);
        this.requestLayout();
    }

    @JsAttribute(value={"maxLength"})
    public void setMaxLength(int length) {
        this.mProperty.setMaxLength(length);
    }

    @JsAttribute(value={"returnKeyType"})
    public void setReturnKeyType(String type) {
        this.mProperty.setReturnKeyType(type);
    }

    public HummerNode getNode() {
        HummerNode node = super.getNode();
        node.setContent(String.valueOf(((EditText)this.getView()).getText()));
        return node;
    }

    public void resetStyle() {
        super.resetStyle();
        ((EditText)this.getView()).setBackgroundColor(0);
        ((EditText)this.getView()).setTextColor(this.orgTextColors);
        ((EditText)this.getView()).setHintTextColor(this.orgHintColors);
        ((EditText)this.getView()).setTextSize(0, this.orgTextSize);
        ((EditText)this.getView()).setTypeface(this.orgTypeface);
        this.setType("default");
        this.setReturnKeyType("done");
        this.setTextAlign("left");
        this.mProperty.resetCursorColor();
    }

    public boolean setStyle(String key, Object value) {
        switch (key) {
            case "type": {
                this.setType(String.valueOf(value));
                break;
            }
            case "color": {
                this.setColor((Integer)value);
                break;
            }
            case "fontFamily": {
                this.setFontFamily(String.valueOf(value));
                break;
            }
            case "fontSize": {
                this.setFontSize(((Float)value).floatValue());
                break;
            }
            case "placeholderColor": {
                this.setPlaceholderColor((Integer)value);
                break;
            }
            case "placeholderFontSize": {
                this.setPlaceholderFontSize(((Float)value).floatValue());
                break;
            }
            case "textAlign": {
                this.setTextAlign(String.valueOf(value));
                break;
            }
            case "cursorColor": {
                this.setCursorColor((Integer)value);
                break;
            }
            case "maxLength": {
                this.setMaxLength((int)((Float)value).floatValue());
                break;
            }
            case "returnKeyType": {
                this.setReturnKeyType(String.valueOf(value));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

