/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.list;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.didi.hummer.component.list.ListUtil;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.pool.ObjectPool;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerNode;

public class HMListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private RecyclerView recyclerView;
    private int itemCount;
    private JSCallback typeCallback;
    private JSCallback createCallback;
    private JSCallback updateCallback;
    private Context mContext;
    private ObjectPool instanceManager;

    public HMListAdapter(Context context, ObjectPool instanceManager) {
        this.mContext = context;
        this.instanceManager = instanceManager;
    }

    public void destroy() {
        if (this.typeCallback != null) {
            this.typeCallback.release();
        }
        if (this.createCallback != null) {
            this.createCallback.release();
        }
        if (this.updateCallback != null) {
            this.updateCallback.release();
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.recyclerView = recyclerView;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.recyclerView = null;
    }

    public int getItemViewType(int position) {
        if (this.typeCallback == null) {
            return super.getItemViewType(position);
        }
        Object retType = this.typeCallback.call(new Object[]{position});
        if (retType == null) {
            return super.getItemViewType(position);
        }
        return ((Number)retType).intValue();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.createCallback == null) {
            return new ViewHolder(null);
        }
        Object createdViewObj = this.createCallback.call(new Object[]{viewType});
        if (!(createdViewObj instanceof JSValue)) {
            return new ViewHolder(null);
        }
        JSValue createdView = (JSValue)createdViewObj;
        createdView.protect();
        HMBase view = (HMBase)this.instanceManager.get(createdView.getLong("objID"));
        if (view == null) {
            return new ViewHolder(null);
        }
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int position) {
        if (this.updateCallback == null || viewHolder.getJSValue() == null) {
            return;
        }
        this.updateCallback.call(new Object[]{position, viewHolder.getJSValue()});
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setTypeCallback(JSCallback callback) {
        this.typeCallback = callback;
    }

    public void setCreateCallback(JSCallback callback) {
        this.createCallback = callback;
    }

    public void setUpdateCallback(JSCallback callback) {
        this.updateCallback = callback;
    }

    public void refresh(int count) {
        this.refresh(count, false);
    }

    public void refresh(int count, boolean isLoadMore) {
        int lastCount = this.itemCount;
        this.itemCount = count;
        if (isLoadMore && count > lastCount) {
            this.notifyItemRangeInserted(lastCount, count - lastCount);
        } else {
            this.notifyDataSetChanged();
        }
    }

    private void setLayoutParams(View view) {
        RecyclerView.LayoutManager layoutManager = this.recyclerView.getLayoutManager();
        view.setLayoutParams(ListUtil.isVertical(layoutManager) ? new ViewGroup.LayoutParams(-1, -2) : new ViewGroup.LayoutParams(-2, -1));
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private HMBase hmBase;

        public ViewHolder(HMBase hmBase) {
            super(hmBase == null ? new View(HMListAdapter.this.mContext) : hmBase.getView());
            HMListAdapter.this.setLayoutParams(this.itemView);
            this.hmBase = hmBase;
        }

        public JSValue getJSValue() {
            return this.hmBase == null ? null : this.hmBase.getJSValue();
        }

        public HummerNode getNode() {
            return this.hmBase == null ? null : this.hmBase.getNode();
        }
    }
}

