/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.list;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsAttribute;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.component.R;
import com.didi.hummer.component.input.FocusUtil;
import com.didi.hummer.component.input.KeyboardUtil;
import com.didi.hummer.component.list.HMListAdapter;
import com.didi.hummer.component.list.ListUtil;
import com.didi.hummer.component.list.decoration.GridSpacingItemDecoration;
import com.didi.hummer.component.list.decoration.LinearSpacingItemDecoration;
import com.didi.hummer.component.list.decoration.StaggeredGridSpacingItemDecoration;
import com.didi.hummer.component.refresh.HummerFooter;
import com.didi.hummer.component.refresh.HummerHeader;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.core.util.DebugUtil;
import com.didi.hummer.pool.ObjectPool;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.event.base.Event;
import com.didi.hummer.render.event.view.ScrollEvent;
import com.didi.hummer.render.style.HummerNode;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.didi.hummer.render.utility.DPUtil;
import com.didi.hummer.render.utility.YogaNodeUtil;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.android.YogaLayout;
import com.scwang.smart.refresh.layout.SmartRefreshLayout;
import com.scwang.smart.refresh.layout.api.RefreshFooter;
import com.scwang.smart.refresh.layout.api.RefreshHeader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

@Component(value="List")
public class List
extends HMBase<SmartRefreshLayout> {
    private static final int MODE_LIST = 1;
    private static final int MODE_GRID = 2;
    private static final int MODE_WATERFALL = 3;
    private static final int DIRECTION_VERTICAL = 1;
    private static final int DIRECTION_HORIZONTAL = 2;
    private int mode = 1;
    private int direction = 1;
    private int column = 2;
    private int lineSpacing;
    private int itemSpacing;
    private int leftSpacing;
    private int rightSpacing;
    private int topSpacing;
    private int bottomSpacing;
    private boolean needUpdateMode = true;
    private boolean needUpdateLineSpacing = true;
    private boolean needUpdateEdgeSpacing = true;
    private SmartRefreshLayout refreshLayout;
    private HummerHeader hummerHeader;
    private HummerFooter hummerFooter;
    private RecyclerView recyclerView;
    private YogaNode recyclerViewNode;
    private HMListAdapter adapter;
    private RecyclerView.LayoutManager layoutManager;
    private RecyclerView.ItemDecoration itemDecoration;
    private ObjectPool instanceManager;
    private boolean isLoadingMore;
    private boolean isScrollStarted = false;
    private ScrollEvent scrollEvent = new ScrollEvent();
    private RecyclerView.OnScrollListener mOnScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (!List.this.mEventManager.contains("scroll")) {
                return;
            }
            if (!List.this.isScrollStarted) {
                return;
            }
            int offsetX = recyclerView.computeHorizontalScrollOffset();
            int offsetY = recyclerView.computeVerticalScrollOffset();
            List.this.scrollEvent.setType("scroll");
            List.this.scrollEvent.setState(2);
            List.this.scrollEvent.setOffsetX(DPUtil.px2dpF((Context)List.this.getContext(), (float)offsetX));
            List.this.scrollEvent.setOffsetY(DPUtil.px2dpF((Context)List.this.getContext(), (float)offsetY));
            List.this.scrollEvent.setDx(DPUtil.px2dpF((Context)List.this.getContext(), (float)dx));
            List.this.scrollEvent.setDy(DPUtil.px2dpF((Context)List.this.getContext(), (float)dy));
            List.this.scrollEvent.setTimestamp(System.currentTimeMillis());
            List.this.mEventManager.dispatchEvent("scroll", (Event)List.this.scrollEvent);
            List.this.hideKeyboardIfNeed(dx, dy);
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (!List.this.mEventManager.contains("scroll")) {
                return;
            }
            switch (newState) {
                case 0: {
                    List.this.isScrollStarted = false;
                    List.this.scrollEvent.setType("scroll");
                    List.this.scrollEvent.setState(3);
                    List.this.scrollEvent.setOffsetX(0.0f);
                    List.this.scrollEvent.setOffsetY(0.0f);
                    List.this.scrollEvent.setDx(0.0f);
                    List.this.scrollEvent.setDy(0.0f);
                    List.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                    List.this.mEventManager.dispatchEvent("scroll", (Event)List.this.scrollEvent);
                    List.this.refreshNodeTree();
                    break;
                }
                case 1: {
                    List.this.isScrollStarted = true;
                    List.this.scrollEvent.setType("scroll");
                    List.this.scrollEvent.setState(1);
                    List.this.scrollEvent.setOffsetX(0.0f);
                    List.this.scrollEvent.setOffsetY(0.0f);
                    List.this.scrollEvent.setDx(0.0f);
                    List.this.scrollEvent.setDy(0.0f);
                    List.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                    List.this.mEventManager.dispatchEvent("scroll", (Event)List.this.scrollEvent);
                    break;
                }
                case 2: {
                    List.this.scrollEvent.setType("scroll");
                    List.this.scrollEvent.setState(4);
                    List.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                    List.this.mEventManager.dispatchEvent("scroll", (Event)List.this.scrollEvent);
                    break;
                }
            }
        }
    };
    @JsProperty(value="refreshView")
    private HMBase refreshView;
    @JsProperty(value="loadMoreView")
    private HMBase loadMoreView;
    @JsProperty(value="onRefresh")
    private JSCallback refreshCallback;
    @JsProperty(value="onLoadMore")
    private JSCallback loadMoreCallback;
    @JsProperty(value="onRegister")
    private JSCallback onRegister;
    @JsProperty(value="onCreate")
    private JSCallback onCreate;
    @JsProperty(value="onUpdate")
    private JSCallback onUpdate;
    @JsProperty(value="showScrollBar")
    private boolean showScrollBar;
    @JsProperty(value="bounces")
    public boolean bounces;

    public List(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
        this.instanceManager = context.getObjectPool();
    }

    protected SmartRefreshLayout createViewInstance(Context context) {
        this.recyclerView = (RecyclerView)LayoutInflater.from((Context)context).inflate(R.layout.recycler_view, null, false);
        this.recyclerView.setOverScrollMode(2);
        this.recyclerView.setClipChildren(false);
        this.recyclerView.setOnTouchListener((v, event) -> {
            if (event.getAction() == 0) {
                FocusUtil.clearFocus(context);
            }
            return false;
        });
        this.refreshLayout = new SmartRefreshLayout(context);
        this.refreshLayout.setEnableRefresh(false);
        this.refreshLayout.setEnableLoadMore(false);
        this.refreshLayout.setEnableOverScrollDrag(true);
        this.refreshLayout.setRefreshContent((View)this.recyclerView);
        this.hummerHeader = new HummerHeader(context);
        this.hummerFooter = new HummerFooter(context);
        this.refreshLayout.setRefreshHeader((RefreshHeader)this.hummerHeader);
        this.refreshLayout.setRefreshFooter((RefreshFooter)this.hummerFooter);
        this.hummerHeader.setOnRefreshListener(new HummerHeader.OnRefreshListener(){

            @Override
            public void onRefreshStarted() {
                if (List.this.refreshCallback != null) {
                    List.this.refreshCallback.call(new Object[]{1});
                }
            }

            @Override
            public void onRefreshing() {
                if (List.this.refreshCallback != null) {
                    List.this.refreshCallback.call(new Object[]{2});
                }
            }

            @Override
            public void onRefreshFinished() {
                if (List.this.refreshCallback != null) {
                    List.this.refreshCallback.call(new Object[]{0});
                }
            }
        });
        this.hummerFooter.setOnLoadListener(new HummerFooter.OnLoadListener(){

            @Override
            public void onLoadStarted() {
            }

            @Override
            public void onLoading() {
                List.this.isLoadingMore = true;
                if (List.this.loadMoreCallback != null) {
                    List.this.loadMoreCallback.call(new Object[]{1});
                }
            }

            @Override
            public void onLoadFinished() {
            }
        });
        return this.refreshLayout;
    }

    public void onCreate() {
        super.onCreate();
        this.recyclerView.addOnScrollListener(this.mOnScrollListener);
        this.adapter = new HMListAdapter(this.getContext(), this.instanceManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerViewNode = YogaNodeUtil.createYogaNode();
        this.recyclerViewNode.setMeasureFunction((YogaMeasureFunction)new YogaLayout.ViewMeasureFunction());
        this.recyclerViewNode.setData((Object)this.recyclerView);
        this.recyclerViewNode.setFlexGrow(1.0f);
        this.getYogaNode().setMeasureFunction(null);
        this.getYogaNode().addChildAt(this.recyclerViewNode, 0);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.adapter != null) {
            this.adapter.destroy();
        }
    }

    protected void onStyleUpdated(Map<String, Object> newStyle) {
        if (this.needUpdateMode) {
            this.initLayoutManager();
        }
        if (this.needUpdateLineSpacing) {
            this.initLineSpacing();
        }
        if (this.needUpdateEdgeSpacing) {
            this.initEdgeSpacing();
        }
        this.needUpdateMode = false;
        this.needUpdateLineSpacing = false;
        this.needUpdateEdgeSpacing = false;
    }

    private void initLayoutManager() {
        switch (this.mode) {
            default: {
                int orientation = this.direction == 2 ? 0 : 1;
                this.layoutManager = new LinearLayoutManager(this.getContext(), orientation, false);
                break;
            }
            case 2: {
                int orientation = this.direction == 2 ? 0 : 1;
                this.layoutManager = new GridLayoutManager(this.getContext(), this.column, orientation, false);
                break;
            }
            case 3: {
                int orientation = this.direction == 2 ? 0 : 1;
                this.layoutManager = new StaggeredGridLayoutManager(this.column, orientation){
                    private Method markItemDecorInsetsDirty;
                    private boolean reflectError;
                    {
                        this.markItemDecorInsetsDirty = null;
                        this.reflectError = false;
                    }

                    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
                        if (this.markItemDecorInsetsDirty == null && !this.reflectError) {
                            try {
                                this.markItemDecorInsetsDirty = RecyclerView.class.getDeclaredMethod("markItemDecorInsetsDirty", new Class[0]);
                                this.markItemDecorInsetsDirty.setAccessible(true);
                            }
                            catch (NoSuchMethodException e) {
                                e.printStackTrace();
                                this.reflectError = true;
                            }
                        }
                        if (this.markItemDecorInsetsDirty != null && state.willRunSimpleAnimations()) {
                            try {
                                this.markItemDecorInsetsDirty.invoke((Object)List.this.recyclerView, new Object[0]);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                        super.onLayoutChildren(recycler, state);
                    }

                    public void requestSimpleAnimationsInNextLayout() {
                        super.requestSimpleAnimationsInNextLayout();
                        if (this.markItemDecorInsetsDirty != null) {
                            try {
                                this.markItemDecorInsetsDirty.invoke((Object)List.this.recyclerView, new Object[0]);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                break;
            }
        }
        this.recyclerView.setLayoutManager(this.layoutManager);
    }

    private void initLineSpacing() {
        RecyclerView.ItemDecoration oldItemDecoration = this.itemDecoration;
        switch (this.mode) {
            default: {
                if (this.lineSpacing <= 0) break;
                this.itemDecoration = new LinearSpacingItemDecoration(this.lineSpacing, false);
                break;
            }
            case 2: {
                if (this.lineSpacing <= 0 && this.itemSpacing <= 0) break;
                this.itemDecoration = new GridSpacingItemDecoration(this.column, this.lineSpacing, this.itemSpacing, false);
                break;
            }
            case 3: {
                if (this.lineSpacing <= 0 && this.itemSpacing <= 0) break;
                this.itemDecoration = new StaggeredGridSpacingItemDecoration(this.column, this.lineSpacing, this.itemSpacing, false);
            }
        }
        if (this.itemDecoration != null) {
            if (oldItemDecoration != null) {
                this.recyclerView.removeItemDecoration(oldItemDecoration);
            }
            this.recyclerView.addItemDecoration(this.itemDecoration);
        }
    }

    private void initEdgeSpacing() {
        if (this.leftSpacing > 0 || this.rightSpacing > 0 || this.topSpacing > 0 || this.bottomSpacing > 0) {
            this.recyclerView.setPadding(this.leftSpacing, this.topSpacing, this.rightSpacing, this.bottomSpacing);
            this.recyclerView.setClipToPadding(false);
        }
    }

    private void hideKeyboardIfNeed(int dx, int dy) {
        Activity act;
        int d = 0;
        if (this.direction == 1) {
            d = Math.abs(dy);
        } else if (this.direction == 2) {
            d = Math.abs(dx);
        }
        if (d > 20 && ((SmartRefreshLayout)this.getView()).getContext() instanceof Activity && (act = (Activity)((SmartRefreshLayout)this.getView()).getContext()).getCurrentFocus() != null && act.getCurrentFocus().getWindowToken() != null) {
            KeyboardUtil.hideKeyboard(act.getCurrentFocus());
        }
    }

    @JsAttribute(value={"mode"})
    public void setMode(String strMode) {
        int curMode;
        switch (strMode) {
            default: {
                curMode = 1;
                break;
            }
            case "grid": {
                curMode = 2;
                break;
            }
            case "waterfall": {
                curMode = 3;
            }
        }
        if (this.mode != curMode) {
            this.mode = curMode;
            this.needUpdateMode = true;
            if (curMode == 3) {
                if (this.lineSpacing <= 0) {
                    this.lineSpacing = DPUtil.dp2px((Context)this.getContext(), (float)8.0f);
                }
                if (this.itemSpacing <= 0) {
                    this.itemSpacing = DPUtil.dp2px((Context)this.getContext(), (float)8.0f);
                }
                this.needUpdateLineSpacing = true;
            }
        }
    }

    @JsAttribute(value={"scrollDirection"})
    public void setScrollDirection(String strDirection) {
        int curDirection;
        switch (strDirection) {
            default: {
                curDirection = 1;
                break;
            }
            case "horizontal": {
                curDirection = 2;
            }
        }
        if (this.direction != curDirection) {
            this.direction = curDirection;
            this.needUpdateMode = true;
        }
    }

    @JsAttribute(value={"column"})
    public void setColumn(int column) {
        if (this.column != column) {
            this.column = column;
            if (this.mode == 2 || this.mode == 3) {
                this.needUpdateMode = true;
                this.needUpdateLineSpacing = true;
            }
        }
    }

    @JsAttribute(value={"lineSpacing"})
    public void setLineSpacing(int spacing) {
        if (this.lineSpacing != spacing) {
            this.lineSpacing = spacing;
            this.needUpdateLineSpacing = true;
        }
    }

    @JsAttribute(value={"itemSpacing"})
    public void setItemSpacing(int spacing) {
        if (this.itemSpacing != spacing) {
            this.itemSpacing = spacing;
            if (this.mode == 2 || this.mode == 3) {
                this.needUpdateLineSpacing = true;
            }
        }
    }

    @JsAttribute(value={"leftSpacing"})
    public void setLeftSpacing(int spacing) {
        if (this.leftSpacing != spacing) {
            this.leftSpacing = spacing;
            this.needUpdateEdgeSpacing = true;
        }
    }

    @JsAttribute(value={"rightSpacing"})
    public void setRightSpacing(int spacing) {
        if (this.rightSpacing != spacing) {
            this.rightSpacing = spacing;
            this.needUpdateEdgeSpacing = true;
        }
    }

    @JsAttribute(value={"topSpacing"})
    public void setTopSpacing(int spacing) {
        if (this.topSpacing != spacing) {
            this.topSpacing = spacing;
            this.needUpdateEdgeSpacing = true;
        }
    }

    @JsAttribute(value={"bottomSpacing"})
    public void setBottomSpacing(int spacing) {
        if (this.bottomSpacing != spacing) {
            this.bottomSpacing = spacing;
            this.needUpdateEdgeSpacing = true;
        }
    }

    public void setRefreshView(HMBase view) {
        this.refreshView = view;
        this.refreshLayout.setEnableRefresh(true);
        this.hummerHeader.addHeaderView(view);
    }

    public void setLoadMoreView(HMBase view) {
        this.loadMoreView = view;
        this.refreshLayout.setEnableLoadMore(true);
        this.hummerFooter.addFooterView(view);
    }

    public void setOnRefresh(JSCallback callback) {
        this.refreshCallback = callback;
    }

    public void setOnLoadMore(JSCallback callback) {
        this.loadMoreCallback = callback;
    }

    public void setOnRegister(JSCallback onRegister) {
        this.adapter.setTypeCallback(onRegister);
    }

    public void setOnCreate(JSCallback onCreate) {
        this.adapter.setCreateCallback(onCreate);
    }

    public void setOnUpdate(JSCallback onUpdate) {
        this.adapter.setUpdateCallback(onUpdate);
    }

    public void setShowScrollBar(boolean isShow) {
        this.showScrollBar = isShow;
        if (this.direction == 1) {
            this.recyclerView.setVerticalScrollBarEnabled(isShow);
        } else if (this.direction == 2) {
            this.recyclerView.setHorizontalScrollBarEnabled(isShow);
        }
    }

    public void setBounces(boolean bounces) {
        this.refreshLayout.setEnableOverScrollDrag(bounces);
    }

    @JsMethod(value="refresh")
    public void refresh(int count) {
        if (!this.isLoadingMore) {
            this.refreshLayout.resetNoMoreData();
        }
        if (this.recyclerViewNode != null) {
            this.recyclerViewNode.dirty();
        }
        if (this.adapter != null) {
            this.adapter.refresh(count, this.isLoadingMore);
        }
        this.isLoadingMore = false;
        this.refreshNodeTree();
    }

    @JsMethod(value="stopPullRefresh")
    public void stopPullRefresh() {
        this.refreshLayout.finishRefresh(30);
    }

    @JsMethod(value="stopLoadMore")
    public void stopLoadMore(boolean enable) {
        if (enable) {
            this.refreshLayout.finishLoadMore();
            this.refreshLayout.resetNoMoreData();
        } else {
            this.refreshLayout.finishLoadMoreWithNoMoreData();
        }
        if (this.loadMoreCallback != null) {
            this.loadMoreCallback.call(new Object[]{enable ? 0 : 2});
        }
    }

    @JsMethod(value="scrollTo")
    public void scrollTo(Object x, Object y) {
        int nX = (int)HummerStyleUtils.convertNumber((Object)x);
        int nY = (int)HummerStyleUtils.convertNumber((Object)y);
        this.recyclerView.scrollTo(nX, nY);
    }

    @JsMethod(value="scrollBy")
    public void scrollBy(Object dx, Object dy) {
        int nDx = (int)HummerStyleUtils.convertNumber((Object)dx);
        int nDy = (int)HummerStyleUtils.convertNumber((Object)dy);
        this.recyclerView.scrollBy(nDx, nDy);
    }

    @JsMethod(value="scrollToPosition")
    public void scrollToPosition(int position) {
        if (this.layoutManager instanceof LinearLayoutManager) {
            ((LinearLayoutManager)this.layoutManager).scrollToPositionWithOffset(position, 0);
        }
    }

    @JsMethod(value="dbg_getDescription")
    public void dbg_getDescription(JSCallback callback, int depth) {
        this.refreshNodeTree();
        super.dbg_getDescription(callback, depth);
    }

    private void refreshNodeTree() {
        if (!DebugUtil.isDebuggable()) {
            return;
        }
        ((SmartRefreshLayout)this.getView()).post(() -> {
            this.getNode().removeAll();
            if (this.refreshView != null) {
                this.refreshView.getNode().setAlias("Header");
                this.getNode().appendChild(this.refreshView.getNode());
            }
            int firstPosition = ListUtil.getFirstVisibleItemPosition(this.layoutManager);
            int lastPosition = ListUtil.getLastVisibleItemPosition(this.layoutManager);
            for (int i = firstPosition; i <= lastPosition; ++i) {
                HummerNode node;
                RecyclerView.ViewHolder vh = this.recyclerView.findViewHolderForAdapterPosition(i);
                if (!(vh instanceof HMListAdapter.ViewHolder) || (node = ((HMListAdapter.ViewHolder)vh).getNode()) == null) continue;
                node.setAlias(String.valueOf(i));
                this.getNode().appendChild(node);
            }
            if (this.loadMoreView != null) {
                this.loadMoreView.getNode().setAlias("Footer");
                this.getNode().appendChild(this.loadMoreView.getNode());
            }
        });
    }

    public void resetStyle() {
        super.resetStyle();
        this.setMode("list");
        this.setScrollDirection("vertical");
        this.setColumn(2);
        this.setShowScrollBar(false);
    }

    public boolean setStyle(String key, Object value) {
        switch (key) {
            case "mode": {
                this.setMode(String.valueOf(value));
                break;
            }
            case "scrollDirection": {
                this.setScrollDirection(String.valueOf(value));
                break;
            }
            case "column": {
                this.setColumn((int)((Float)value).floatValue());
                break;
            }
            case "lineSpacing": {
                this.setLineSpacing((int)((Float)value).floatValue());
                break;
            }
            case "itemSpacing": {
                this.setItemSpacing((int)((Float)value).floatValue());
                break;
            }
            case "leftSpacing": {
                this.setLeftSpacing((int)((Float)value).floatValue());
                break;
            }
            case "rightSpacing": {
                this.setRightSpacing((int)((Float)value).floatValue());
                break;
            }
            case "topSpacing": {
                this.setTopSpacing((int)((Float)value).floatValue());
                break;
            }
            case "bottomSpacing": {
                this.setBottomSpacing((int)((Float)value).floatValue());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

