/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.list.decoration;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.didi.hummer.component.list.ListUtil;

public class LinearSpacingItemDecoration
extends RecyclerView.ItemDecoration {
    private int space;
    private boolean includeEdge;

    public LinearSpacingItemDecoration(int space, boolean includeEdge) {
        this.space = space;
        this.includeEdge = includeEdge;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (ListUtil.isVertical(parent.getLayoutManager())) {
            if (this.includeEdge) {
                outRect.left = this.space;
                outRect.right = this.space;
                outRect.bottom = this.space;
                outRect.top = parent.getChildLayoutPosition(view) == 0 ? this.space : 0;
            } else if (parent.getChildLayoutPosition(view) > 0) {
                outRect.top = this.space;
            }
        } else if (this.includeEdge) {
            outRect.top = this.space;
            outRect.bottom = this.space;
            outRect.right = this.space;
            outRect.left = parent.getChildLayoutPosition(view) == 0 ? this.space : 0;
        } else if (parent.getChildLayoutPosition(view) > 0) {
            outRect.left = this.space;
        }
    }
}

