/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.list.decoration;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import com.didi.hummer.component.list.ListUtil;

public class StaggeredGridSpacingItemDecoration
extends RecyclerView.ItemDecoration {
    private int spanCount;
    private int lineSpacing;
    private int itemSpacing;
    private boolean includeEdge;

    public StaggeredGridSpacingItemDecoration(int spanCount, int spacing, boolean includeEdge) {
        this(spanCount, spacing, spacing, includeEdge);
    }

    public StaggeredGridSpacingItemDecoration(int spanCount, int lineSpacing, int itemSpacing, boolean includeEdge) {
        this.spanCount = spanCount;
        this.lineSpacing = lineSpacing;
        this.itemSpacing = itemSpacing;
        this.includeEdge = includeEdge;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        StaggeredGridLayoutManager.LayoutParams lp = (StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams();
        int column = lp.getSpanIndex();
        int position = parent.getChildAdapterPosition(view);
        if (ListUtil.isVertical(parent.getLayoutManager())) {
            if (this.includeEdge) {
                outRect.left = this.itemSpacing - column * this.itemSpacing / this.spanCount;
                outRect.right = (column + 1) * this.itemSpacing / this.spanCount;
                if (position < this.spanCount) {
                    outRect.top = this.lineSpacing;
                }
                outRect.bottom = this.lineSpacing;
            } else {
                outRect.left = column * this.itemSpacing / this.spanCount;
                outRect.right = this.itemSpacing - (column + 1) * this.itemSpacing / this.spanCount;
                if (position >= this.spanCount) {
                    outRect.top = this.lineSpacing;
                }
            }
        } else if (this.includeEdge) {
            outRect.top = this.itemSpacing - column * this.itemSpacing / this.spanCount;
            outRect.bottom = (column + 1) * this.itemSpacing / this.spanCount;
            if (position < this.spanCount) {
                outRect.left = this.lineSpacing;
            }
            outRect.right = this.lineSpacing;
        } else {
            outRect.top = column * this.itemSpacing / this.spanCount;
            outRect.bottom = this.itemSpacing - (column + 1) * this.itemSpacing / this.spanCount;
            if (position >= this.spanCount) {
                outRect.left = this.lineSpacing;
            }
        }
    }
}

