/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.refresh;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerLayout;
import com.scwang.smart.refresh.layout.api.RefreshFooter;
import com.scwang.smart.refresh.layout.api.RefreshLayout;
import com.scwang.smart.refresh.layout.constant.RefreshState;
import com.scwang.smart.refresh.layout.simple.SimpleComponent;

public class HummerFooter
extends SimpleComponent
implements RefreshFooter {
    private OnLoadListener mOnLoadListener;

    public HummerFooter(Context context) {
        this(context, null);
    }

    public HummerFooter(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HummerFooter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void addFooterView(HMBase footView) {
        HummerLayout layout2 = new HummerLayout(footView.getContext());
        layout2.addView(footView);
        this.addView((View)layout2, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
    }

    public void setOnLoadListener(OnLoadListener listener) {
        this.mOnLoadListener = listener;
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        switch (newState) {
            case PullUpToLoad: {
                if (this.mOnLoadListener == null) break;
                this.mOnLoadListener.onLoadStarted();
                break;
            }
            case ReleaseToLoad: {
                break;
            }
            case LoadReleased: {
                break;
            }
            case Loading: {
                if (this.mOnLoadListener == null) break;
                this.mOnLoadListener.onLoading();
                break;
            }
            case LoadFinish: {
                if (this.mOnLoadListener == null) break;
                this.mOnLoadListener.onLoadFinished();
                break;
            }
        }
    }

    public static interface OnLoadListener {
        public void onLoadStarted();

        public void onLoading();

        public void onLoadFinished();
    }
}

