/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.refresh;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerLayout;
import com.scwang.smart.refresh.layout.api.RefreshHeader;
import com.scwang.smart.refresh.layout.api.RefreshLayout;
import com.scwang.smart.refresh.layout.constant.RefreshState;
import com.scwang.smart.refresh.layout.simple.SimpleComponent;

public class HummerHeader
extends SimpleComponent
implements RefreshHeader {
    private OnRefreshListener mOnRefreshListener;

    public HummerHeader(Context context) {
        this(context, null);
    }

    public HummerHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HummerHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void addHeaderView(HMBase headerView) {
        HummerLayout layout2 = new HummerLayout(headerView.getContext());
        layout2.addView(headerView);
        this.addView((View)layout2, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mOnRefreshListener = listener;
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        super.onStateChanged(refreshLayout, oldState, newState);
        switch (newState) {
            case PullDownToRefresh: {
                if (this.mOnRefreshListener == null) break;
                this.mOnRefreshListener.onRefreshStarted();
                break;
            }
            case ReleaseToRefresh: {
                break;
            }
            case RefreshReleased: {
                if (this.mOnRefreshListener == null) break;
                this.mOnRefreshListener.onRefreshing();
                break;
            }
            case Refreshing: {
                break;
            }
            case RefreshFinish: {
                if (this.mOnRefreshListener == null) break;
                this.mOnRefreshListener.onRefreshFinished();
                break;
            }
        }
    }

    public static interface OnRefreshListener {
        public void onRefreshStarted();

        public void onRefreshing();

        public void onRefreshFinished();
    }
}

