/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.scroller;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.component.R;
import com.didi.hummer.component.scroller.HScrollView;
import com.didi.hummer.component.scroller.OnScrollListener;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.render.component.view.FixedNoneBox;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.event.base.Event;
import com.didi.hummer.render.event.view.ScrollEvent;
import com.didi.hummer.render.style.HummerLayout;
import com.didi.hummer.render.style.HummerLayoutExtendUtils;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.didi.hummer.render.utility.DPUtil;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaOverflow;
import com.facebook.yoga.YogaUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="HorizontalScroller")
public class HorizontalScroller
extends HMBase<HScrollView>
implements HMBase.PositionChangedListener {
    private HummerLayout layout;
    private JSCallback onScrollToTopListener;
    private JSCallback onScrollToBottomListener;
    private HummerContext hummerContext;
    private ScrollEvent scrollEvent = new ScrollEvent();
    private List<HMBase> children = new ArrayList<HMBase>();
    private Map<HMBase, FixedNoneBox> fixedNoneBoxMap = new HashMap<HMBase, FixedNoneBox>();
    @JsProperty(value="showScrollBar")
    private boolean showScrollBar;
    @JsProperty(value="bounces")
    public boolean bounces;

    public HorizontalScroller(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
        this.hummerContext = context;
    }

    protected HScrollView createViewInstance(Context context) {
        HScrollView scrollView = (HScrollView)LayoutInflater.from((Context)context).inflate(R.layout.horizontal_scroll_view, null, false);
        scrollView.setClipChildren(false);
        scrollView.setFillViewport(true);
        return scrollView;
    }

    public void onCreate() {
        super.onCreate();
        this.initScrollView();
    }

    public void onDestroy() {
        super.onDestroy();
        ((HScrollView)this.getView()).release();
    }

    protected void onStyleUpdated(Map<String, Object> newStyle) {
        this.layout.getYogaNode().copyStyle(this.getYogaNode());
        this.layout.getYogaNode().setFlexDirection(YogaFlexDirection.ROW);
        this.adjustWidthAndHeight();
        this.adjustMinMaxWidthAndHeight();
    }

    private void initScrollView() {
        this.layout = new HummerLayout(this.getContext());
        this.layout.getYogaNode().setFlexDirection(YogaFlexDirection.ROW);
        this.layout.addOnLayoutChangeListener((v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> this.adjustWidthAndHeight());
        ((HScrollView)this.getView()).addView((View)this.layout);
        this.getYogaNode().setOverflow(YogaOverflow.SCROLL);
        this.getYogaNode().setMeasureFunction(null);
        this.getYogaNode().addChildAt(this.layout.getYogaNode(), 0);
        ((HScrollView)this.getView()).setHorizontalScrollBarEnabled(false);
        ((HScrollView)this.getView()).setOnScrollListener(new OnScrollListener(){

            @Override
            public void onScrollStarted() {
                if (!HorizontalScroller.this.mEventManager.contains("scroll")) {
                    return;
                }
                HorizontalScroller.this.scrollEvent.setType("scroll");
                HorizontalScroller.this.scrollEvent.setState(1);
                HorizontalScroller.this.scrollEvent.setOffsetX(0.0f);
                HorizontalScroller.this.scrollEvent.setOffsetY(0.0f);
                HorizontalScroller.this.scrollEvent.setDx(0.0f);
                HorizontalScroller.this.scrollEvent.setDy(0.0f);
                HorizontalScroller.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                HorizontalScroller.this.mEventManager.dispatchEvent("scroll", (Event)HorizontalScroller.this.scrollEvent);
            }

            @Override
            public void onScrollFinished() {
                if (!HorizontalScroller.this.mEventManager.contains("scroll")) {
                    return;
                }
                HorizontalScroller.this.scrollEvent.setType("scroll");
                HorizontalScroller.this.scrollEvent.setState(3);
                HorizontalScroller.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                HorizontalScroller.this.mEventManager.dispatchEvent("scroll", (Event)HorizontalScroller.this.scrollEvent);
            }

            @Override
            public void onScrollUp() {
                if (!HorizontalScroller.this.mEventManager.contains("scroll")) {
                    return;
                }
                HorizontalScroller.this.scrollEvent.setType("scroll");
                HorizontalScroller.this.scrollEvent.setState(4);
                HorizontalScroller.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                HorizontalScroller.this.mEventManager.dispatchEvent("scroll", (Event)HorizontalScroller.this.scrollEvent);
            }

            @Override
            public void onScrollChanged(View scrollView, int x, int y, int dx, int dy) {
                if (!HorizontalScroller.this.mEventManager.contains("scroll")) {
                    return;
                }
                HorizontalScroller.this.scrollEvent.setType("scroll");
                HorizontalScroller.this.scrollEvent.setState(2);
                HorizontalScroller.this.scrollEvent.setOffsetX(DPUtil.px2dpF((Context)HorizontalScroller.this.getContext(), (float)x));
                HorizontalScroller.this.scrollEvent.setOffsetY(DPUtil.px2dpF((Context)HorizontalScroller.this.getContext(), (float)y));
                HorizontalScroller.this.scrollEvent.setDx(DPUtil.px2dpF((Context)HorizontalScroller.this.getContext(), (float)dx));
                HorizontalScroller.this.scrollEvent.setDy(DPUtil.px2dpF((Context)HorizontalScroller.this.getContext(), (float)dy));
                HorizontalScroller.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                HorizontalScroller.this.mEventManager.dispatchEvent("scroll", (Event)HorizontalScroller.this.scrollEvent);
            }
        });
        ((HScrollView)this.getView()).setOnScrollToTopListener(() -> {
            if (this.onScrollToTopListener != null) {
                this.onScrollToTopListener.call(new Object[0]);
            }
        });
        ((HScrollView)this.getView()).setOnScrollToBottomListener(() -> {
            if (this.onScrollToBottomListener != null) {
                this.onScrollToBottomListener.call(new Object[0]);
            }
        });
    }

    private void adjustWidthAndHeight() {
        if (this.getYogaNode().getWidth().unit == YogaUnit.AUTO) {
            this.layout.getYogaNode().setWidthAuto();
        } else {
            this.layout.getYogaNode().setWidthPercent(100.0f);
        }
        if (this.getYogaNode().getHeight().unit == YogaUnit.AUTO) {
            this.layout.getYogaNode().setHeightAuto();
        } else {
            this.layout.getYogaNode().setHeightPercent(100.0f);
        }
    }

    private void adjustMinMaxWidthAndHeight() {
        this.layout.getYogaNode().setMinWidth(Float.NaN);
        this.layout.getYogaNode().setMaxWidth(Float.NaN);
        this.layout.getYogaNode().setMinHeight(Float.NaN);
        this.layout.getYogaNode().setMaxHeight(Float.NaN);
    }

    @JsMethod(value="appendChild")
    public void appendChild(HMBase child) {
        if (child == null) {
            return;
        }
        child.getJSValue().protect();
        child.setPositionChangedListener((HMBase.PositionChangedListener)this);
        this.children.add(child);
        HMBase finalChild = child;
        this.getNode().appendChild(child.getNode());
        if (child.getPosition() == HummerLayoutExtendUtils.Position.FIXED) {
            this.hummerContext.getContainer().addView(child);
            FixedNoneBox fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            finalChild = fixedNoneBox;
        }
        this.layout.addView(finalChild);
    }

    @JsMethod(value="removeChild")
    public void removeChild(HMBase child) {
        if (child == null) {
            return;
        }
        child.getJSValue().unprotect();
        child.setPositionChangedListener(null);
        this.children.remove(child);
        this.getNode().removeChild(child.getNode());
        if (this.fixedNoneBoxMap.containsKey(child)) {
            FixedNoneBox noneBox = this.fixedNoneBoxMap.remove(child);
            this.hummerContext.getContainer().removeView(child);
            this.layout.removeView((HMBase)noneBox);
            return;
        }
        this.layout.removeView(child);
    }

    @JsMethod(value="removeAll")
    public void removeAll() {
        for (Map.Entry<HMBase, FixedNoneBox> entry : this.fixedNoneBoxMap.entrySet()) {
            HMBase hmBase = entry.getKey();
            FixedNoneBox noneBox = entry.getValue();
            this.hummerContext.getContainer().removeView(hmBase);
            this.layout.removeView((HMBase)noneBox);
        }
        this.fixedNoneBoxMap.clear();
        for (HMBase hmBase : this.children) {
            hmBase.getJSValue().unprotect();
            hmBase.setPositionChangedListener(null);
        }
        this.children.clear();
        this.getNode().removeAll();
        this.layout.removeAllViews();
    }

    @JsMethod(value="insertBefore")
    public void insertBefore(HMBase child, HMBase existing) {
        if (child == null || existing == null) {
            return;
        }
        child.getJSValue().protect();
        child.setPositionChangedListener((HMBase.PositionChangedListener)this);
        this.children.add(child);
        HMBase finalChild = child;
        HMBase finalExisting = existing;
        this.getNode().insertBefore(child.getNode(), existing.getNode());
        if (child.getPosition() == HummerLayoutExtendUtils.Position.FIXED) {
            this.hummerContext.getContainer().addView(child);
            FixedNoneBox fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            finalChild = fixedNoneBox;
        }
        if (this.fixedNoneBoxMap.containsKey(existing)) {
            finalExisting = (HMBase)this.fixedNoneBoxMap.get(existing);
        }
        this.layout.insertBefore(finalChild, finalExisting);
    }

    @JsMethod(value="replaceChild")
    public void replaceChild(HMBase child, HMBase old) {
        if (child == null || old == null) {
            return;
        }
        child.getJSValue().protect();
        child.setPositionChangedListener((HMBase.PositionChangedListener)this);
        old.getJSValue().unprotect();
        old.setPositionChangedListener(null);
        this.children.add(child);
        this.children.remove(old);
        HMBase finalChild = child;
        HMBase finalOld = old;
        this.getNode().replaceChild(child.getNode(), old.getNode());
        if (child.getPosition() == HummerLayoutExtendUtils.Position.FIXED) {
            this.hummerContext.getContainer().addView(child);
            FixedNoneBox fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            finalChild = fixedNoneBox;
        }
        if (this.fixedNoneBoxMap.containsKey(old)) {
            this.hummerContext.getContainer().removeView(old);
            finalOld = (HMBase)this.fixedNoneBoxMap.get(old);
        }
        this.layout.replaceView(finalChild, finalOld);
    }

    @Deprecated
    @JsMethod(value="getElementById")
    public HMBase getSubview(String viewID) {
        HMBase result = this.layout.getViewById(viewID);
        if (result == null) {
            for (Map.Entry<HMBase, FixedNoneBox> entry : this.fixedNoneBoxMap.entrySet()) {
                HMBase hmBase = entry.getKey();
                if (!hmBase.getViewID().equals(viewID)) continue;
                result = hmBase;
                break;
            }
        }
        if (result != null) {
            result.getJSValue().protect();
        }
        return result;
    }

    @Deprecated
    @JsMethod(value="layout")
    public void layout() {
        this.layout.requestLayout();
    }

    public void setShowScrollBar(boolean isShow) {
        ((HScrollView)this.getView()).setHorizontalScrollBarEnabled(isShow);
    }

    @JsMethod(value="scrollTo")
    public void scrollTo(Object x, Object y) {
        int nX = (int)HummerStyleUtils.convertNumber((Object)x);
        int nY = (int)HummerStyleUtils.convertNumber((Object)y);
        ((HScrollView)this.getView()).smoothScrollTo(nX, nY);
    }

    @JsMethod(value="scrollBy")
    public void scrollBy(Object dx, Object dy) {
        int nDx = (int)HummerStyleUtils.convertNumber((Object)dx);
        int nDy = (int)HummerStyleUtils.convertNumber((Object)dy);
        ((HScrollView)this.getView()).smoothScrollBy(nDx, nDy);
    }

    @JsMethod(value="scrollToTop")
    public void scrollToTop() {
        ((HScrollView)this.getView()).fullScroll(17);
    }

    @JsMethod(value="scrollToBottom")
    public void scrollToBottom() {
        ((HScrollView)this.getView()).fullScroll(66);
    }

    @JsMethod(value="setOnScrollToTopListener")
    public void setOnScrollToTopListener(JSCallback callback) {
        this.onScrollToTopListener = callback;
    }

    @JsMethod(value="setOnScrollToBottomListener")
    public void setOnScrollToBottomListener(JSCallback callback) {
        this.onScrollToBottomListener = callback;
    }

    @Deprecated
    @JsMethod(value="updateContentSize")
    public void updateContentSize() {
    }

    public void dispatchChildPositionChanged(HMBase child, HummerLayoutExtendUtils.Position origin, HummerLayoutExtendUtils.Position replace) {
        FixedNoneBox fixedNoneBox;
        if (origin == HummerLayoutExtendUtils.Position.FIXED && replace == HummerLayoutExtendUtils.Position.YOGA && this.fixedNoneBoxMap.containsKey(child)) {
            fixedNoneBox = this.fixedNoneBoxMap.remove(child);
            this.hummerContext.getContainer().removeView(child);
            this.layout.replaceView(child, (HMBase)fixedNoneBox);
        }
        if (origin == HummerLayoutExtendUtils.Position.YOGA && replace == HummerLayoutExtendUtils.Position.FIXED) {
            fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            this.layout.replaceView((HMBase)fixedNoneBox, child);
            this.hummerContext.getContainer().addView(child);
        }
    }

    public void resetStyle() {
        super.resetStyle();
        this.setShowScrollBar(false);
    }
}

