/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.scroller;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.MotionEvent;

public class ScrollViewStateObserver {
    private static final int CHECK_SCROLL_STOP_DELAY_MILLIS = 40;
    private static final int MSG_SCROLL = 1;
    private int mCurScroll = 0;
    private boolean mIsScrollStarted = false;
    private boolean mIsTouched = false;
    private int mScrollState = 0;
    private OnScrollStateListener mOnScrollStateListener;
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){
        private int mLastScroll = Integer.MIN_VALUE;

        public boolean handleMessage(Message msg) {
            if (msg.what == 1) {
                int scroll = ScrollViewStateObserver.this.mCurScroll;
                if (!ScrollViewStateObserver.this.mIsTouched && this.mLastScroll == scroll) {
                    this.mLastScroll = Integer.MIN_VALUE;
                    ScrollViewStateObserver.this.setScrollState(4);
                } else {
                    this.mLastScroll = scroll;
                    ScrollViewStateObserver.this.restartCheckStopTiming();
                }
                return true;
            }
            return false;
        }
    });

    private void restartCheckStopTiming() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, 40L);
    }

    public void release() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public void setOnScrollStateListener(OnScrollStateListener listener) {
        this.mOnScrollStateListener = listener;
    }

    public void onInterceptTouchEvent(MotionEvent ev) {
        this.handleDownEvent(ev);
    }

    public void onTouchEvent(MotionEvent ev) {
        this.handleUpEvent(ev);
    }

    public void onScrollChanged(int scroll, int oldScroll) {
        this.mCurScroll = scroll;
        if (!this.mIsScrollStarted) {
            this.mIsScrollStarted = true;
            this.setScrollState(1);
        }
        if (this.mIsTouched) {
            this.setScrollState(2);
        } else {
            this.setScrollState(3);
        }
    }

    private void handleDownEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mIsScrollStarted = false;
                this.mIsTouched = true;
            }
        }
    }

    private void handleUpEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 1: 
            case 3: {
                this.mIsTouched = false;
                this.restartCheckStopTiming();
            }
        }
    }

    private void setScrollState(int state) {
        if (this.mScrollState != state) {
            this.mScrollState = state;
            if (this.mOnScrollStateListener != null) {
                this.mOnScrollStateListener.onScrollStateChanged(state);
            }
        }
    }

    public static interface OnScrollStateListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_SCROLL_START = 1;
        public static final int SCROLL_STATE_SCROLLING = 2;
        public static final int SCROLL_STATE_SCROLL_TOUCH_UP = 3;
        public static final int SCROLL_STATE_SCROLL_FINISH = 4;

        public void onScrollStateChanged(int var1);
    }
}

